/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform.servlet;

import java.net.MalformedURLException;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ObjectModel;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.servlet.EverrestApplication;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.core.util.Logger;
import org.everrest.exoplatform.ExoDependencySupplier;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.StandaloneContainer;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public abstract class EverrestExoContextListener
implements ServletContextListener {
    protected ResourceBinderImpl resources;
    protected ApplicationProviderBinder providers;

    public final void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        EverrestServletContextInitializer everrestInitializer = new EverrestServletContextInitializer(servletContext);
        this.resources = new ResourceBinderImpl();
        this.providers = new ApplicationProviderBinder();
        ExoDependencySupplier dependencySupplier = new ExoDependencySupplier();
        EverrestConfiguration config = everrestInitializer.getConfiguration();
        Application application = everrestInitializer.getApplication();
        EverrestApplication everrest = new EverrestApplication(config);
        everrest.addApplication(application);
        EverrestProcessor processor = new EverrestProcessor((ResourceBinder)this.resources, (ProviderBinder)this.providers, (DependencySupplier)dependencySupplier, config, (Application)everrest);
        processor.start();
        servletContext.setAttribute(EverrestConfiguration.class.getName(), (Object)config);
        servletContext.setAttribute(DependencySupplier.class.getName(), (Object)dependencySupplier);
        servletContext.setAttribute(ResourceBinder.class.getName(), (Object)this.resources);
        servletContext.setAttribute(ApplicationProviderBinder.class.getName(), (Object)this.providers);
        servletContext.setAttribute(EverrestProcessor.class.getName(), (Object)processor);
        this.processComponents(servletContext);
    }

    protected void processComponents(ServletContext servletContext) {
        Collection adapters;
        ExoContainer container = this.getContainer(servletContext);
        if (container != null && (adapters = container.getComponentAdapters()) != null && !adapters.isEmpty()) {
            ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
            ComponentLifecycleScope lifeCycle = ComponentLifecycleScope.SINGLETON;
            for (Object o : adapters) {
                ComponentAdapter componentAdapter = (ComponentAdapter)o;
                Class clazz = componentAdapter.getComponentImplementation();
                if (clazz.isAnnotationPresent(Provider.class)) {
                    ProviderDescriptorImpl pDescriptor = new ProviderDescriptorImpl(clazz, lifeCycle);
                    pDescriptor.accept((ResourceDescriptorVisitor)rdv);
                    if (ContextResolver.class.isAssignableFrom(clazz)) {
                        this.providers.addContextResolver((ObjectFactory)new SingletonObjectFactory((ObjectModel)pDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
                    }
                    if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                        this.providers.addExceptionMapper((ObjectFactory)new SingletonObjectFactory((ObjectModel)pDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
                    }
                    if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                        this.providers.addMessageBodyReader((ObjectFactory)new SingletonObjectFactory((ObjectModel)pDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
                    }
                    if (!MessageBodyWriter.class.isAssignableFrom(clazz)) continue;
                    this.providers.addMessageBodyWriter((ObjectFactory)new SingletonObjectFactory((ObjectModel)pDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
                    continue;
                }
                if (clazz.isAnnotationPresent(Filter.class)) {
                    FilterDescriptorImpl fDescriptor = new FilterDescriptorImpl(clazz, lifeCycle);
                    fDescriptor.accept((ResourceDescriptorVisitor)rdv);
                    if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                        this.providers.addMethodInvokerFilter((ObjectFactory)new SingletonObjectFactory((ObjectModel)fDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
                    }
                    if (RequestFilter.class.isAssignableFrom(clazz)) {
                        this.providers.addRequestFilter((ObjectFactory)new SingletonObjectFactory((ObjectModel)fDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
                    }
                    if (!ResponseFilter.class.isAssignableFrom(clazz)) continue;
                    this.providers.addResponseFilter((ObjectFactory)new SingletonObjectFactory((ObjectModel)fDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
                    continue;
                }
                if (!clazz.isAnnotationPresent(Path.class)) continue;
                AbstractResourceDescriptorImpl rDescriptor = new AbstractResourceDescriptorImpl(clazz, lifeCycle);
                rDescriptor.accept((ResourceDescriptorVisitor)rdv);
                this.resources.addResource((ObjectFactory)new SingletonObjectFactory((ObjectModel)rDescriptor, componentAdapter.getComponentInstance((PicoContainer)container)));
            }
        }
    }

    protected abstract ExoContainer getContainer(ServletContext var1);

    public void contextDestroyed(ServletContextEvent sce) {
        this.makeFileCollectorDestroyer().stopFileCollector();
        ServletContext servletContext = sce.getServletContext();
        EverrestProcessor processor = (EverrestProcessor)servletContext.getAttribute(EverrestProcessor.class.getName());
        if (processor != null) {
            processor.stop();
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    public static class StandaloneContainerStarter
    extends EverrestExoContextListener {
        public static final String CONFIGURATION_PATH = "everrest.exoplatform.standalone.config";
        public static final String PREFIX_WAR = "war:";
        private static final Logger LOG = Logger.getLogger(StandaloneContainerStarter.class);
        private StandaloneContainer container;

        @Override
        protected ExoContainer getContainer(ServletContext servletContext) {
            String configurationURL = servletContext.getInitParameter(CONFIGURATION_PATH);
            if (configurationURL != null) {
                if (configurationURL.startsWith(PREFIX_WAR)) {
                    try {
                        configurationURL = servletContext.getResource(configurationURL.substring(PREFIX_WAR.length())).toExternalForm();
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Error of configurationURL read. ", (Throwable)e);
                    }
                }
            } else {
                configurationURL = System.getProperty(CONFIGURATION_PATH);
            }
            try {
                StandaloneContainer.addConfigurationURL((String)configurationURL);
            }
            catch (MalformedURLException e1) {
                try {
                    StandaloneContainer.addConfigurationPath((String)configurationURL);
                }
                catch (MalformedURLException e2) {
                    LOG.error("Error of addConfiguration. ", (Throwable)e2);
                }
            }
            try {
                this.container = StandaloneContainer.getInstance((ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                LOG.error("Error of StandaloneContainer initialization. ", (Throwable)e);
            }
            return this.container;
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            if (this.container != null) {
                this.container.stop();
            }
            super.contextDestroyed(sce);
        }
    }

    public static class DefaultListener
    extends EverrestExoContextListener {
        @Override
        protected ExoContainer getContainer(ServletContext servletContext) {
            return null;
        }
    }
}

