/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;

@Provider
public class ExoAsynchronousJobPool
extends AsynchronousJobPool
implements ContextResolver<AsynchronousJobPool> {
    public ExoAsynchronousJobPool(EverrestConfiguration config) {
        super(config);
    }

    protected Callable<Object> newCallable(Object resource, Method method, Object[] params) {
        return new CallableWrapper(super.newCallable(resource, method, params));
    }

    private static class CallableWrapper
    implements Callable<Object> {
        private final ConversationState state;
        private final Callable<Object> callable;

        public CallableWrapper(Callable<Object> callable) {
            this.callable = callable;
            this.state = ConversationState.getCurrent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            ConversationState.setCurrent((ConversationState)(this.state == null ? new ConversationState(new Identity(IdentityConstants.ANONIM)) : this.state));
            try {
                Object object = this.callable.call();
                return object;
            }
            finally {
                ConversationState.setCurrent(null);
            }
        }
    }
}

