/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.Filter;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResponseFilter;
import org.everrest.core.method.MethodInvokerFilter;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.spi.ComponentAdapter;
import org.picocontainer.Startable;

public final class StartableApplication
extends Application
implements Startable {
    private final ExoContainer container;
    private final Set<Class<?>> cls = Collections.emptySet();
    private final Set<Object> singletons = new HashSet<Object>();

    public StartableApplication(ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
    }

    public Set<Class<?>> getClasses() {
        return this.cls;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void start() {
        Collection adapters = this.container.getComponentAdapters();
        if (adapters != null && !adapters.isEmpty()) {
            for (Object o : adapters) {
                ComponentAdapter componentAdapter = (ComponentAdapter)o;
                Class clazz = componentAdapter.getComponentImplementation();
                if (clazz.getAnnotation(Provider.class) != null) {
                    if (ContextResolver.class.isAssignableFrom(clazz)) {
                        this.singletons.add(componentAdapter.getComponentInstance());
                    }
                    if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                        this.singletons.add(componentAdapter.getComponentInstance());
                    }
                    if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                        this.singletons.add(componentAdapter.getComponentInstance());
                    }
                    if (!MessageBodyWriter.class.isAssignableFrom(clazz)) continue;
                    this.singletons.add(componentAdapter.getComponentInstance());
                    continue;
                }
                if (clazz.getAnnotation(Filter.class) != null) {
                    if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                        this.singletons.add(componentAdapter.getComponentInstance());
                    }
                    if (RequestFilter.class.isAssignableFrom(clazz)) {
                        this.singletons.add(componentAdapter.getComponentInstance());
                    }
                    if (!ResponseFilter.class.isAssignableFrom(clazz)) continue;
                    this.singletons.add(componentAdapter.getComponentInstance());
                    continue;
                }
                if (clazz.getAnnotation(Path.class) == null) continue;
                this.singletons.add(componentAdapter.getComponentInstance());
            }
        }
    }

    public void stop() {
    }
}

