/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.everrest.core.Filter;
import org.everrest.core.impl.header.MediaTypeHelper;
import org.everrest.core.uri.UriPattern;
import org.everrest.exoplatform.container.ComponentsFinder;
import org.everrest.exoplatform.container.RestfulComponentAdapter;
import org.everrest.exoplatform.container.RestfulComponentAdapterFactory;
import org.exoplatform.container.ConcurrentPicoContainer;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

public class RestfulContainer
extends ConcurrentPicoContainer
implements Providers {
    private volatile Map<Key, ComponentAdapter> restToComponentAdapters = new HashMap<Key, ComponentAdapter>();
    private final Lock lock = new ReentrantLock();

    public RestfulContainer() {
        this((ComponentAdapterFactory)new DefaultComponentAdapterFactory(), null);
    }

    protected RestfulContainer(PicoContainer parent) {
        this((ComponentAdapterFactory)new DefaultComponentAdapterFactory(), parent);
    }

    protected RestfulContainer(ComponentAdapterFactory factory, PicoContainer parent) {
        super(RestfulContainer.wrapComponentAdapterFactory(factory), parent);
    }

    private static ComponentAdapterFactory wrapComponentAdapterFactory(ComponentAdapterFactory componentAdapterFactory) {
        return new RestfulComponentAdapterFactory(componentAdapterFactory);
    }

    private static List<Key> makeKeys(RestfulComponentAdapter componentAdapter) {
        Class type = componentAdapter.getComponentImplementation();
        if (!type.isAnnotationPresent(Filter.class)) {
            if (type.isAnnotationPresent(Path.class)) {
                ArrayList<Key> keys = new ArrayList<Key>(1);
                keys.add(new ResourceKey(new UriPattern(type.getAnnotation(Path.class).value())));
                return keys;
            }
            if (type.isAnnotationPresent(Provider.class)) {
                ParameterizedType[] implementedInterfaces = componentAdapter.getImplementedInterfaces();
                ArrayList<Key> keys = new ArrayList<Key>(implementedInterfaces.length);
                for (int i = 0; i < implementedInterfaces.length; ++i) {
                    ParameterizedType genericInterface = implementedInterfaces[i];
                    Class rawType = (Class)genericInterface.getRawType();
                    HashSet<MediaType> consumes = MessageBodyReader.class == rawType ? new HashSet<MediaType>(MediaTypeHelper.createConsumesList((Consumes)type.getAnnotation(Consumes.class))) : null;
                    HashSet<MediaType> produces = ContextResolver.class == rawType || MessageBodyWriter.class == rawType ? new HashSet<MediaType>(MediaTypeHelper.createProducesList((Produces)type.getAnnotation(Produces.class))) : null;
                    keys.add(new ProviderKey(consumes, produces, genericInterface));
                }
                return keys;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        List<Key> keys;
        if (componentAdapter instanceof RestfulComponentAdapter && (keys = RestfulContainer.makeKeys((RestfulComponentAdapter)componentAdapter)).size() > 0) {
            this.lock.lock();
            try {
                HashMap<Key, ComponentAdapter> copy = new HashMap<Key, ComponentAdapter>(this.restToComponentAdapters);
                for (Key key : keys) {
                    ComponentAdapter previous = copy.put(key, componentAdapter);
                    if (previous == null) continue;
                    throw new PicoRegistrationException("Cannot register component " + componentAdapter + " because already registered component " + previous);
                }
                super.registerComponent(componentAdapter);
                this.restToComponentAdapters = copy;
                ComponentAdapter componentAdapter2 = componentAdapter;
                return componentAdapter2;
            }
            finally {
                this.lock.unlock();
            }
        }
        return super.registerComponent(componentAdapter);
    }

    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        if (RestfulComponentAdapter.isRestfulComponent(componentInstance)) {
            RestfulComponentAdapter componentAdapter = new RestfulComponentAdapter(componentKey, componentInstance);
            this.registerComponent(componentAdapter);
            return componentAdapter;
        }
        return super.registerComponentInstance(componentKey, componentInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentAdapter unregisterComponent(Object componentKey) {
        List<Key> keys;
        ComponentAdapter componentAdapter = super.unregisterComponent(componentKey);
        if (componentAdapter instanceof RestfulComponentAdapter && (keys = RestfulContainer.makeKeys((RestfulComponentAdapter)componentAdapter)).size() > 0) {
            this.lock.lock();
            try {
                HashMap<Key, ComponentAdapter> copy = new HashMap<Key, ComponentAdapter>(this.restToComponentAdapters);
                copy.keySet().removeAll(keys);
                this.restToComponentAdapters = copy;
            }
            finally {
                this.lock.unlock();
            }
        }
        return componentAdapter;
    }

    public List<ComponentAdapter> getComponentAdapters(Class<? extends Annotation> annotation) {
        Collection adapters = this.getComponentAdapters();
        if (adapters.size() > 0) {
            ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
            for (ComponentAdapter a : adapters) {
                if (!a.getComponentImplementation().isAnnotationPresent(annotation)) continue;
                result.add(a);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<ComponentAdapter> getComponentAdaptersOfType(Class componentType, Class<? extends Annotation> annotation) {
        List adapters = this.getComponentAdaptersOfType(componentType);
        if (adapters.size() > 0) {
            ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
            for (ComponentAdapter a : adapters) {
                if (!a.getComponentImplementation().isAnnotationPresent(annotation)) continue;
                result.add(a);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public <T> List<T> getComponentsOfType(Class<T> componentType, Class<? extends Annotation> annotation) {
        List instances = this.getComponentInstancesOfType(componentType);
        if (instances.size() > 0) {
            ArrayList<T> result = new ArrayList<T>();
            for (Object o : instances) {
                if (!o.getClass().isAnnotationPresent(annotation)) continue;
                result.add(componentType.cast(o));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<Object> getComponents(Class<? extends Annotation> annotation) {
        List instances = this.getComponentInstances();
        if (instances.size() > 0) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : instances) {
                if (!o.getClass().isAnnotationPresent(annotation)) continue;
                result.add(o);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public final ComponentAdapter getMatchedResource(String requestPath, List<String> parameterValues) {
        return ComponentsFinder.findResource((PicoContainer)this, requestPath, parameterValues);
    }

    public final <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ComponentsFinder.findReader((PicoContainer)this, type, genericType, annotations, mediaType);
    }

    public final <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ComponentsFinder.findWriter((PicoContainer)this, type, genericType, annotations, mediaType);
    }

    public final <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        return ComponentsFinder.findExceptionMapper((PicoContainer)this, type);
    }

    public final <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return ComponentsFinder.findContextResolver((PicoContainer)this, contextType, mediaType);
    }

    private static interface Key {
    }

    private static final class ResourceKey
    implements Key {
        private final UriPattern uriPattern;

        ResourceKey(UriPattern uriPattern) {
            this.uriPattern = uriPattern;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + this.uriPattern.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.uriPattern.equals((Object)((ResourceKey)obj).uriPattern);
        }
    }

    private static final class ProviderKey
    implements Key {
        private final Type type;
        private final Set<MediaType> consumes;
        private final Set<MediaType> produces;

        ProviderKey(Set<MediaType> consumes, Set<MediaType> produces, Type type) {
            this.consumes = consumes;
            this.produces = produces;
            this.type = type;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.consumes == null ? 0 : this.consumes.hashCode());
            hash = hash * 31 + (this.produces == null ? 0 : this.produces.hashCode());
            hash = hash * 31 + (this.type == null ? 0 : this.type.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProviderKey other = (ProviderKey)obj;
            if (this.consumes == null ? other.consumes != null : !this.consumes.equals(other.consumes)) {
                return false;
            }
            if (this.produces == null ? other.produces != null : !this.produces.equals(other.produces)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

