/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.guice.servlet;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.RuntimeDelegate;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestApplication;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.async.AsynchronousProcessListWriter;
import org.everrest.core.impl.method.filter.SecurityConstraint;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.guice.BindingPath;
import org.everrest.guice.EverrestConfigurationModule;
import org.everrest.guice.EverrestModule;
import org.everrest.guice.GuiceDependencySupplier;
import org.everrest.guice.GuiceObjectFactory;
import org.everrest.guice.GuiceRuntimeDelegateImpl;
import org.everrest.guice.servlet.GuiceEverrestServlet;

public abstract class EverrestGuiceContextListener
extends GuiceServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        super.contextInitialized(sce);
        ServletContext servletContext = sce.getServletContext();
        ResourceBinderImpl resources = new ResourceBinderImpl();
        ApplicationProviderBinder providers = new ApplicationProviderBinder();
        Injector injector = this.getInjector(servletContext);
        GuiceDependencySupplier dependencySupplier = new GuiceDependencySupplier(injector);
        EverrestConfiguration config = (EverrestConfiguration)injector.getInstance(EverrestConfiguration.class);
        EverrestServletContextInitializer everrestInitializer = new EverrestServletContextInitializer(servletContext);
        Application application = everrestInitializer.getApplication();
        EverrestApplication everrest = new EverrestApplication();
        if (config.isAsynchronousSupported()) {
            everrest.addResource(config.getAsynchronousServicePath(), AsynchronousJobService.class);
            everrest.addSingleton((Object)new AsynchronousJobPool(config));
            everrest.addSingleton((Object)new AsynchronousProcessListWriter());
        }
        if (config.isCheckSecurity()) {
            everrest.addSingleton((Object)new SecurityConstraint());
        }
        everrest.addApplication(application);
        this.processBindings(injector, everrest);
        EverrestProcessor processor = new EverrestProcessor((ResourceBinder)resources, (ProviderBinder)providers, (DependencySupplier)dependencySupplier, config, (Application)everrest);
        processor.start();
        servletContext.setAttribute(EverrestConfiguration.class.getName(), (Object)config);
        servletContext.setAttribute(Application.class.getName(), (Object)everrest);
        servletContext.setAttribute(DependencySupplier.class.getName(), (Object)dependencySupplier);
        servletContext.setAttribute(ResourceBinder.class.getName(), (Object)resources);
        servletContext.setAttribute(ApplicationProviderBinder.class.getName(), (Object)providers);
        servletContext.setAttribute(EverrestProcessor.class.getName(), (Object)processor);
        RuntimeDelegate.setInstance((RuntimeDelegate)new GuiceRuntimeDelegateImpl());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.makeFileCollectorDestroyer().stopFileCollector();
        ServletContext sctx = sce.getServletContext();
        EverrestProcessor processor = (EverrestProcessor)sctx.getAttribute(EverrestProcessor.class.getName());
        if (processor != null) {
            processor.stop();
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    protected final Injector getInjector() {
        return Guice.createInjector((Stage)Stage.PRODUCTION, this.createModules());
    }

    private List<Module> createModules() {
        ArrayList<Module> all = new ArrayList<Module>();
        ServletModule servletModule = this.getServletModule();
        if (servletModule != null) {
            all.add((Module)servletModule);
        }
        all.add((Module)new EverrestModule());
        all.add((Module)new EverrestConfigurationModule());
        List<Module> modules = this.getModules();
        if (modules != null && modules.size() > 0) {
            all.addAll(modules);
        }
        return all;
    }

    protected abstract List<Module> getModules();

    protected ServletModule getServletModule() {
        return new ServletModule(){

            protected void configureServlets() {
                this.serve("/*", new String[0]).with(GuiceEverrestServlet.class);
            }
        };
    }

    protected Injector getInjector(ServletContext servletContext) {
        return (Injector)servletContext.getAttribute(Injector.class.getName());
    }

    protected void processBindings(Injector injector, EverrestApplication everrest) {
        ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
        for (Binding binding : injector.getBindings().values()) {
            AbstractResourceDescriptorImpl rDescriptor;
            Key bindingKey = binding.getKey();
            Type type = bindingKey.getTypeLiteral().getType();
            if (!(type instanceof Class)) continue;
            Class clazz = (Class)type;
            if (clazz.getAnnotation(Provider.class) != null) {
                ProviderDescriptorImpl pDescriptor = new ProviderDescriptorImpl(clazz);
                pDescriptor.accept((ResourceDescriptorVisitor)rdv);
                everrest.addFactory(new GuiceObjectFactory<ProviderDescriptorImpl>(pDescriptor, binding.getProvider()));
                continue;
            }
            if (clazz.getAnnotation(Filter.class) != null) {
                FilterDescriptorImpl fDescriptor = new FilterDescriptorImpl(clazz);
                fDescriptor.accept((ResourceDescriptorVisitor)rdv);
                everrest.addFactory(new GuiceObjectFactory<FilterDescriptorImpl>(fDescriptor, binding.getProvider()));
                continue;
            }
            if (clazz.getAnnotation(Path.class) == null) continue;
            if (bindingKey.getAnnotation() != null && bindingKey.getAnnotationType().isAssignableFrom(BindingPath.class)) {
                String path = ((BindingPath)bindingKey.getAnnotation()).value();
                rDescriptor = new AbstractResourceDescriptorImpl(path, clazz);
            } else {
                rDescriptor = new AbstractResourceDescriptorImpl(clazz);
            }
            rDescriptor.accept((ResourceDescriptorVisitor)rdv);
            everrest.addFactory(new GuiceObjectFactory<AbstractResourceDescriptorImpl>(rDescriptor, binding.getProvider()));
        }
    }

    public static class DefaultListener
    extends EverrestGuiceContextListener {
        @Override
        protected List<Module> getModules() {
            return Collections.emptyList();
        }
    }
}

