/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.servlet.ServletModule;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.servlet.EverrestServletContextInitializer;

public class EverrestConfigurationModule
extends ServletModule {
    protected void configureServlets() {
        this.bind(EverrestConfiguration.class).toProvider((Provider)new EverrestConfigurationProvider(this.getServletContext()));
    }

    static class EverrestConfigurationProvider
    implements Provider<EverrestConfiguration> {
        ServletContext servletContext;
        @Inject(optional=true)
        @Named(value="org.everrest.asynchronous")
        private String asynchronous;
        @Inject(optional=true)
        @Named(value="org.everrest.asynchronous.cache.size")
        private String asynchronousCacheSize;
        @Inject(optional=true)
        @Named(value="org.everrest.asynchronous.job.timeout")
        private String asynchronousJobTimeout;
        @Inject(optional=true)
        @Named(value="org.everrest.asynchronous.pool.size")
        private String asynchronousPoolSize;
        @Inject(optional=true)
        @Named(value="org.everrest.asynchronous.queue.size")
        private String asynchronousQueueSize;
        @Inject(optional=true)
        @Named(value="org.everrest.asynchronous.service.path")
        private String asynchronousServicePath;
        @Inject(optional=true)
        @Named(value="org.everrest.security")
        private String checkSecurity;
        @Inject(optional=true)
        @Named(value="org.everrest.http.method.override")
        private String httpMethodOverride;
        @Inject(optional=true)
        @Named(value="org.everrest.max.buffer.size")
        private String maxBufferSize;
        @Inject(optional=true)
        @Named(value="org.everrest.normalize.uri")
        private String normalizeUrl;
        @Inject(optional=true)
        @Named(value="org.everrest.core.impl.method.MethodInvokerDecoratorFactory")
        private String methodInvokerDecoratorFactory;
        @Inject(optional=true)
        @Named(value="org.everrest.websocket.readtimeout")
        private String websocketReadTimeout;

        EverrestConfigurationProvider(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public EverrestConfiguration get() {
            EverrestConfiguration configuration = new EverrestServletContextInitializer(this.servletContext).getConfiguration();
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.asynchronous", this.asynchronous);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.asynchronous.cache.size", this.asynchronousCacheSize);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.asynchronous.job.timeout", this.asynchronousJobTimeout);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.asynchronous.pool.size", this.asynchronousPoolSize);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.asynchronous.queue.size", this.asynchronousQueueSize);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.asynchronous.service.path", this.asynchronousServicePath);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.security", this.checkSecurity);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.http.method.override", this.httpMethodOverride);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.max.buffer.size", this.maxBufferSize);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.normalize.uri", this.normalizeUrl);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.core.impl.method.MethodInvokerDecoratorFactory", this.methodInvokerDecoratorFactory);
            this.setConfigurationPropertyIfNotNull(configuration, "org.everrest.websocket.readtimeout", this.websocketReadTimeout);
            return configuration;
        }

        private void setConfigurationPropertyIfNotNull(EverrestConfiguration everrestConfiguration, String name, String value) {
            if (value != null) {
                everrestConfiguration.setProperty(name, value);
            }
        }
    }
}

