/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.pico.servlet;

import java.lang.reflect.Type;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.everrest.core.ApplicationContext;
import org.everrest.core.InitialProperties;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.util.Logger;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.AbstractAdapter;
import org.picocontainer.web.PicoServletContainerFilter;

public class EverrestPicoFilter
extends PicoServletContainerFilter {
    private static final Logger log = Logger.getLogger(EverrestPicoFilter.class);
    private static final ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();
    private static final ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
    private static final ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();

    public static <T> T getComponent(Class<T> type) {
        MutablePicoContainer sessionContainer;
        Object object = null;
        object = EverrestPicoFilter.getAppContainer().getComponent(type);
        if (object == null && (sessionContainer = EverrestPicoFilter.getSessionContainer()) != null) {
            object = sessionContainer.getComponent(type);
        }
        if (object == null) {
            object = EverrestPicoFilter.getRequestContainer().getComponent(type);
        }
        if (object == null && log.isDebugEnabled()) {
            log.debug("Component with type " + type.getName() + " not found in any containers.");
        }
        return (T)object;
    }

    public static Object getComponent(Object key) {
        MutablePicoContainer sessionContainer;
        Object object = null;
        object = EverrestPicoFilter.getAppContainer().getComponent(key);
        if (object == null && (sessionContainer = EverrestPicoFilter.getSessionContainer()) != null) {
            object = sessionContainer.getComponent(key);
        }
        if (object == null) {
            object = EverrestPicoFilter.getRequestContainer().getComponent(key);
        }
        if (object == null && log.isDebugEnabled()) {
            log.debug("Component " + key + " not found in any containers.");
        }
        return object;
    }

    static MutablePicoContainer getAppContainer() {
        MutablePicoContainer container = currentAppContainer.get();
        if (container == null) {
            throw new IllegalStateException("No container was found in application scope. ");
        }
        return container;
    }

    static MutablePicoContainer getRequestContainer() {
        MutablePicoContainer container = currentRequestContainer.get();
        if (container == null) {
            throw new IllegalStateException("No container was found in request scope. ");
        }
        return container;
    }

    static MutablePicoContainer getSessionContainer() {
        return currentSessionContainer.get();
    }

    public void destroy() {
        try {
            currentAppContainer.remove();
            currentSessionContainer.remove();
            currentRequestContainer.remove();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        super.destroy();
    }

    public void initAdditionalScopedComponents(MutablePicoContainer sessionContainer, MutablePicoContainer reqContainer) {
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new InitialPropertiesInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new HttpHeadersInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new ProvidersInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new RequestInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new SecurityContextInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new UriInfoInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new ApplicationInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new ServletConfigInjector());
        reqContainer.as(new Properties[]{Characteristics.NO_CACHE}).addAdapter((ComponentAdapter)new ServletContextInjector());
    }

    public void setAppContainer(MutablePicoContainer container) {
        currentAppContainer.set(container);
    }

    public void setRequestContainer(MutablePicoContainer container) {
        currentRequestContainer.set(container);
    }

    public void setSessionContainer(MutablePicoContainer container) {
        currentSessionContainer.set(container);
    }

    public static class ApplicationInjector
    extends AbstractAdapter<Application> {
        public ApplicationInjector() {
            super(Application.class, Application.class);
        }

        public Application getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
            }
            return context.getApplication();
        }

        public String getDescriptor() {
            return "Application";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class UriInfoInjector
    extends AbstractAdapter<UriInfo> {
        public UriInfoInjector() {
            super(UriInfo.class, UriInfo.class);
        }

        public UriInfo getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
            }
            return context.getUriInfo();
        }

        public String getDescriptor() {
            return "UriInfo";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class ServletContextInjector
    extends AbstractAdapter<ServletContext> {
        public ServletContextInjector() {
            super(ServletContext.class, ServletContext.class);
        }

        public ServletContext getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            EnvironmentContext context = EnvironmentContext.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest EnvironmentContext is not initialized.");
            }
            return (ServletContext)context.get(ServletContext.class);
        }

        public String getDescriptor() {
            return "ServletContext";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class ServletConfigInjector
    extends AbstractAdapter<ServletConfig> {
        public ServletConfigInjector() {
            super(ServletConfig.class, ServletConfig.class);
        }

        public ServletConfig getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            EnvironmentContext context = EnvironmentContext.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest EnvironmentContext is not initialized.");
            }
            return (ServletConfig)context.get(ServletConfig.class);
        }

        public String getDescriptor() {
            return "ServletConfig";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class SecurityContextInjector
    extends AbstractAdapter<SecurityContext> {
        public SecurityContextInjector() {
            super(SecurityContext.class, SecurityContext.class);
        }

        public SecurityContext getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
            }
            return context.getSecurityContext();
        }

        public String getDescriptor() {
            return "SecurityContext";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class RequestInjector
    extends AbstractAdapter<Request> {
        public RequestInjector() {
            super(Request.class, Request.class);
        }

        public Request getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
            }
            return context.getRequest();
        }

        public String getDescriptor() {
            return "Request";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class ProvidersInjector
    extends AbstractAdapter<Providers> {
        public ProvidersInjector() {
            super(Providers.class, Providers.class);
        }

        public Providers getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
            }
            return context.getProviders();
        }

        public String getDescriptor() {
            return "Providers";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class InitialPropertiesInjector
    extends AbstractAdapter<InitialProperties> {
        public InitialPropertiesInjector() {
            super(InitialProperties.class, InitialProperties.class);
        }

        public InitialProperties getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
            }
            return context.getInitialProperties();
        }

        public String getDescriptor() {
            return "InitialProperties";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }

    public static class HttpHeadersInjector
    extends AbstractAdapter<HttpHeaders> {
        public HttpHeadersInjector() {
            super(HttpHeaders.class, HttpHeaders.class);
        }

        public HttpHeaders getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
            }
            return context.getHttpHeaders();
        }

        public String getDescriptor() {
            return "HttpHeaders";
        }

        public void verify(PicoContainer container) throws PicoCompositionException {
        }
    }
}

