/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.spring;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.InitialProperties;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestApplication;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.async.AsynchronousProcessListWriter;
import org.everrest.core.impl.method.filter.SecurityConstraint;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.spring.SpringObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

public class SpringComponentsLoader
implements BeanFactoryPostProcessor,
HandlerMapping {
    protected ResourceBinder resources;
    protected ApplicationProviderBinder providers;
    protected EverrestProcessor processor;
    protected EverrestConfiguration configuration;

    public SpringComponentsLoader(ResourceBinder resources, ApplicationProviderBinder providers, DependencySupplier dependencies) {
        this(resources, providers, new EverrestConfiguration(), dependencies);
    }

    public SpringComponentsLoader(ResourceBinder resources, ApplicationProviderBinder providers, EverrestConfiguration configuration, DependencySupplier dependencies) {
        this.resources = resources;
        this.providers = providers;
        this.configuration = configuration;
        this.processor = new EverrestProcessor(resources, (ProviderBinder)providers, dependencies, configuration, null);
    }

    protected SpringComponentsLoader() {
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        return new HandlerExecutionChain((Object)this.processor);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerSingleton("org.everrest.lifecycle.SpringEverrestProcessorLifecycle", (Object)new SpringEverrestProcessorLifecycle(this.processor));
        beanFactory.registerSingleton("org.everrest.lifecycle.SpringFileCollectorDestroyer", (Object)new SpringFileCollectorDestroyer(this.makeFileCollectorDestroyer()));
        EverrestApplication everrest = this.makeEverrestApplication();
        ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
        this.addAutowiredDependencies(beanFactory);
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            Class beanClass = beanFactory.getType(beanName);
            if (beanClass.getAnnotation(Provider.class) != null) {
                ProviderDescriptorImpl pDescriptor = new ProviderDescriptorImpl(beanClass);
                pDescriptor.accept((ResourceDescriptorVisitor)rdv);
                everrest.addFactory(new SpringObjectFactory<ProviderDescriptorImpl>(pDescriptor, beanName, (BeanFactory)beanFactory));
                continue;
            }
            if (beanClass.getAnnotation(Filter.class) != null) {
                FilterDescriptorImpl fDescriptor = new FilterDescriptorImpl(beanClass);
                fDescriptor.accept((ResourceDescriptorVisitor)rdv);
                everrest.addFactory(new SpringObjectFactory<FilterDescriptorImpl>(fDescriptor, beanName, (BeanFactory)beanFactory));
                continue;
            }
            if (beanClass.getAnnotation(Path.class) == null) continue;
            AbstractResourceDescriptorImpl rDescriptor = new AbstractResourceDescriptorImpl(beanClass);
            rDescriptor.accept((ResourceDescriptorVisitor)rdv);
            everrest.addFactory(new SpringObjectFactory<AbstractResourceDescriptorImpl>(rDescriptor, beanName, (BeanFactory)beanFactory));
        }
        this.processor.addApplication((Application)everrest);
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    protected EverrestApplication makeEverrestApplication() {
        EverrestApplication everrest = new EverrestApplication();
        if (this.configuration.isAsynchronousSupported()) {
            everrest.addResource(this.configuration.getAsynchronousServicePath(), AsynchronousJobService.class);
            everrest.addSingleton((Object)new AsynchronousJobPool(this.configuration));
            everrest.addSingleton((Object)new AsynchronousProcessListWriter());
        }
        if (this.configuration.isCheckSecurity()) {
            everrest.addSingleton((Object)new SecurityConstraint());
        }
        return everrest;
    }

    protected void addAutowiredDependencies(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerResolvableDependency(HttpHeaders.class, (Object)new ObjectFactory<HttpHeaders>(){

            public HttpHeaders getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getHttpHeaders();
            }
        });
        beanFactory.registerResolvableDependency(InitialProperties.class, (Object)new ObjectFactory<InitialProperties>(){

            public InitialProperties getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getInitialProperties();
            }
        });
        beanFactory.registerResolvableDependency(Request.class, (Object)new ObjectFactory<Request>(){

            public Request getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getRequest();
            }
        });
        beanFactory.registerResolvableDependency(SecurityContext.class, (Object)new ObjectFactory<SecurityContext>(){

            public SecurityContext getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getSecurityContext();
            }
        });
        beanFactory.registerResolvableDependency(UriInfo.class, (Object)new ObjectFactory<UriInfo>(){

            public UriInfo getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getUriInfo();
            }
        });
        beanFactory.registerResolvableDependency(Application.class, (Object)new ObjectFactory<Application>(){

            public Application getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getApplication();
            }
        });
    }

    protected ResourceBinder getResources() {
        return this.resources;
    }

    protected ApplicationProviderBinder getProviders() {
        return this.providers;
    }

    protected EverrestProcessor getProcessor() {
        return this.processor;
    }

    private static final class SpringFileCollectorDestroyer
    extends _Lifecycle {
        private final FileCollectorDestroyer fileCollectorDestroyer;

        public SpringFileCollectorDestroyer(FileCollectorDestroyer fileCollectorDestroyer) {
            this.fileCollectorDestroyer = fileCollectorDestroyer;
        }

        @Override
        void doStop() {
            this.fileCollectorDestroyer.stopFileCollector();
        }
    }

    private static final class SpringEverrestProcessorLifecycle
    extends _Lifecycle {
        private final EverrestProcessor processor;

        private SpringEverrestProcessorLifecycle(EverrestProcessor processor) {
            this.processor = processor;
        }

        @Override
        void doStart() {
            this.processor.start();
        }

        @Override
        void doStop() {
            this.processor.stop();
        }
    }

    private static abstract class _Lifecycle
    implements Lifecycle {
        private final AtomicBoolean flag = new AtomicBoolean(false);

        private _Lifecycle() {
        }

        public final void start() {
            this.doStart();
            this.flag.set(true);
        }

        public final void stop() {
            this.doStop();
            this.flag.set(false);
        }

        public final boolean isRunning() {
            return this.flag.get();
        }

        void doStart() {
        }

        void doStop() {
        }
    }
}

