/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.spring;

import java.util.List;
import org.everrest.core.ApplicationContext;
import org.everrest.core.FieldInjector;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ObjectModel;
import org.springframework.beans.factory.BeanFactory;

public class SpringObjectFactory<T extends ObjectModel>
implements ObjectFactory<T> {
    protected final BeanFactory beanFactory;
    protected final String name;
    protected final T model;

    public SpringObjectFactory(T model, String name, BeanFactory beanFactory) {
        this.model = model;
        this.name = name;
        this.beanFactory = beanFactory;
    }

    public Object getInstance(ApplicationContext context) {
        Object bean = this.beanFactory.getBean(this.name);
        List fieldInjectors = this.model.getFieldInjectors();
        if (fieldInjectors != null && fieldInjectors.size() > 0) {
            for (FieldInjector injector : fieldInjectors) {
                if (injector.getAnnotation() == null) continue;
                injector.inject(bean, context);
            }
        }
        return bean;
    }

    public T getObjectModel() {
        return this.model;
    }
}

