/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.test.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CaseInsensitiveMultivaluedMap<T>
extends HashMap<String, List<T>> {
    private static final long serialVersionUID = 6637313979061607685L;

    @Override
    public void putAll(Map<? extends String, ? extends List<T>> m) {
        for (Map.Entry<String, List<T>> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.getKey(key));
    }

    @Override
    public List<T> get(Object key) {
        return this.getList(this.getKey(key));
    }

    @Override
    public List<T> put(String key, List<T> value) {
        return super.put(this.getKey(key), value);
    }

    @Override
    public List<T> remove(Object key) {
        return (List)super.remove(this.getKey(key));
    }

    public T getFirst(String key) {
        List<T> l = this.getList(key);
        if (l.size() == 0) {
            return null;
        }
        return l.get(0);
    }

    private List<T> getList(String key) {
        ArrayList l = (ArrayList)super.get(this.getKey(key));
        if (l == null) {
            l = new ArrayList();
        }
        this.put(key, l);
        return l;
    }

    private String getKey(Object key) {
        if (key == null) {
            return null;
        }
        return key.toString().toLowerCase();
    }
}

