/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.test.mock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

public class MockServletContext
implements ServletContext {
    private String name;
    private HashMap<String, String> initParams;
    private HashMap<String, Object> attributes;
    private String contextPath;
    private StringBuilder logBuffer = new StringBuilder();

    public MockServletContext() {
        this("MockServletContext1");
    }

    public MockServletContext(String name) {
        this.name = name;
        this.initParams = new HashMap();
        this.attributes = new HashMap();
    }

    public MockServletContext(String name, String path) {
        this(name);
        this.contextPath = path;
        this.attributes.put("javax.servlet.context.tempdir", path);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLogBuffer() {
        try {
            String string = this.logBuffer.toString();
            return string;
        }
        finally {
            this.logBuffer = new StringBuilder();
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext(String s) {
        return null;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public String getMimeType(String s) {
        return "text/html";
    }

    public Set<String> getResourcePaths(String s) {
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        HashSet<String> set = new HashSet<String>();
        try {
            File[] arr;
            File dir;
            URL url = this.getResource(s);
            if (url != null && (dir = new File(url.getPath())).isDirectory() && (arr = dir.listFiles()) != null) {
                for (int i = 0; i < arr.length; ++i) {
                    File tmp = arr[i];
                    if (!tmp.isDirectory()) {
                        set.add(s + "/" + tmp.getName());
                        continue;
                    }
                    set.add(s + "/" + tmp.getName() + "/");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return set;
    }

    public URL getResource(String s) throws MalformedURLException {
        String path = "file:" + this.contextPath + s;
        return new URL(path);
    }

    public InputStream getResourceAsStream(String s) {
        try {
            return this.getResource(s).openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return null;
    }

    public Servlet getServlet(String s) throws ServletException {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return null;
    }

    public Enumeration<String> getServletNames() {
        return null;
    }

    public void log(String s) {
        this.logBuffer.append(s);
    }

    public void log(Exception e, String s) {
        this.logBuffer.append(s).append(e.getMessage());
    }

    public void log(String s, Throwable throwable) {
        this.logBuffer.append(s).append(throwable.getMessage());
    }

    public void setContextPath(String s) {
        this.contextPath = s;
    }

    public String getRealPath(String s) {
        return this.contextPath + s;
    }

    public String getServerInfo() {
        return null;
    }

    public boolean setInitParameter(String name, String value) {
        if (this.initParams.get(name) == null) {
            this.initParams.put(name, value);
            return true;
        }
        return false;
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParams.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException("not supported");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException("not supported");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException("not supported");
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("not supported");
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new UnsupportedOperationException("not supported");
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new UnsupportedOperationException("not supported");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException("not supported");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException("not supported");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException("not supported");
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("not supported");
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new UnsupportedOperationException("not supported");
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new UnsupportedOperationException("not supported");
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException("not supported");
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException("not supported");
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException("not supported");
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException("not supported");
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException("not supported");
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException("not supported");
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException("not supported");
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("not supported");
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException("not supported");
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException("not supported");
    }
}

