/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpSession;
import org.everrest.core.util.Logger;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSConnectionImpl;
import org.everrest.websockets.WSConnectionListener;
import org.everrest.websockets.message.ChannelBroadcastMessage;
import org.everrest.websockets.message.MessageConversionException;
import org.everrest.websockets.message.MessageConverter;
import org.everrest.websockets.message.Pair;
import org.everrest.websockets.message.RESTfulOutputMessage;

public class WSConnectionContext {
    private static final Logger LOG = Logger.getLogger(WSConnectionContext.class);
    static final List<WSConnectionListener> connectionListeners = new CopyOnWriteArrayList<WSConnectionListener>();
    static final Map<Long, WSConnectionImpl> connections = new ConcurrentHashMap<Long, WSConnectionImpl>();

    public static boolean registerConnectionListener(WSConnectionListener listener) {
        return connectionListeners.add(listener);
    }

    public static boolean removeConnectionListener(WSConnectionListener listener) {
        return connectionListeners.remove(listener);
    }

    public static void sendMessage(ChannelBroadcastMessage message) throws MessageConversionException, IOException {
        String channel = message.getChannel();
        RESTfulOutputMessage output = WSConnectionContext.newRESTfulOutputMessage(message);
        Exception error = null;
        for (WSConnectionImpl connection : connections.values()) {
            if (!connection.getChannels().contains(channel)) continue;
            try {
                connection.sendMessage(output);
            }
            catch (MessageConversionException e) {
                if (error != null) continue;
                error = e;
            }
            catch (IOException e) {
                if (error != null) continue;
                error = e;
            }
        }
        if (error instanceof MessageConversionException) {
            throw (MessageConversionException)error;
        }
        if (error != null) {
            throw (IOException)error;
        }
    }

    private static RESTfulOutputMessage newRESTfulOutputMessage(ChannelBroadcastMessage message) {
        RESTfulOutputMessage transport = new RESTfulOutputMessage();
        transport.setUuid(message.getUuid());
        transport.setHeaders(new Pair[]{new Pair("x-everrest-websocket-channel", message.getChannel()), new Pair("x-everrest-websocket-message-type", message.getType().toString())});
        transport.setBody(message.getBody());
        return transport;
    }

    static WSConnectionImpl open(HttpSession httpSession, MessageConverter messageConverter) {
        if (httpSession == null) {
            throw new IllegalArgumentException("HTTP Session required. ");
        }
        if (messageConverter == null) {
            throw new IllegalArgumentException("MessageConverter required. ");
        }
        WSConnectionImpl newConnection = new WSConnectionImpl(httpSession, messageConverter);
        connections.put(newConnection.getId(), newConnection);
        return newConnection;
    }

    static Collection<WSConnectionImpl> getAll(String httpSessionId) {
        if (httpSessionId == null) {
            throw new IllegalArgumentException("HTTP session may not be null. ");
        }
        ArrayList<WSConnectionImpl> result = new ArrayList<WSConnectionImpl>();
        for (WSConnectionImpl connection : connections.values()) {
            if (!httpSessionId.equals(connection.getHttpSession().getId())) continue;
            result.add(connection);
        }
        return result;
    }

    static void closeAll(String httpSessionId) {
        Collection<WSConnectionImpl> toRemove = WSConnectionContext.getAll(httpSessionId);
        for (WSConnectionImpl connection : toRemove) {
            try {
                connection.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        connections.values().removeAll(toRemove);
    }

    private WSConnectionContext() {
    }

    static {
        WSConnectionContext.registerConnectionListener(new WSConnectionListener(){

            @Override
            public void onOpen(WSConnection connection) {
                LOG.debug("Open connection {} ", (Object)connection);
            }

            @Override
            public void onClose(WSConnection connection) {
                LOG.debug("Close connection {} with status {} ", (Object)connection, (Object)connection.getCloseStatus());
                connections.remove(connection.getId());
            }
        });
    }
}

