/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerResponse;
import org.everrest.websockets.message.Pair;
import org.everrest.websockets.message.RESTfulOutputMessage;

class EverrestResponseWriter
implements ContainerResponseWriter {
    private final RESTfulOutputMessage output;
    private boolean commited;

    EverrestResponseWriter(RESTfulOutputMessage output) {
        this.output = output;
    }

    public void writeHeaders(GenericContainerResponse response) throws IOException {
        if (this.commited) {
            throw new IllegalStateException("Response has been commited. Unable write headers. ");
        }
        this.output.setResponseCode(response.getStatus());
        this.output.setHeaders(Pair.fromMap((MultivaluedMap<String, Object>)response.getHttpHeaders()));
        this.commited = true;
    }

    public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object entity = response.getEntity();
        if (entity != null) {
            entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
            byte[] body = out.toByteArray();
            this.output.setBody(new String(body));
        }
    }
}

