/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpSession;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSConnectionContext;
import org.everrest.websockets.WSConnectionListener;
import org.everrest.websockets.WSMessageReceiver;
import org.everrest.websockets.message.MessageConversionException;
import org.everrest.websockets.message.MessageConverter;
import org.everrest.websockets.message.OutputMessage;
import org.everrest.websockets.message.RESTfulInputMessage;

public class WSConnectionImpl
extends MessageInbound
implements WSConnection {
    private static final AtomicLong counter = new AtomicLong(1L);
    private static final Charset UTF8_CS = Charset.forName("UTF-8");
    private final long id = counter.getAndIncrement();
    private final HttpSession httpSession;
    private final MessageConverter messageConverter;
    private final List<WSMessageReceiver> messageReceivers;
    private final Set<String> channels;
    private final Set<String> readOnlyChannels;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private int closeStatus = 0;

    WSConnectionImpl(HttpSession httpSession, MessageConverter messageConverter) {
        this.httpSession = httpSession;
        this.messageConverter = messageConverter;
        this.messageReceivers = new CopyOnWriteArrayList<WSMessageReceiver>();
        this.channels = new CopyOnWriteArraySet<String>();
        this.readOnlyChannels = Collections.unmodifiableSet(this.channels);
    }

    protected void onBinaryMessage(ByteBuffer message) throws IOException {
        if (this.connected.compareAndSet(true, false)) {
            this.getWsOutbound().close(1003, UTF8_CS.encode("Binary messages is not supported. "));
        }
        throw new UnsupportedOperationException("Binary messages is not supported. ");
    }

    protected void onTextMessage(CharBuffer message) throws IOException {
        RESTfulInputMessage input = null;
        MessageConversionException error = null;
        try {
            input = this.messageConverter.fromString(message.toString(), RESTfulInputMessage.class);
        }
        catch (MessageConversionException e) {
            error = e;
        }
        if (error != null) {
            for (WSMessageReceiver receiver : this.messageReceivers) {
                receiver.onError(error);
            }
        } else {
            for (WSMessageReceiver receiver : this.messageReceivers) {
                receiver.onMessage(input);
            }
        }
    }

    protected void onOpen(WsOutbound outbound) {
        for (WSConnectionListener connectionListener : WSConnectionContext.connectionListeners) {
            connectionListener.onOpen(this);
        }
        this.connected.compareAndSet(false, true);
    }

    protected void onClose(int status) {
        this.connected.compareAndSet(true, false);
        this.closeStatus = status;
        for (WSConnectionListener connectionListener : WSConnectionContext.connectionListeners) {
            connectionListener.onClose(this);
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    @Override
    public boolean subscribeToChannel(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel name may not be null. ");
        }
        return this.channels.add(channel);
    }

    @Override
    public boolean unsubscribeFromChannel(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel name may not be null. ");
        }
        return this.channels.remove(channel);
    }

    @Override
    public Collection<String> getChannels() {
        return this.readOnlyChannels;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public int getCloseStatus() {
        return this.closeStatus;
    }

    @Override
    public void close() throws IOException {
        if (this.connected.compareAndSet(true, false)) {
            this.getWsOutbound().close(1000, null);
        }
    }

    @Override
    public void close(int status, String message) throws IOException {
        if (this.connected.compareAndSet(true, false)) {
            this.getWsOutbound().close(status, message == null ? null : UTF8_CS.encode(message));
        }
    }

    @Override
    public void sendMessage(OutputMessage output) throws MessageConversionException, IOException {
        CharBuffer message = CharBuffer.wrap(this.messageConverter.toString(output));
        WsOutbound out = this.getWsOutbound();
        out.writeTextMessage(message);
        out.flush();
    }

    @Override
    public void registerMessageReceiver(WSMessageReceiver messageReceiver) {
        this.messageReceivers.add(messageReceiver);
    }

    @Override
    public void removeMessageReceiver(WSMessageReceiver messageReceiver) {
        this.messageReceivers.remove(messageReceiver);
    }

    public String toString() {
        return "WSConnectionImpl{id=" + this.id + ", httpSession='" + this.httpSession.getId() + '\'' + ", channels=" + this.channels + '}';
    }
}

