/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets.message;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.impl.header.HeaderHelper;

public final class Pair {
    private String name;
    private String value;

    public static MultivaluedMap<String, String> toMap(Pair[] pairs) {
        MultivaluedMapImpl result = new MultivaluedMapImpl();
        if (pairs != null && pairs.length != 0) {
            for (Pair p : pairs) {
                result.add((Object)p.getName(), (Object)p.getValue());
            }
        }
        return result;
    }

    public static Pair[] fromMap(MultivaluedMap<String, Object> source) {
        if (source != null && !source.isEmpty()) {
            ArrayList<Pair> list = new ArrayList<Pair>();
            for (String key : source.keySet()) {
                List values = (List)source.get((Object)key);
                if (values != null && !values.isEmpty()) {
                    for (Object v : values) {
                        list.add(new Pair(key, HeaderHelper.getHeaderAsString(v)));
                    }
                    continue;
                }
                list.add(new Pair(key, null));
            }
            return list.toArray(new Pair[list.size()]);
        }
        return new Pair[0];
    }

    public Pair(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Pair() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Pair{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

