/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.InputHeadersMap;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobListener;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonParser;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.util.Logger;
import org.everrest.websockets.EverrestResponseWriter;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSMessageReceiver;
import org.everrest.websockets.message.InputMessage;
import org.everrest.websockets.message.MessageConversionException;
import org.everrest.websockets.message.OutputMessage;
import org.everrest.websockets.message.Pair;
import org.everrest.websockets.message.RESTfulInputMessage;
import org.everrest.websockets.message.RESTfulOutputMessage;

class WS2RESTAdapter
implements WSMessageReceiver {
    private static final Logger LOG = Logger.getLogger(WS2RESTAdapter.class);
    private static final AtomicLong sequence = new AtomicLong(1L);
    private final WSConnection connection;
    private final SecurityContext securityContext;
    private final EverrestProcessor everrestProcessor;
    private final AsynchronousJobPool asynchronousPool;

    WS2RESTAdapter(WSConnection connection, SecurityContext securityContext, EverrestProcessor everrestProcessor, AsynchronousJobPool asynchronousPool) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (everrestProcessor == null) {
            throw new IllegalArgumentException();
        }
        if (asynchronousPool == null) {
            throw new IllegalArgumentException();
        }
        this.connection = connection;
        this.securityContext = securityContext;
        this.everrestProcessor = everrestProcessor;
        this.asynchronousPool = asynchronousPool;
    }

    @Override
    public void onMessage(InputMessage input) {
        String requestPath;
        if (!(input instanceof RESTfulInputMessage)) {
            throw new IllegalArgumentException("Invalid input message. ");
        }
        final RESTfulInputMessage restInputMessage = (RESTfulInputMessage)input;
        MultivaluedMap<String, String> headers = Pair.toMap(restInputMessage.getHeaders());
        String messageType = (String)headers.getFirst((Object)"x-everrest-websocket-message-type");
        if ("ping".equalsIgnoreCase(messageType)) {
            RESTfulOutputMessage pong = this.newOutputMessage(restInputMessage);
            pong.setBody(restInputMessage.getBody());
            pong.setResponseCode(200);
            pong.setHeaders(new Pair[]{new Pair("x-everrest-websocket-message-type", "pong")});
            this.doSendMessage(pong);
            return;
        }
        if ("subscribe-channel".equalsIgnoreCase(messageType) || "unsubscribe-channel".equalsIgnoreCase(messageType)) {
            String channel = this.parseSubscriptionMessage(input);
            RESTfulOutputMessage response = this.newOutputMessage(restInputMessage);
            response.setBody(restInputMessage.getBody());
            response.setHeaders(new Pair[]{new Pair("x-everrest-websocket-message-type", messageType)});
            if (channel != null) {
                if ("subscribe-channel".equalsIgnoreCase(messageType)) {
                    this.connection.subscribeToChannel(channel);
                } else {
                    this.connection.unsubscribeFromChannel(channel);
                }
                response.setResponseCode(200);
            } else {
                LOG.error("Invalid message: {} ", (Object)input.getBody());
                response.setResponseCode(400);
            }
            this.doSendMessage(response);
            return;
        }
        final String uuid = restInputMessage.getUuid();
        RESTfulOutputMessage output = (RESTfulOutputMessage)this.connection.getHttpSession().getAttribute(uuid);
        if (output != null) {
            this.doSendMessage(output);
            return;
        }
        final String trackerId = Long.toString(sequence.getAndIncrement());
        this.asynchronousPool.registerListener(new AsynchronousJobListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(AsynchronousJob job) {
                if (WS2RESTAdapter.this.connection.isConnected()) {
                    MultivaluedMap requestHeaders = ((ContainerRequest)job.getContext().get("org.everrest.async.request")).getRequestHeaders();
                    if ("websocket".equals(requestHeaders.getFirst((Object)"x-everrest-protocol")) && trackerId.equals(requestHeaders.getFirst((Object)"x-everrest-websocket-tracker-id"))) {
                        RESTfulOutputMessage output = WS2RESTAdapter.this.newOutputMessage(restInputMessage);
                        try {
                            ContainerRequest req = new ContainerRequest("GET", URI.create((String)job.getContext().get("internal-uri")), URI.create(""), null, (MultivaluedMap)new InputHeadersMap(), WS2RESTAdapter.this.securityContext);
                            ContainerResponse resp = new ContainerResponse((ContainerResponseWriter)new EverrestResponseWriter(output));
                            EnvironmentContext env = new EnvironmentContext();
                            env.put(WSConnection.class, (Object)WS2RESTAdapter.this.connection);
                            WS2RESTAdapter.this.everrestProcessor.process((GenericContainerRequest)req, (GenericContainerResponse)resp, env);
                        }
                        catch (Exception e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            WS2RESTAdapter.this.asynchronousPool.unregisterListener((AsynchronousJobListener)this);
                            WS2RESTAdapter.this.connection.getHttpSession().removeAttribute(uuid);
                        }
                        WS2RESTAdapter.this.doSendMessage(output);
                    }
                } else {
                    LOG.debug("Connection already closed skip getting result of job: {}. ", (Object)job.getJobId());
                    WS2RESTAdapter.this.asynchronousPool.unregisterListener((AsynchronousJobListener)this);
                    WS2RESTAdapter.this.connection.getHttpSession().removeAttribute(uuid);
                }
            }
        });
        ByteArrayInputStream data = null;
        String body = input.getBody();
        if (body != null) {
            try {
                data = new ByteArrayInputStream(body.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        URI requestUri = URI.create((requestPath = restInputMessage.getPath()).startsWith("/") ? requestPath : '/' + requestPath);
        if (data != null) {
            headers.putSingle((Object)"content-length", (Object)Integer.toString(data.available()));
        }
        headers.putSingle((Object)"x-everrest-async", (Object)"true");
        headers.putSingle((Object)"x-everrest-protocol", (Object)"websocket");
        headers.putSingle((Object)"x-everrest-websocket-tracker-id", (Object)trackerId);
        output = this.newOutputMessage(restInputMessage);
        ContainerRequest req = new ContainerRequest(restInputMessage.getMethod(), requestUri, URI.create(""), (InputStream)data, (MultivaluedMap)new InputHeadersMap(headers), this.securityContext);
        ContainerResponse resp = new ContainerResponse((ContainerResponseWriter)new EverrestResponseWriter(output));
        try {
            EnvironmentContext env = new EnvironmentContext();
            env.put(WSConnection.class, (Object)this.connection);
            this.everrestProcessor.process((GenericContainerRequest)req, (GenericContainerResponse)resp, env);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.connection.getHttpSession().setAttribute(uuid, (Object)output);
        this.doSendMessage(output);
    }

    @Override
    public void onError(Exception error) {
        LOG.error(error.getMessage(), (Throwable)error);
        if (error instanceof MessageConversionException) {
            try {
                this.connection.close(1008, error.getMessage());
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private RESTfulOutputMessage newOutputMessage(RESTfulInputMessage input) {
        RESTfulOutputMessage output = new RESTfulOutputMessage();
        output.setUuid(input.getUuid());
        output.setMethod(input.getMethod());
        output.setPath(input.getPath());
        return output;
    }

    private void doSendMessage(OutputMessage output) {
        if (this.connection.isConnected()) {
            try {
                this.connection.sendMessage(output);
            }
            catch (MessageConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        } else {
            LOG.warn("Connection is already closed. ");
        }
    }

    private String parseSubscriptionMessage(InputMessage input) {
        JsonParser p = new JsonParser();
        try {
            p.parse((Reader)new StringReader(input.getBody()));
        }
        catch (JsonException e) {
            return null;
        }
        JsonValue jv = p.getJsonObject().getElement("channel");
        return jv != null ? jv.getStringValue() : null;
    }
}

