/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerResponse;
import org.everrest.websockets.message.Pair;
import org.everrest.websockets.message.RestOutputMessage;

class EverrestResponseWriter
implements ContainerResponseWriter {
    private final RestOutputMessage output;
    private boolean committed;

    EverrestResponseWriter(RestOutputMessage output) {
        this.output = output;
    }

    public void writeHeaders(GenericContainerResponse response) throws IOException {
        if (this.committed) {
            return;
        }
        this.output.setResponseCode(response.getStatus());
        this.output.setHeaders(Pair.fromMap((MultivaluedMap<String, Object>)response.getHttpHeaders()));
        this.committed = true;
    }

    public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
        if (this.committed) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object entity = response.getEntity();
        if (entity != null) {
            entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
            byte[] body = out.toByteArray();
            this.output.setBody(new String(body));
        }
    }
}

