/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.tools.SimplePrincipal;
import org.everrest.core.tools.SimpleSecurityContext;
import org.everrest.core.tools.WebApplicationDeclaredRoles;
import org.everrest.websockets.WS2RESTAdapter;
import org.everrest.websockets.WSConnectionContext;
import org.everrest.websockets.WSConnectionImpl;
import org.everrest.websockets.message.JsonMessageConverter;
import org.everrest.websockets.message.MessageConverter;

public class EverrestWebSocketServlet
extends WebSocketServlet {
    public static final String EVERREST_PROCESSOR_ATTRIBUTE = EverrestProcessor.class.getName();
    public static final String MESSAGE_CONVERTER_ATTRIBUTE = MessageConverter.class.getName();
    public static final String EVERREST_CONFIG_ATTRIBUTE = EverrestConfiguration.class.getName();
    private static final AtomicLong sequence = new AtomicLong(1L);
    private EverrestProcessor processor;
    private MessageConverter messageConverter;
    private WebApplicationDeclaredRoles webApplicationRoles;
    private EverrestConfiguration everrestConfiguration;
    private Executor executor;

    public void init() throws ServletException {
        this.everrestConfiguration = this.getEverrestConfiguration();
        this.processor = this.getEverrestProcessor();
        this.messageConverter = this.getMessageConverter();
        if (this.messageConverter == null) {
            this.messageConverter = new JsonMessageConverter();
        }
        this.webApplicationRoles = new WebApplicationDeclaredRoles(this.getServletContext());
        this.executor = this.getExecutor();
    }

    protected StreamInbound createWebSocketInbound(String s, HttpServletRequest req) {
        EverrestConfiguration everrestConfiguration = this.getEverrestConfiguration();
        WSConnectionImpl connection = WSConnectionContext.open(req.getSession(), this.messageConverter);
        connection.setReadTimeout(everrestConfiguration.getNumberProperty("org.everrest.websocket.readtimeout", -1.0).intValue());
        connection.registerMessageReceiver(new WS2RESTAdapter(connection, this.createSecurityContext(req), this.processor, this.executor));
        return connection;
    }

    protected EverrestProcessor getEverrestProcessor() {
        return (EverrestProcessor)this.getServletContext().getAttribute(EVERREST_PROCESSOR_ATTRIBUTE);
    }

    protected MessageConverter getMessageConverter() {
        return (MessageConverter)this.getServletContext().getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
    }

    protected EverrestConfiguration getEverrestConfiguration() {
        EverrestConfiguration myEverrestConfiguration = this.everrestConfiguration;
        if (myEverrestConfiguration == null) {
            myEverrestConfiguration = (EverrestConfiguration)this.getServletContext().getAttribute(EVERREST_CONFIG_ATTRIBUTE);
            if (myEverrestConfiguration == null) {
                myEverrestConfiguration = new EverrestConfiguration();
            }
            this.everrestConfiguration = myEverrestConfiguration;
        }
        return myEverrestConfiguration;
    }

    protected Executor getExecutor() {
        EverrestConfiguration everrestConfiguration = this.getEverrestConfiguration();
        return Executors.newFixedThreadPool(everrestConfiguration.getAsynchronousPoolSize(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "everrest.WSServlet" + sequence.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    protected SecurityContext createSecurityContext(HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            return new SimpleSecurityContext(req.isSecure());
        }
        LinkedHashSet<String> userRoles = new LinkedHashSet<String>();
        for (String declaredRole : this.webApplicationRoles.getDeclaredRoles()) {
            if (!req.isUserInRole(declaredRole)) continue;
            userRoles.add(declaredRole);
        }
        return new SimpleSecurityContext((Principal)new SimplePrincipal(principal.getName()), userRoles, req.getAuthType(), req.isSecure());
    }
}

