/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.InputHeadersMap;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonParser;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.util.Logger;
import org.everrest.websockets.EverrestResponseWriter;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSMessageReceiver;
import org.everrest.websockets.message.InputMessage;
import org.everrest.websockets.message.MessageConversionException;
import org.everrest.websockets.message.OutputMessage;
import org.everrest.websockets.message.Pair;
import org.everrest.websockets.message.RESTfulInputMessage;
import org.everrest.websockets.message.RESTfulOutputMessage;

class WS2RESTAdapter
implements WSMessageReceiver {
    private static final Logger LOG = Logger.getLogger(WS2RESTAdapter.class);
    private static final URI BASE_URI = URI.create("");
    private final WSConnection connection;
    private final SecurityContext securityContext;
    private final EverrestProcessor everrestProcessor;
    private final Executor executor;
    private final Set<String> inProgress;

    WS2RESTAdapter(WSConnection connection, SecurityContext securityContext, EverrestProcessor everrestProcessor, Executor executor) {
        this.connection = connection;
        this.securityContext = securityContext;
        this.everrestProcessor = everrestProcessor;
        this.executor = executor;
        this.inProgress = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public void onMessage(final InputMessage input) {
        if (!(input instanceof RESTfulInputMessage)) {
            throw new IllegalArgumentException("Invalid input message. ");
        }
        final RESTfulInputMessage request = (RESTfulInputMessage)input;
        final MultivaluedMap<String, String> headers = Pair.toMap(request.getHeaders());
        String messageType = (String)headers.getFirst((Object)"x-everrest-websocket-message-type");
        if ("ping".equalsIgnoreCase(messageType)) {
            RESTfulOutputMessage pong = this.newOutputMessage(request);
            pong.setBody(request.getBody());
            pong.setResponseCode(200);
            pong.setHeaders(new Pair[]{Pair.of("x-everrest-websocket-message-type", "pong")});
            this.doSendMessage(pong);
            return;
        }
        if ("subscribe-channel".equalsIgnoreCase(messageType) || "unsubscribe-channel".equalsIgnoreCase(messageType)) {
            String channel = this.parseSubscriptionMessage(input);
            RESTfulOutputMessage response = this.newOutputMessage(request);
            response.setBody(request.getBody());
            response.setHeaders(new Pair[]{Pair.of("x-everrest-websocket-message-type", messageType)});
            if (channel != null) {
                if ("subscribe-channel".equalsIgnoreCase(messageType)) {
                    this.connection.subscribeToChannel(channel);
                } else {
                    this.connection.unsubscribeFromChannel(channel);
                }
                response.setResponseCode(200);
            } else {
                LOG.error("Invalid message: {} ", (Object)input.getBody());
                response.setResponseCode(400);
            }
            this.doSendMessage(response);
            return;
        }
        final String uuid = request.getUuid();
        if (uuid == null) {
            throw new IllegalArgumentException("Invalid input message. Message UUID is required. ");
        }
        if (this.inProgress.contains(uuid)) {
            RESTfulOutputMessage response = this.newOutputMessage(request);
            response.setResponseCode(202);
            this.doSendMessage(response);
        }
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    URI requestUri;
                    String requestPath;
                    ByteArrayInputStream data = null;
                    String body = input.getBody();
                    if (body != null) {
                        try {
                            data = new ByteArrayInputStream(body.getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalStateException(e.getMessage(), e);
                        }
                    }
                    URI uRI = (requestPath = request.getPath()) == null || requestPath.isEmpty() ? URI.create("/") : (requestUri = URI.create(requestPath.charAt(0) == '/' ? requestPath : '/' + requestPath));
                    if (data != null) {
                        headers.putSingle((Object)"content-length", (Object)Integer.toString(data.available()));
                    }
                    RESTfulOutputMessage response = WS2RESTAdapter.this.newOutputMessage(request);
                    ContainerRequest internalRequest = new ContainerRequest(request.getMethod(), requestUri, BASE_URI, (InputStream)data, (MultivaluedMap)new InputHeadersMap((Map)headers), WS2RESTAdapter.this.securityContext);
                    ContainerResponse internalResponse = new ContainerResponse((ContainerResponseWriter)new EverrestResponseWriter(response));
                    EnvironmentContext env = new EnvironmentContext();
                    env.put(WSConnection.class, (Object)WS2RESTAdapter.this.connection);
                    WS2RESTAdapter.this.everrestProcessor.process((GenericContainerRequest)internalRequest, (GenericContainerResponse)internalResponse, env);
                    WS2RESTAdapter.this.doSendMessage(response);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    WS2RESTAdapter.this.inProgress.remove(uuid);
                }
            }
        });
        RESTfulOutputMessage restOutputMessage = this.newOutputMessage(request);
        restOutputMessage.setResponseCode(202);
        this.inProgress.add(uuid);
        this.doSendMessage(restOutputMessage);
    }

    @Override
    public void onError(Exception error) {
        LOG.error(error.getMessage(), (Throwable)error);
        if (error instanceof MessageConversionException) {
            try {
                this.connection.close(1008, error.getMessage());
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private RESTfulOutputMessage newOutputMessage(RESTfulInputMessage input) {
        RESTfulOutputMessage output = new RESTfulOutputMessage();
        output.setUuid(input.getUuid());
        output.setMethod(input.getMethod());
        output.setPath(input.getPath());
        return output;
    }

    private void doSendMessage(OutputMessage output) {
        if (this.connection.isConnected()) {
            try {
                this.connection.sendMessage(output);
            }
            catch (IOException | MessageConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        } else {
            LOG.warn("Connection is already closed. ");
        }
    }

    private String parseSubscriptionMessage(InputMessage input) {
        JsonParser p = new JsonParser();
        try {
            p.parse((Reader)new StringReader(input.getBody()));
        }
        catch (JsonException e) {
            return null;
        }
        JsonValue jv = p.getJsonObject().getElement("channel");
        return jv != null ? jv.getStringValue() : null;
    }
}

