/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.websocket.EncodeException;
import org.everrest.core.util.Logger;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSConnectionImpl;
import org.everrest.websockets.WSConnectionListener;
import org.everrest.websockets.message.ChannelBroadcastMessage;
import org.everrest.websockets.message.Pair;
import org.everrest.websockets.message.RestOutputMessage;

public class WSConnectionContext {
    private static final Logger LOG = Logger.getLogger(WSConnectionContext.class);
    static final List<WSConnectionListener> connectionListeners = new CopyOnWriteArrayList<WSConnectionListener>();
    static final Map<Long, WSConnectionImpl> connections = new ConcurrentHashMap<Long, WSConnectionImpl>();

    public static boolean registerConnectionListener(WSConnectionListener listener) {
        return connectionListeners.add(listener);
    }

    public static boolean removeConnectionListener(WSConnectionListener listener) {
        return connectionListeners.remove(listener);
    }

    public static void sendMessage(ChannelBroadcastMessage message) throws EncodeException, IOException {
        String channel = message.getChannel();
        RestOutputMessage transport = WSConnectionContext.newRestOutputMessage(message);
        Throwable error = null;
        for (WSConnectionImpl connection : connections.values()) {
            if (!connection.getChannels().contains(channel)) continue;
            try {
                connection.sendMessage(transport);
            }
            catch (IOException | EncodeException e) {
                if (error != null) continue;
                error = e;
            }
        }
        if (error instanceof EncodeException) {
            throw (EncodeException)error;
        }
        if (error != null) {
            throw (IOException)error;
        }
    }

    private static RestOutputMessage newRestOutputMessage(ChannelBroadcastMessage message) {
        RestOutputMessage transport = new RestOutputMessage();
        transport.setUuid(message.getUuid());
        transport.setHeaders(new Pair[]{Pair.of("x-everrest-websocket-channel", message.getChannel()), Pair.of("x-everrest-websocket-message-type", message.getType().toString())});
        transport.setBody(message.getBody());
        return transport;
    }

    private WSConnectionContext() {
    }

    static {
        WSConnectionContext.registerConnectionListener(new WSConnectionListener(){

            @Override
            public void onOpen(WSConnection connection) {
                LOG.debug("Open connection {} ", (Object)connection);
            }

            @Override
            public void onClose(WSConnection connection) {
                LOG.debug("Close connection {} with status {} ", (Object)connection, (Object)connection.getCloseStatus());
                connections.remove(connection.getId());
            }
        });
    }
}

