/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.model.filter.aggregation;

import groovy.transform.ToString;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregationType;
import org.exoplatform.analytics.utils.AnalyticsUtils;

@ToString
public class AnalyticsAggregation
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2130321038232532587L;
    public static final String YEAR_INTERVAL = "year";
    public static final String MONTH_INTERVAL = "month";
    public static final String QUARTER_INTERVAL = "quarter";
    public static final String WEEK_INTERVAL = "week";
    public static final String DAY_INTERVAL = "day";
    public static final String HOUR_INTERVAL = "hour";
    public static final String MINUTE_INTERVAL = "minute";
    public static final String SECOND_INTERVAL = "second";
    public static final DateTimeFormatter YEAR_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu");
    public static final DateTimeFormatter QUARTER_DATE_FORMATTER = DateTimeFormatter.ofPattern("QQQ uuuu");
    public static final DateTimeFormatter MONTH_DATE_FORMATTER = DateTimeFormatter.ofPattern("MMM uuuu");
    public static final DateTimeFormatter DAY_DATE_FORMATTER = DateTimeFormatter.ofPattern("d MMM uuuu");
    public static final DateTimeFormatter WEEK_DATE_FORMATTER = DateTimeFormatter.ofPattern("'W'w uuuu");
    public static final DateTimeFormatter HOUR_DATE_FORMATTER = DateTimeFormatter.ofPattern("hh a, d MMM uuuu");
    private AnalyticsAggregationType type;
    private String field;
    private String sortDirection;
    private String interval;

    public AnalyticsAggregation(String field) {
        this.field = field;
        this.type = AnalyticsAggregationType.COUNT;
    }

    public String getLabel(String fieldValue, String lang) {
        if (this.type == AnalyticsAggregationType.DATE) {
            long timestamp = Long.parseLong(fieldValue);
            return this.formatTime(timestamp, lang);
        }
        return AnalyticsUtils.compueLabel(this.field, fieldValue);
    }

    private String formatTime(long timestamp, String lang) {
        Locale userLocale = StringUtils.isBlank((CharSequence)lang) ? Locale.getDefault() : new Locale(lang);
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), TimeZone.getDefault().toZoneId());
        DateTimeFormatter dateFormatter = null;
        switch (this.interval) {
            case "year": {
                dateFormatter = YEAR_DATE_FORMATTER;
                break;
            }
            case "quarter": {
                dateFormatter = QUARTER_DATE_FORMATTER;
                break;
            }
            case "month": {
                dateFormatter = MONTH_DATE_FORMATTER;
                break;
            }
            case "week": {
                dateFormatter = WEEK_DATE_FORMATTER;
                break;
            }
            case "day": {
                dateFormatter = DAY_DATE_FORMATTER;
                break;
            }
            case "hour": {
                dateFormatter = HOUR_DATE_FORMATTER;
                break;
            }
            default: {
                dateFormatter = DAY_DATE_FORMATTER;
            }
        }
        return dateTime.format(dateFormatter.withLocale(userLocale));
    }

    public AnalyticsAggregation clone() {
        return new AnalyticsAggregation(this.type, this.field, this.sortDirection, this.interval);
    }

    public AnalyticsAggregationType getType() {
        return this.type;
    }

    public String getField() {
        return this.field;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setType(AnalyticsAggregationType type) {
        this.type = type;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setSortDirection(String sortDirection) {
        this.sortDirection = sortDirection;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsAggregation)) {
            return false;
        }
        AnalyticsAggregation other = (AnalyticsAggregation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnalyticsAggregationType this$type = this.getType();
        AnalyticsAggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsAggregation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnalyticsAggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        return result;
    }

    public String toString() {
        return "AnalyticsAggregation(type=" + (Object)((Object)this.getType()) + ", field=" + this.getField() + ", sortDirection=" + this.getSortDirection() + ", interval=" + this.getInterval() + ")";
    }

    public AnalyticsAggregation(AnalyticsAggregationType type, String field, String sortDirection, String interval) {
        this.type = type;
        this.field = field;
        this.sortDirection = sortDirection;
        this.interval = interval;
    }

    public AnalyticsAggregation() {
    }
}

