/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.model.filter;

import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.filter.AbstractAnalyticsFilter;
import org.exoplatform.analytics.model.filter.AnalyticsFilter;
import org.exoplatform.analytics.model.filter.AnalyticsPeriod;
import org.exoplatform.analytics.model.filter.AnalyticsPeriodType;
import org.exoplatform.analytics.model.filter.AnalyticsTableColumnAggregation;
import org.exoplatform.analytics.model.filter.AnalyticsTableColumnFilter;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregationType;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilter;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilterType;

public class AnalyticsTableFilter
extends AbstractAnalyticsFilter {
    static final long serialVersionUID = 8707611304110081607L;
    private AnalyticsTableColumnFilter mainColumn = null;
    private List<AnalyticsTableColumnFilter> columns = new ArrayList<AnalyticsTableColumnFilter>();
    private int pageSize;
    private String sortBy = null;
    private String sortDirection = null;

    public AnalyticsTableFilter(String title, String timeZone, AnalyticsTableColumnFilter clonedMainColumn, List<AnalyticsTableColumnFilter> clonedColumns, int pageSize, String sortBy, String sortDirection) {
        this(clonedMainColumn, clonedColumns, pageSize, sortBy, sortDirection);
        this.setTitle(title);
        this.setTimeZone(timeZone);
    }

    public AnalyticsTableColumnFilter getColumnFilter(int columnIndex) {
        if (columnIndex == 0) {
            return this.mainColumn == null ? null : this.mainColumn.clone();
        }
        if (columnIndex <= this.columns.size()) {
            return this.columns.get(columnIndex - 1).clone();
        }
        return null;
    }

    public AnalyticsFilter buildColumnFilter(AnalyticsPeriod period, AnalyticsPeriodType periodType, AnalyticsFieldFilter fieldFilter, int limit, String sortDirection, int columnIndex, boolean isValue) {
        AnalyticsTableColumnFilter column = null;
        if (columnIndex == 0) {
            column = this.mainColumn == null ? null : this.mainColumn.clone();
        } else if (columnIndex <= this.columns.size()) {
            column = this.columns.get(columnIndex - 1).clone();
        }
        if (this.mainColumn == null) {
            throw new IllegalStateException("Main Column is not set");
        }
        if (this.mainColumn.getValueAggregation() == null || this.mainColumn.getValueAggregation().getAggregation() == null || this.mainColumn.getValueAggregation().getAggregation().getField() == null) {
            throw new IllegalStateException("Main Column aggregation is not set");
        }
        if (column == null) {
            throw new IllegalStateException("Column with index " + columnIndex + " doesn't exist");
        }
        AnalyticsTableColumnAggregation columnAggregation = isValue ? column.getValueAggregation() : column.getThresholdAggregation();
        ArrayList<AnalyticsAggregation> xAxisAggregations = new ArrayList<AnalyticsAggregation>();
        xAxisAggregations.add(this.mainColumn.getValueAggregation().getAggregation());
        AnalyticsAggregation yAxisAggregation = null;
        if (columnIndex > 0) {
            yAxisAggregation = columnAggregation.getAggregation();
        }
        List<AnalyticsFieldFilter> filters = columnAggregation.getFilters();
        if (fieldFilter != null) {
            filters.add(fieldFilter);
        }
        if (this.mainColumn.getValueAggregation() != null && this.mainColumn.getValueAggregation().getFilters() != null && !this.mainColumn.getValueAggregation().getFilters().isEmpty()) {
            filters.addAll(this.mainColumn.getValueAggregation().getFilters());
        }
        if (period != null && !columnAggregation.isPeriodIndependent()) {
            this.addPeriodFilter(period, periodType, xAxisAggregations, filters, column.isPreviousPeriod());
        }
        AnalyticsAggregation lastAggregation = (AnalyticsAggregation)xAxisAggregations.get(xAxisAggregations.size() - 1);
        if (StringUtils.isNotBlank((CharSequence)sortDirection)) {
            lastAggregation.setSortDirection(sortDirection);
        }
        if (limit > 0) {
            lastAggregation.setLimit(limit);
        }
        return new AnalyticsFilter(null, null, null, filters, null, xAxisAggregations, yAxisAggregation, null, 0L, limit);
    }

    public AnalyticsPeriod getCurrentPeriod(AnalyticsPeriod period, AnalyticsPeriodType periodType) {
        if (periodType == null) {
            return period;
        }
        return periodType.getCurrentPeriod(this.middleOfPeriod(period), this.zoneId());
    }

    private LocalDate middleOfPeriod(AnalyticsPeriod period) {
        return Instant.ofEpochMilli(period.getFromInMS() + (period.getToInMS() - period.getFromInMS()) / 2L).atZone(this.zoneId()).toLocalDate();
    }

    public AnalyticsPeriod getPreviousPeriod(AnalyticsPeriod period, AnalyticsPeriodType periodType) {
        if (periodType == null) {
            return period.previousPeriod();
        }
        return periodType.getPreviousPeriod(this.middleOfPeriod(period), this.zoneId());
    }

    public AnalyticsTableFilter clone() {
        AnalyticsTableColumnFilter clonedMainColumn = this.mainColumn == null ? null : this.mainColumn.clone();
        List<AnalyticsTableColumnFilter> clonedColumns = this.columns == null ? null : this.columns.stream().map(AnalyticsTableColumnFilter::clone).collect(Collectors.toList());
        return new AnalyticsTableFilter(this.getTitle(), this.getTimeZone(), clonedMainColumn, clonedColumns, this.pageSize, this.sortBy, this.sortDirection);
    }

    private void addPeriodFilter(AnalyticsPeriod period, AnalyticsPeriodType periodType, List<AnalyticsAggregation> xAxisAggregations, List<AnalyticsFieldFilter> filters, boolean compareWithPreviousPeriod) {
        long fromInMS = period.getFromInMS();
        long toInMS = period.getToInMS();
        if (compareWithPreviousPeriod) {
            String interval;
            String offset = null;
            if (periodType == null) {
                previousPeriod = period.previousPeriod();
                fromInMS = previousPeriod.getFromInMS();
                long diffInDays = period.getDiffInDays();
                if (diffInDays > 0L) {
                    interval = period.getInterval();
                    long offsetLong = fromInMS / 86400000L % diffInDays;
                    if (offsetLong > 0L) {
                        offset = offsetLong + "d";
                    }
                } else {
                    interval = "1d";
                }
            } else {
                previousPeriod = periodType.getPreviousPeriod(period.getFrom(), this.zoneId());
                fromInMS = previousPeriod.getFromInMS();
                interval = periodType.getInterval();
                if (periodType.getOffset(previousPeriod.getFromInMS()) > 0L) {
                    offset = periodType.getOffset(previousPeriod.getFromInMS()) + "d";
                }
            }
            xAxisAggregations.add(0, new AnalyticsAggregation(AnalyticsAggregationType.DATE, "timestamp", "asc", interval, offset, 2L, true, fromInMS, toInMS));
        }
        AnalyticsFieldFilter periodFilter = new AnalyticsFieldFilter("timestamp", AnalyticsFieldFilterType.RANGE, new AnalyticsFilter.Range(fromInMS, toInMS));
        filters.add(periodFilter);
    }

    public AnalyticsTableColumnFilter getMainColumn() {
        return this.mainColumn;
    }

    public List<AnalyticsTableColumnFilter> getColumns() {
        return this.columns;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public void setMainColumn(AnalyticsTableColumnFilter mainColumn) {
        this.mainColumn = mainColumn;
    }

    public void setColumns(List<AnalyticsTableColumnFilter> columns) {
        this.columns = columns;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortDirection(String sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Override
    public String toString() {
        return "AnalyticsTableFilter(super=" + super.toString() + ", mainColumn=" + this.getMainColumn() + ", columns=" + this.getColumns() + ", pageSize=" + this.getPageSize() + ", sortBy=" + this.getSortBy() + ", sortDirection=" + this.getSortDirection() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsTableFilter)) {
            return false;
        }
        AnalyticsTableFilter other = (AnalyticsTableFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        AnalyticsTableColumnFilter this$mainColumn = this.getMainColumn();
        AnalyticsTableColumnFilter other$mainColumn = other.getMainColumn();
        if (this$mainColumn == null ? other$mainColumn != null : !((Object)this$mainColumn).equals(other$mainColumn)) {
            return false;
        }
        List<AnalyticsTableColumnFilter> this$columns = this.getColumns();
        List<AnalyticsTableColumnFilter> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$sortBy = this.getSortBy();
        String other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !this$sortBy.equals(other$sortBy)) {
            return false;
        }
        String this$sortDirection = this.getSortDirection();
        String other$sortDirection = other.getSortDirection();
        return !(this$sortDirection == null ? other$sortDirection != null : !this$sortDirection.equals(other$sortDirection));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsTableFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        AnalyticsTableColumnFilter $mainColumn = this.getMainColumn();
        result = result * 59 + ($mainColumn == null ? 43 : ((Object)$mainColumn).hashCode());
        List<AnalyticsTableColumnFilter> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : $sortBy.hashCode());
        String $sortDirection = this.getSortDirection();
        result = result * 59 + ($sortDirection == null ? 43 : $sortDirection.hashCode());
        return result;
    }

    public AnalyticsTableFilter() {
    }

    public AnalyticsTableFilter(AnalyticsTableColumnFilter mainColumn, List<AnalyticsTableColumnFilter> columns, int pageSize, String sortBy, String sortDirection) {
        this.mainColumn = mainColumn;
        this.columns = columns;
        this.pageSize = pageSize;
        this.sortBy = sortBy;
        this.sortDirection = sortDirection;
    }
}

