/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.portal;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.NewUserEventListener;

public class UserAnalyticsEventListener
extends NewUserEventListener {
    private ThreadLocal<Long> operationStartTime = new ThreadLocal();

    public UserAnalyticsEventListener(InitParams params) throws Exception {
        super(params);
    }

    public void preSave(User user, boolean isNew) throws Exception {
        this.operationStartTime.set(System.currentTimeMillis());
    }

    public void preSetEnabled(User user) throws Exception {
        this.operationStartTime.set(System.currentTimeMillis());
    }

    public void preDelete(User user) throws Exception {
        this.operationStartTime.set(System.currentTimeMillis());
    }

    public void postSave(User user, boolean isNew) throws Exception {
        StatisticData statisticData = this.buildStatisticData(isNew ? "createUser" : "saveUser", user);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void postSetEnabled(User user) throws Exception {
        StatisticData statisticData = this.buildStatisticData("enableUser", user);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void postDelete(User user) throws Exception {
        StatisticData statisticData = this.buildStatisticData("deleteUser", user);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private StatisticData buildStatisticData(String operation, User user) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("organization");
        statisticData.setSubModule("user");
        statisticData.setOperation(operation);
        statisticData.setUserId(AnalyticsUtils.getUserIdentityId((String)user.getUserName()));
        statisticData.setDuration(this.getDuration());
        statisticData.addParameter("isEnabled", (Object)user.isEnabled());
        long currentUserIdentityId = AnalyticsUtils.getCurrentUserIdentityId();
        if (currentUserIdentityId > 0L) {
            statisticData.addParameter("modifierSocialId", (Object)currentUserIdentityId);
        }
        return statisticData;
    }

    private long getDuration() {
        Long startTime = this.operationStartTime.get();
        if (startTime == null) {
            return 0L;
        }
        this.operationStartTime.remove();
        return System.currentTimeMillis() - startTime;
    }
}

