/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AnalyticsActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(AnalyticsActivityListener.class);

    public void saveActivity(ActivityLifeCycleEvent event) {
        StatisticData statisticData = this.addActivityStatisticEvent(event, "createActivity");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        StatisticData statisticData = this.addActivityStatisticEvent(event, "updateActivity");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        StatisticData statisticData = this.addActivityStatisticEvent(event, "createComment");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        StatisticData statisticData = this.addActivityStatisticEvent(event, "updateComment");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        StatisticData statisticData = this.addActivityStatisticEvent(event, "likeActivity");
        this.addLikeIdentityId(statisticData, event);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        StatisticData statisticData = this.addActivityStatisticEvent(event, "likeComment");
        this.addLikeIdentityId(statisticData, event);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private void addLikeIdentityId(StatisticData statisticData, ActivityLifeCycleEvent event) {
        String[] likeIdentityIds = event.getActivity().getLikeIdentityIds();
        if (likeIdentityIds != null && likeIdentityIds.length > 0) {
            String likerId = likeIdentityIds[likeIdentityIds.length - 1];
            statisticData.addParameter("likeIdentityId", (Object)likerId);
        }
    }

    private StatisticData addActivityStatisticEvent(ActivityLifeCycleEvent event, String operation) {
        ActivityStream activityStream;
        ExoSocialActivity activity = event.getActivity();
        String activityId = activity.getParentId() == null ? activity.getId() : activity.getParentId();
        String commentId = activity.getParentCommentId() == null ? activity.getId() : activity.getParentCommentId();
        String subCommentId = activity.getParentCommentId() == null ? null : activity.getId();
        long modifierUserId = 0L;
        if (StringUtils.isNotBlank((CharSequence)activity.getPosterId())) {
            try {
                long identityId = Long.parseLong(activity.getPosterId());
                Identity identity = AnalyticsUtils.getIdentity((String)activity.getPosterId());
                if (identity != null && StringUtils.equals((CharSequence)identity.getProviderId(), (CharSequence)"organization")) {
                    modifierUserId = identityId;
                }
            }
            catch (NumberFormatException e1) {
                modifierUserId = AnalyticsUtils.getUserIdentityId((String)activity.getPosterId());
            }
        }
        if (modifierUserId == 0L) {
            modifierUserId = AnalyticsUtils.getCurrentUserIdentityId();
        }
        if (((activityStream = activity.getActivityStream()) == null || activityStream.getType() == null || activityStream.getPrettyId() == null) && StringUtils.isNotBlank((CharSequence)activity.getParentId())) {
            ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
            ExoSocialActivity parentActivity = activityManager.getActivity(activity.getParentId());
            activityStream = parentActivity.getActivityStream();
        }
        long spaceId = 0L;
        String spaceTemplate = null;
        long userId = modifierUserId;
        long streamIdentityId = 0L;
        Identity streamIdentity = null;
        if (activityStream != null) {
            ActivityStream.Type type = activityStream.getType();
            boolean isSpace = type == ActivityStream.Type.SPACE;
            String streamProviderId = isSpace ? "space" : "organization";
            String streamRemoteId = activityStream.getPrettyId();
            try {
                streamIdentity = AnalyticsUtils.getIdentity((String)streamProviderId, (String)streamRemoteId);
            }
            catch (Exception e) {
                LOG.debug("Can't retrieve identity with providerId {} and remoteId {}. Attempt to retrieve it as Identity technical ID", new Object[]{streamProviderId, streamRemoteId, e});
                streamIdentity = AnalyticsUtils.getIdentity((String)activityStream.getId());
            }
        }
        if (streamIdentity != null) {
            streamIdentityId = Long.parseLong(streamIdentity.getId());
            if (StringUtils.equals((CharSequence)streamIdentity.getProviderId(), (CharSequence)"space")) {
                SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
                Space space = spaceService.getSpaceByPrettyName(streamIdentity.getRemoteId());
                spaceId = space == null ? 0L : Long.parseLong(space.getId());
                spaceTemplate = space == null ? null : space.getTemplate();
            } else {
                userId = streamIdentityId;
            }
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("activity");
        statisticData.setOperation(operation);
        statisticData.setSpaceId(spaceId);
        statisticData.setUserId(userId);
        if (modifierUserId > 0L) {
            statisticData.addParameter("modifierSocialId", (Object)modifierUserId);
        }
        if (spaceTemplate != null) {
            statisticData.addParameter("spaceTemplate", (Object)spaceTemplate);
        }
        statisticData.addParameter("streamIdentityId", (Object)streamIdentityId);
        statisticData.addParameter("activityType", (Object)activity.getType());
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            statisticData.addParameter("activityId", (Object)activityId);
        }
        if (StringUtils.isNotBlank((CharSequence)commentId)) {
            commentId = commentId.replace("comment", "");
            statisticData.addParameter("comment", (Object)commentId);
        }
        if (StringUtils.isNotBlank((CharSequence)subCommentId)) {
            subCommentId = subCommentId.replace("comment", "");
            statisticData.addParameter("subCommentId", (Object)subCommentId);
        }
        return statisticData;
    }
}

