/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class AnalyticsProfileListener
extends ProfileListenerPlugin {
    public void avatarUpdated(ProfileLifeCycleEvent event) {
        StatisticData statisticData = this.buildStatisticData("avatar", (String)event.getSource());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        StatisticData statisticData = this.buildStatisticData("banner", (String)event.getSource());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        StatisticData statisticData = this.buildStatisticData("contactSection", (String)event.getSource());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        StatisticData statisticData = this.buildStatisticData("experienceSection", (String)event.getSource());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void createProfile(ProfileLifeCycleEvent event) {
        StatisticData statisticData = this.buildStatisticData("createProfile", (String)event.getSource());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private StatisticData buildStatisticData(String operation, String username) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("profile");
        statisticData.setOperation(operation);
        statisticData.setUserId(AnalyticsUtils.getUserIdentityId((String)username));
        long currentUserIdentityId = AnalyticsUtils.getCurrentUserIdentityId();
        if (currentUserIdentityId > 0L) {
            statisticData.addParameter("modifierSocialId", (Object)currentUserIdentityId);
        }
        return statisticData;
    }
}

