/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.portal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class PageAccessListener
extends BaseComponentPlugin
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final Log LOG = ExoLogger.getLogger(PageAccessListener.class);
    private ThreadLocal<Long> operationStartTime = new ThreadLocal();
    private boolean collectAjaxQueries = false;

    public PageAccessListener(InitParams params) {
        if (params != null && params.containsKey((Object)"collectAjaxQueries")) {
            this.collectAjaxQueries = Boolean.parseBoolean(params.getValueParam("collectAjaxQueries").getValue());
        }
    }

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        this.operationStartTime.set(System.currentTimeMillis());
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        StatisticData statisticData = this.buildStatisticData(context);
        if (statisticData == null) {
            this.operationStartTime.remove();
        } else {
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onDestroy(Application app) throws Exception {
    }

    private StatisticData buildStatisticData(WebuiRequestContext context) {
        try {
            HttpServletResponse httpResponse;
            UserNode node;
            boolean ajaxQuery;
            PortalRequestContext portalRequestContext = (PortalRequestContext)context;
            if (portalRequestContext == null) {
                return null;
            }
            HttpServletRequest httpRequest = portalRequestContext.getRequest();
            boolean bl = ajaxQuery = portalRequestContext.useAjax() || httpRequest.getParameter("portal:componentId") != null;
            if (ajaxQuery && !this.collectAjaxQueries) {
                return null;
            }
            StatisticData statisticData = new StatisticData();
            statisticData.setModule("portal");
            if (ajaxQuery) {
                statisticData.setSubModule("webui");
                statisticData.setOperation("ajaxRequest");
            } else {
                statisticData.setSubModule("page");
                statisticData.setOperation("pageDisplay");
            }
            long userIdentityId = AnalyticsUtils.getUserIdentityId((String)context.getRemoteUser());
            statisticData.setUserId(userIdentityId);
            Space space = SpaceUtils.getSpaceByContext();
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
            statisticData.addParameter("httpRequestMethod", (Object)httpRequest.getMethod());
            statisticData.addParameter("httpRequestUri", (Object)httpRequest.getRequestURI());
            statisticData.addParameter("httpRequestProtocol", (Object)httpRequest.getProtocol());
            statisticData.addParameter("httpRequestContentType", (Object)httpRequest.getContentType());
            statisticData.addParameter("httpRequestContentLength", (Object)httpRequest.getContentLength());
            statisticData.addParameter("userLocale", (Object)portalRequestContext.getLocale());
            statisticData.addParameter("portalOwner", (Object)portalRequestContext.getPortalOwner());
            statisticData.addParameter("portalUri", (Object)portalRequestContext.getPortalURI());
            statisticData.addParameter("pageTitle", (Object)portalRequestContext.getTitle());
            UIPortal uiportal = Util.getUIPortal();
            if (uiportal != null && (node = uiportal.getSelectedUserNode()) != null) {
                statisticData.addParameter("pageUri", (Object)node.getURI());
                statisticData.addParameter("pageName", (Object)node.getName());
            }
            if ((httpResponse = portalRequestContext.getResponse()) != null) {
                statisticData.addParameter("httpResponseContentType", (Object)httpResponse.getContentType());
                statisticData.addParameter("httpResponseContentLength", (Object)httpResponse.getBufferSize());
                statisticData.addParameter("httpResponseStatus", (Object)httpResponse.getStatus());
                if (httpResponse.getStatus() >= 400) {
                    statisticData.setErrorCode((long)httpResponse.getStatus());
                    statisticData.setStatus(StatisticData.StatisticStatus.KO);
                } else {
                    statisticData.setStatus(StatisticData.StatisticStatus.OK);
                }
            }
            statisticData.setDuration(this.getDuration());
            return statisticData;
        }
        catch (Exception e) {
            LOG.debug((Object)"Error computing page statistics", (Throwable)e);
            return null;
        }
    }

    private long getDuration() {
        Long startTime = this.operationStartTime.get();
        if (startTime == null) {
            return 0L;
        }
        this.operationStartTime.remove();
        return System.currentTimeMillis() - startTime;
    }
}

