/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.webconferencing;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.GroupInfo;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.WebConferencingService;

@Asynchronous
public class WebConferencingListener
extends Listener<CallInfo, String> {
    private static final Log LOG = ExoLogger.getLogger(WebConferencingListener.class);
    private ExoContainer container;
    private SpaceService spaceService;

    public WebConferencingListener(PortalContainer container) {
        this.container = container;
    }

    public void onEvent(Event<CallInfo, String> event) throws Exception {
        Space space;
        CallInfo callInfo = (CallInfo)event.getSource();
        String username = (String)event.getData();
        if (callInfo == null) {
            LOG.warn((Object)"Call information is null.");
            return;
        }
        long userIdentityId = AnalyticsUtils.getUserIdentityId((String)username);
        if (userIdentityId <= 0L) {
            LOG.warn("User '{}' identity identifier can't be found.", new Object[]{username});
            return;
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule(callInfo.getProviderType());
        statisticData.setSubModule("web-conferencing");
        statisticData.setUserId(userIdentityId);
        long callDuration = 0L;
        String operation = null;
        switch (event.getEventName()) {
            case "exo.webconferencing.callCreated": {
                operation = "callCreated";
                break;
            }
            case "exo.webconferencing.callJoined": {
                operation = "callJoined";
                if (callInfo.getLastDate() == null) break;
                callDuration = (System.currentTimeMillis() - callInfo.getLastDate().getTime()) / 1000L;
                break;
            }
            case "exo.webconferencing.callLeft": {
                operation = "callLeft";
                if (callInfo.getLastDate() == null) break;
                callDuration = (System.currentTimeMillis() - callInfo.getLastDate().getTime()) / 1000L;
                break;
            }
            case "exo.webconferencing.callRecorded": {
                operation = "callRecorded";
                if (callInfo.getLastDate() == null) break;
                callDuration = (System.currentTimeMillis() - callInfo.getLastDate().getTime()) / 1000L;
                break;
            }
            case "exo.webconferencing.callStarted": {
                operation = "callStarted";
                break;
            }
            case "exo.webconferencing.callStopped": {
                operation = "callStopped";
                if (callInfo.getLastDate() == null) break;
                callDuration = (System.currentTimeMillis() - callInfo.getLastDate().getTime()) / 1000L;
                break;
            }
        }
        statisticData.setOperation(operation);
        IdentityInfo callOwner = callInfo.getOwner();
        String callType = null;
        if (callOwner instanceof WebConferencingService.SpaceInfo) {
            space = this.getSpaceService().getSpaceByGroupId(((WebConferencingService.SpaceInfo)callOwner).getGroupId());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
            callType = "space";
        } else if (callOwner instanceof WebConferencingService.SpaceEventInfo) {
            space = this.getSpaceService().getSpaceByGroupId(((WebConferencingService.SpaceEventInfo)callOwner).getGroupId());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
            callType = "space";
        } else {
            callType = callOwner instanceof GroupInfo ? "group" : "user";
        }
        Set participants = callInfo.getParticipants() == null ? Collections.emptySet() : callInfo.getParticipants();
        long participantsCount = participants.size();
        long activeParticipantsCount = participants.stream().filter(participant -> StringUtils.equals((CharSequence)"joined", (CharSequence)participant.getState())).count();
        statisticData.addParameter("participantsCount", (Object)participantsCount);
        statisticData.addParameter("activeParticipantsCount", (Object)activeParticipantsCount);
        statisticData.addParameter("callId", (Object)callInfo.getId());
        statisticData.addParameter("callType", (Object)callType);
        statisticData.addParameter("callOwnerType", (Object)callInfo.getOwner().getType());
        statisticData.addParameter("callStartDate", (Object)callInfo.getStartDate());
        statisticData.addParameter("callEndDate", (Object)callInfo.getEndDate());
        statisticData.addParameter("callState", (Object)callInfo.getState());
        if (callDuration > 0L) {
            statisticData.addParameter("callDuration", (Object)callDuration);
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }
}

