/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class AnalyticsProfileListener
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(AnalyticsProfileListener.class);

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        try {
            StatisticData statisticData;
            AvatarAttachment avatarAttachment = (AvatarAttachment)((Profile)event.getPayload()).getProperty("avatar");
            if (avatarAttachment != null && (statisticData = this.buildStatisticData("avatar", (String)event.getSource())) != null) {
                statisticData.addParameter("imageSize", (Object)avatarAttachment.getSize());
                statisticData.addParameter("imageType", (Object)avatarAttachment.getMimeType());
                AnalyticsUtils.addStatisticData((StatisticData)statisticData);
            }
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.buildStatisticData("banner", (String)event.getSource());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.buildStatisticData("contactSection", (String)event.getSource());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.buildStatisticData("experienceSection", (String)event.getSource());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void createProfile(ProfileLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.buildStatisticData("createProfile", (String)event.getSource());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    private void handleErrorProcessingOperation(ProfileLifeCycleEvent event, Exception exception) {
        LOG.warn("Error adding Statistic data for user {} with event {}", new Object[]{event.getUsername(), event.getType(), exception});
    }

    private StatisticData buildStatisticData(String operation, String username) {
        Identity identity = AnalyticsUtils.getIdentity((String)"organization", (String)username);
        if (identity == null) {
            return null;
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("profile");
        statisticData.setOperation(operation);
        statisticData.setUserId(Long.parseLong(identity.getId()));
        statisticData.addParameter("identityId", (Object)Long.parseLong(identity.getId()));
        statisticData.addParameter("userCreatedDate", (Object)(identity.getProfile() != null ? identity.getProfile().getCreatedTime() : 0L));
        return statisticData;
    }
}

