/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.es;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.api.service.StatisticDataQueueService;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class AnalyticsIndexingServiceConnector
extends ElasticIndexingServiceConnector
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(AnalyticsIndexingServiceConnector.class);
    public static final String DEFAULT_ES_INDEX_TEMPLATE = "analytics_template";
    public static final String DEFAULT_ES_ANALYTICS_INDEX_NAME = "analytics";
    public static final String ES_ANALYTICS_INDEX_PREFIX = "exo.es.analytics.index.prefix";
    public static final String ES_ANALYTICS_INDEX_TEMPLATE = "exo.es.analytics.index.template";
    public static final Context ES_ANALYTICS_CONTEXT = Context.GLOBAL.id("analytics");
    public static final Scope ES_ANALYTICS_SCOPE = Scope.APPLICATION.id("analytics");
    private SettingService settingService;
    private StatisticDataQueueService analyticsQueueService;
    private String indexPrefix;
    private String indexTemplate;

    public AnalyticsIndexingServiceConnector(StatisticDataQueueService analyticsQueueService, SettingService settingService, InitParams initParams) {
        super(initParams);
        this.settingService = settingService;
        this.analyticsQueueService = analyticsQueueService;
        if (initParams != null) {
            if (initParams.containsKey((Object)ES_ANALYTICS_INDEX_PREFIX)) {
                this.indexPrefix = initParams.getValueParam(ES_ANALYTICS_INDEX_PREFIX).getValue();
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_INDEX_TEMPLATE)) {
                this.indexTemplate = initParams.getValueParam(ES_ANALYTICS_INDEX_TEMPLATE).getValue();
            }
        }
        if (StringUtils.isBlank((CharSequence)this.indexPrefix)) {
            this.indexPrefix = DEFAULT_ES_ANALYTICS_INDEX_NAME;
        }
        if (StringUtils.isBlank((CharSequence)this.indexTemplate)) {
            this.indexTemplate = DEFAULT_ES_INDEX_TEMPLATE;
        }
    }

    public void start() {
        String storedIndexTemplate;
        SettingValue indexTemplateValue = this.settingService.get(ES_ANALYTICS_CONTEXT, ES_ANALYTICS_SCOPE, ES_ANALYTICS_INDEX_TEMPLATE);
        if (indexTemplateValue != null && indexTemplateValue.getValue() != null && !StringUtils.equals((CharSequence)(storedIndexTemplate = indexTemplateValue.getValue().toString()), (CharSequence)this.indexTemplate)) {
            LOG.warn("Can't change index template from {} to {}. New index will be ignored.", new Object[]{storedIndexTemplate, this.indexTemplate});
            this.indexTemplate = storedIndexTemplate;
        }
    }

    public void stop() {
    }

    public String getConnectorName() {
        throw new UnsupportedOperationException();
    }

    public String getMapping() {
        throw new UnsupportedOperationException();
    }

    public Document create(String idString) {
        if (StringUtils.isBlank((CharSequence)idString)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        long id = Long.parseLong(idString);
        StatisticData data = this.analyticsQueueService.get(id);
        if (data == null) {
            LOG.warn("Can't find document with id {}", new Object[]{id});
            return null;
        }
        String timestampString = String.valueOf(data.getTimestamp());
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", idString);
        fields.put("timestamp", timestampString);
        fields.put("userId", String.valueOf(data.getUserId()));
        fields.put("spaceId", String.valueOf(data.getSpaceId()));
        fields.put("module", data.getModule());
        fields.put("subModule", data.getSubModule());
        fields.put("operation", data.getOperation());
        fields.put("status", String.valueOf(data.getStatus().ordinal()));
        fields.put("errorCode", String.valueOf(data.getErrorCode()));
        fields.put("errorMessage", data.getErrorMessage());
        fields.put("duration", String.valueOf(data.getDuration()));
        fields.put("isAnalytics", "true");
        if (data.getParameters() != null && !data.getParameters().isEmpty()) {
            fields.putAll(data.getParameters());
        }
        Document esDocument = new Document(String.valueOf(id), null, null, (Set)null, fields);
        if (data.getListParameters() != null && !data.getListParameters().isEmpty()) {
            esDocument.setListFields(data.getListParameters());
        }
        return esDocument;
    }

    public Document update(String id) {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public String getIndexTemplate() {
        return this.indexTemplate;
    }

    public void storeCreatedIndexTemplate() {
        this.settingService.set(ES_ANALYTICS_CONTEXT, ES_ANALYTICS_SCOPE, ES_ANALYTICS_INDEX_TEMPLATE, SettingValue.create((String)this.indexTemplate));
    }
}

