/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.faq;

import java.util.HashMap;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.extras.injection.faq.AbstractFAQInjector;

public class QuestionInjector
extends AbstractFAQInjector {
    private static final String NUMBER = "number";
    private static final String CATEGORY_PREFIX = "catPrefix";
    private static final String TO_CAT = "toCat";
    private static final String USER_PREFIX = "userPrefix";
    private static final String TO_USER = "toUser";
    private static final String QUESTION_PREFIX = "quesPrefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int toCat = this.param(params, TO_CAT);
        String userPrefix = params.get(USER_PREFIX);
        String toUser = params.get(TO_USER);
        String categoryPrefix = params.get(CATEGORY_PREFIX);
        String questionPrefix = params.get(QUESTION_PREFIX);
        this.init(userPrefix, categoryPrefix, questionPrefix, null, null, 0);
        String categoryName = this.categoryBase + toCat;
        Category cat = this.getCategoryByName(categoryName);
        if (cat == null) {
            this.getLog().info((Object)("Category name '" + categoryName + "' is wrong. Aborting injection ..."));
            return;
        }
        String owner = this.userBase + toUser;
        String questionName = null;
        Question question = null;
        for (int i = 0; i < number; ++i) {
            questionName = this.questionName();
            question = new Question();
            question.setAuthor(owner);
            question.setCategoryId(cat.getId());
            question.setCategoryPath(cat.getPath());
            question.setDetail(this.lorem.getParagraphs(1));
            question.setEmail("noreply@exoplatform.com");
            question.setEmailsWatch(new String[]{""});
            question.setLanguage("English");
            question.setLink("");
            question.setMarkVote(0.0);
            question.setQuestion(questionName);
            question.setRelations(new String[]{""});
            question.setTopicIdDiscuss("");
            question.setUsersWatch(new String[]{""});
            this.faqService.saveQuestion(question, true, this.faqSetting);
            ++this.questionNumber;
            this.getLog().info((Object)("Question '" + questionName + "' created by " + owner));
        }
    }
}

