/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.faq;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.extras.injection.faq.AbstractFAQInjector;

public class AttachmentInjector
extends AbstractFAQInjector {
    private static final String NUMBER = "number";
    private static final String FROM_QUES = "fromQues";
    private static final String TO_QUES = "toQues";
    private static final String BYTE_SIZE = "byteSize";
    private static final String QUESTION_PREFIX = "quesPrefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int fromQues = this.param(params, FROM_QUES);
        int toQues = this.param(params, TO_QUES);
        String questionPrefix = params.get(QUESTION_PREFIX);
        this.init(null, null, questionPrefix, null, null, 0);
        int byteSize = this.param(params, BYTE_SIZE);
        if (byteSize < 0 || byteSize > 99) {
            this.getLog().info((Object)("ByteSize is invalid with '" + byteSize + "' wrong. Please set it exactly in range 0 - 99 (words). Aborting injection ..."));
            return;
        }
        String questionName = null;
        Question question = null;
        for (int i = fromQues; i <= toQues; ++i) {
            questionName = this.questionBase + i;
            question = this.getQuestionByName(questionName);
            if (question == null) {
                this.getLog().info((Object)("Question name is '" + questionName + "' wrong. Aborting injection ..."));
                return;
            }
            this.generateAttachments(question, QUESTION_PREFIX, number, byteSize);
            this.faqService.saveQuestion(question, false, this.faqSetting);
            this.getLog().info((Object)("Uploads " + number + " attachments into '" + questionName + "' with each attachment's " + byteSize + " byte(s)"));
        }
    }

    private void generateAttachments(Question question, String prefix, int number, int byteSize) throws Exception {
        if (question.getAttachMent() == null || question.getAttachMent().size() == 0) {
            question.setAttachMent(new ArrayList());
        }
        int baseNumber = question.getAttachMent().size();
        String rs = this.createTextResource(byteSize);
        String attId = null;
        FileAttachment att = null;
        for (int i = 0; i < number; ++i) {
            attId = this.generateId(prefix + baseNumber, "attachment", byteSize, i);
            att = new FileAttachment();
            att.setId(attId);
            att.setName(attId);
            att.setNodeName("attachment" + baseNumber);
            att.setInputStream((InputStream)new ByteArrayInputStream(rs.getBytes("UTF-8")));
            att.setMimeType("text/plain");
            long fileSize = (long)byteSize * 1024L;
            att.setSize(fileSize);
            question.getAttachMent().add(att);
            ++baseNumber;
        }
    }

    private String generateId(String prefix, String entity, int byteSize, int order) {
        StringBuilder sb = new StringBuilder();
        sb.append(entity).append("-").append(prefix).append("_").append(this.lorem.getCharacters(byteSize)).append("_").append(order);
        return sb.toString();
    }
}

