/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.indexing.listeners;

import java.util.HashMap;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntry;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.impl.AnswerEventListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UnifiedSearchAnswerListener
extends AnswerEventListener {
    private static Log log = ExoLogger.getLogger(UnifiedSearchAnswerListener.class);
    private final IndexingService indexingService;
    private final FAQService faqService;

    public UnifiedSearchAnswerListener(IndexingService indexingService, FAQService faqService) {
        this.indexingService = indexingService;
        this.faqService = faqService;
    }

    public void saveQuestion(Question question, boolean isNew) {
        if (this.indexingService != null) {
            HashMap<String, Question> content = new HashMap<String, Question>();
            content.put("question", question);
            if (isNew) {
                SearchEntry searchEntry = new SearchEntry("answer", "question", question.getId(), content);
                this.indexingService.add(searchEntry);
            } else {
                SearchEntryId searchEntryId = new SearchEntryId("answer", "question", question.getId());
                this.indexingService.update(searchEntryId, content);
            }
        }
    }

    public void saveAnswer(String questionId, Answer answer, boolean isNew) {
        this.saveOrUpdateQuestion(questionId, isNew);
    }

    public void saveAnswer(String questionId, Answer[] answers, boolean isNew) {
        this.saveOrUpdateQuestion(questionId, isNew);
    }

    public void saveComment(String questionId, Comment comment, String language) {
        this.saveOrUpdateQuestion(questionId, false);
    }

    public void voteQuestion(String questionId) {
        this.saveOrUpdateQuestion(questionId, false);
    }

    public void unVoteQuestion(String questionId) {
        this.saveOrUpdateQuestion(questionId, false);
    }

    public void removeQuestion(String questionId) {
        if (this.indexingService != null) {
            SearchEntryId searchEntryId = new SearchEntryId("answer", "question", questionId);
            this.indexingService.delete(searchEntryId);
        }
    }

    public void removeAnswer(String questionId, String answerActivityId) {
        this.saveOrUpdateQuestion(questionId, false);
    }

    public void removeComment(String questionId, String commentActivityId, String questionPath) {
        this.saveOrUpdateQuestion(questionId, false);
    }

    private void saveOrUpdateQuestion(String questionId, boolean isNew) {
        if (this.indexingService != null) {
            try {
                Question question = this.faqService.getQuestionById(questionId);
                HashMap<String, Question> content = new HashMap<String, Question>();
                content.put("question", question);
                if (isNew) {
                    SearchEntry searchEntry = new SearchEntry("answer", "question", question.getId(), content);
                    this.indexingService.add(searchEntry);
                } else {
                    SearchEntryId searchEntryId = new SearchEntryId("answer", "question", question.getId());
                    this.indexingService.update(searchEntryId, content);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while retrieving question " + questionId), (Throwable)e);
            }
        }
    }
}

