/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.utils.PropertyChangeSupport;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.services.jcr.util.IdGenerator;

public class Question {
    public static final String QUESTION_ID = "Question".intern();
    private String id;
    private String language;
    private String question;
    private String detail;
    private String author;
    private String email;
    private boolean isActivated = true;
    private boolean isApproved = true;
    private Date createdDate;
    private String categoryId;
    private String categoryPath;
    private String[] relations;
    private String link = "";
    private List<FileAttachment> listAttachments = new ArrayList<FileAttachment>();
    private String languagesNotYetAnswered = "";
    private String[] nameAttachs;
    private Answer[] answers;
    private Comment[] comments;
    private String[] usersVote;
    private double markVote = 0.0;
    private String[] usersWatch = null;
    private String[] emailsWatch = null;
    private QuestionLanguage[] multiLanguages;
    private String topicIdDiscuss;
    private String path;
    private String authorOfLastActivity;
    private long timeOfLastActivity = -1L;
    private long numberOfPublicAnswers = 0L;
    public static String QUESTION_NAME = "questionName";
    public static String QUESTION_DETAIL = "questionDetail";
    public static String QUESTION_ACTIVATED = "questionActivated";
    public static String QUESTION_ATTACHMENT = "questionAttachment";
    public static String QUESTION_LANGUAGE = "questionLanguage";
    public static String QUESTION_RATING = "questionRating";
    private PropertyChangeSupport pcs = null;

    public Question() {
        this.id = QUESTION_ID + IdGenerator.generate();
        this.relations = new String[0];
        this.multiLanguages = new QuestionLanguage[0];
        this.pcs = new PropertyChangeSupport((Object)this);
    }

    public PropertyChangeSupport getPcs() {
        return this.pcs;
    }

    public void setPcs(PropertyChangeSupport pcs) {
        this.pcs = pcs;
    }

    public void setEditedQuestionName(String newName) {
        this.pcs.addPropertyChange(QUESTION_NAME, (Object)this.question, (Object)newName);
    }

    public void setEditedQuestionDetail(String newDetail) {
        this.pcs.addPropertyChange(QUESTION_DETAIL, (Object)this.detail, (Object)newDetail);
    }

    public void setEditedQuestionActivated(boolean activate) {
        this.pcs.addPropertyChange(QUESTION_ACTIVATED, (Object)this.isActivated, (Object)activate);
    }

    public void setEditedQuestionAttachment(int length) {
        this.pcs.addPropertyChange(QUESTION_ATTACHMENT, (Object)this.listAttachments.size(), (Object)length);
    }

    public void setEditedQuestionLanguage(int length) {
        this.pcs.addPropertyChange(QUESTION_LANGUAGE, (Object)this.multiLanguages.length, (Object)length);
    }

    public void setEditedQuestionRating(double markVote) {
        this.pcs.addPropertyChange(QUESTION_RATING, (Object)this.markVote, (Object)markVote);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String name) {
        this.detail = name;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public String[] getRelations() {
        return this.relations;
    }

    public void setRelations(String[] relations) {
        this.relations = relations;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void setApproved(boolean isApproved) {
        this.isApproved = isApproved;
    }

    public boolean isApproved() {
        return this.isApproved;
    }

    public void setCategoryId(String catId) {
        this.categoryId = catId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryPath(String categoryPath) {
        if (categoryPath != null && categoryPath.indexOf(Utils.FAQ_APP) > 0) {
            categoryPath = categoryPath.substring(categoryPath.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1);
        }
        this.categoryPath = categoryPath;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public void setAttachMent(List<FileAttachment> listFile) {
        this.listAttachments = listFile;
    }

    public List<FileAttachment> getAttachMent() {
        return this.listAttachments;
    }

    public String getLanguagesNotYetAnswered() {
        return this.languagesNotYetAnswered;
    }

    public Question setLanguagesNotYetAnswered(String languagesNotYetAnswered) {
        this.languagesNotYetAnswered = languagesNotYetAnswered;
        return this;
    }

    public String[] getNameAttachs() {
        return this.nameAttachs;
    }

    public void setNameAttachs(String[] nameAttachs) {
        this.nameAttachs = nameAttachs;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String[] getUsersVote() {
        return this.usersVote;
    }

    public void setUsersVote(String[] usersVote) {
        this.usersVote = usersVote;
    }

    public double getMarkVote() {
        return this.markVote;
    }

    public void setMarkVote(double markVote) {
        this.markVote = markVote;
    }

    public String[] getUsersWatch() {
        return this.usersWatch;
    }

    public void setUsersWatch(String[] usersWatch) {
        this.usersWatch = usersWatch;
    }

    public String[] getEmailsWatch() {
        return this.emailsWatch;
    }

    public void setEmailsWatch(String[] emailsWatch) {
        this.emailsWatch = emailsWatch;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String title) {
        this.question = title;
    }

    public String getTopicIdDiscuss() {
        return this.topicIdDiscuss;
    }

    public void setTopicIdDiscuss(String topicIdDiscuss) {
        this.topicIdDiscuss = topicIdDiscuss;
    }

    public Answer[] getAnswers() {
        return this.answers;
    }

    public void setAnswers(Answer[] answers) {
        this.answers = answers;
    }

    public Comment[] getComments() {
        return this.comments;
    }

    public void setComments(Comment[] comments) {
        this.comments = comments;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setMultiLanguages(QuestionLanguage[] multiLanguages) {
        this.multiLanguages = multiLanguages;
    }

    public QuestionLanguage[] getMultiLanguages() {
        return this.multiLanguages;
    }

    public String getAuthorOfLastActivity() {
        if (this.authorOfLastActivity == null || this.authorOfLastActivity.length() == 0) {
            return this.author;
        }
        return this.authorOfLastActivity;
    }

    public long getTimeOfLastActivity() {
        if (this.timeOfLastActivity < 0L && this.createdDate != null) {
            return this.createdDate.getTime();
        }
        return this.timeOfLastActivity;
    }

    public void setLastActivity(String info) {
        this.authorOfLastActivity = Utils.getAuthorOfLastActivity(info);
        this.timeOfLastActivity = Utils.getTimeOfLastActivity(info);
    }

    public long getNumberOfPublicAnswers() {
        return this.numberOfPublicAnswers;
    }

    public void setNumberOfPublicAnswers(long numberOfPublicAnswers) {
        this.numberOfPublicAnswers = numberOfPublicAnswers;
    }

    public PropertyChangeEvent[] getChangeEvent() {
        return this.pcs.getChangeEvents();
    }
}

