/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.ext.activity;

import org.exoplatform.answer.ext.activity.ForumActivityBuilder;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ForumActivityUtils {
    private static final int TYPE_PRIVATE = 2;
    private static ForumService forumService;
    private static ActivityManager activityManager;
    private static IdentityManager identityManager;
    private static SpaceService spaceService;

    public static Identity getSpaceIdentity(String forumId) {
        Space space = ForumActivityUtils.getSpaceService().getSpaceByGroupId(ForumActivityUtils.getSpaceGroupId(forumId));
        Identity spaceIdentity = null;
        if (space != null) {
            spaceIdentity = ForumActivityUtils.getIdentityManager().getOrCreateIdentity("space", space.getPrettyName(), false);
        }
        return spaceIdentity;
    }

    public static String getSpaceGroupId(String forumId) {
        String groupId = forumId.replaceFirst(Utils.FORUM_SPACE_ID_PREFIX, "");
        String spaceGroupId = "/spaces/" + groupId;
        return spaceGroupId;
    }

    public static boolean hasSpace(String forumId) {
        return !Utils.isEmpty((String)forumId) && forumId.indexOf(Utils.FORUM_SPACE_ID_PREFIX) >= 0;
    }

    public static boolean isCategoryPublic(Category category) {
        return category != null && Utils.isEmpty((String[])category.getViewer()) && Utils.isEmpty((String[])category.getUserPrivate());
    }

    public static boolean isForumPublic(Forum forum) {
        return forum != null && !forum.getIsClosed() && Utils.isEmpty((String[])forum.getViewer());
    }

    public static boolean isTopicPublic(Topic topic) {
        return topic != null && topic.getIsActive() && topic.getIsApproved() && !topic.getIsWaiting() && !topic.getIsClosed() && Utils.isEmpty((String[])topic.getCanView());
    }

    public static boolean isPostPublic(Post post) {
        return post != null && post.getUserPrivate().length != 2 && !post.getIsWaiting() && !post.getIsHidden() && post.getIsActiveByTopic() && post.getIsApproved();
    }

    public static void takeActivityBack(Topic topic, ExoSocialActivity activity) {
        ForumActivityUtils.getForumService().saveActivityIdForOwnerPath(topic.getPath(), activity.getId());
    }

    public static void takeCommentBack(Post post, ExoSocialActivity comment) {
        ForumActivityUtils.getForumService().saveActivityIdForOwnerPath(post.getPath(), comment.getId());
    }

    public static void removeActivities(String ... activityIds) {
        ActivityManager am = ForumActivityUtils.getActivityManager();
        for (String activityId : activityIds) {
            am.deleteActivity(activityId);
        }
    }

    public static void removeComment(String activityId, String commentId) {
        ActivityManager am = ForumActivityUtils.getActivityManager();
        ExoSocialActivity activity = am.getActivity(activityId);
        if (activity == null) {
            return;
        }
        activity = ForumActivityBuilder.updateNumberOfReplies(activity, true);
        activity.setTitle(null);
        activity.setBody(null);
        am.updateActivity(activity);
        am.deleteComment(activityId, commentId);
    }

    public static void updateActivities(ExoSocialActivity activity) {
        ActivityManager am = ForumActivityUtils.getActivityManager();
        am.updateActivity(activity);
    }

    public static ForumService getForumService() {
        if (forumService == null) {
            forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        }
        return forumService;
    }

    public static ActivityManager getActivityManager() {
        if (activityManager == null) {
            activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        }
        return activityManager;
    }

    public static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return identityManager;
    }

    public static SpaceService getSpaceService() {
        if (spaceService == null) {
            spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return spaceService;
    }

    public static Identity getIdentity(String remoteId) {
        return ForumActivityUtils.getIdentityManager().getOrCreateIdentity("organization", remoteId, false);
    }
}

