/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.ext.impl;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.DataStorage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.JCRDataStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class AnswerDataInitialize
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(AnswerDataInitialize.class);
    private final InitParams params;

    public AnswerDataInitialize(InitParams params) {
        this.params = params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        String portletName = "";
        if (this.params.getValueParam("portletName") != null) {
            portletName = this.params.getValueParam("portletName").getValue();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initparam is not configured for portletName property");
        }
        if (!portletName.equals(event.getSource())) {
            return;
        }
        Space space = event.getSpace();
        DataStorage fServie = (DataStorage)CommonsUtils.getService(JCRDataStorage.class);
        try {
            Category parent = fServie.getCategoryById("categories");
            if (parent != null) {
                Category cat = new Category();
                cat.setId(Utils.CATE_SPACE_ID_PREFIX + space.getPrettyName());
                cat.setName(space.getDisplayName());
                cat.setUserPrivate(new String[]{space.getGroupId()});
                cat.setDescription(space.getDescription());
                cat.setIndex(0L);
                cat.setModerators(new String[]{"manager:" + space.getGroupId()});
                if (fServie.getCategoryById(cat.getId()) == null) {
                    fServie.saveCategory("categories", cat, true, false);
                }
            } else {
                LOG.error((Object)"\n\n Root category null please check to create one !");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("\n\n Initialize category false " + e.getMessage()));
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }
}

