/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.ext.impl;

import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.webui.activity.BaseUIActivity;

public class BaseKSActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(BaseKSActivity.class);

    public String getUriOfAuthor() {
        Identity id = this.getOwnerIdentity();
        if (id != null) {
            String url = id.getProfile().getUrl();
            if (url == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Url of user %s has not set yet", id.getProfile().getId()));
            }
            return "<a href='" + url + "'>" + id.getProfile().getFullName() + "</a>";
        }
        return "";
    }

    public String getUserFullName(String userId) {
        return this.getOwnerIdentity().getProfile().getFullName();
    }

    public String getUserProfileUri(String userId) {
        return this.getOwnerIdentity().getProfile().getUrl();
    }

    public String getUserAvatarImageSource(String userId) {
        return this.getOwnerIdentity().getProfile().getAvatarUrl();
    }

    public String getSpaceAvatarImageSource(String spaceIdentityId) {
        try {
            String spaceId = this.getOwnerIdentity().getRemoteId();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                return space.getAvatarUrl();
            }
        }
        catch (SpaceStorageException e) {
            LOG.warn((Object)String.format("Failed to getSpaceById: %s", spaceIdentityId), (Throwable)e);
        }
        return null;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }
}

