/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ForumActivityBuilder {
    public static final String FORUM_ACTIVITY_TYPE = "ks-forum:spaces";
    public static final String FORUM_ID_KEY = "ForumId";
    public static final String CATE_ID_KEY = "CateId";
    public static final String POST_TYPE = "Post";
    public static final String POST_ID_KEY = "PostId";
    public static final String POST_OWNER_KEY = "PostOwner";
    public static final String POST_LINK_KEY = "PostLink";
    public static final String POST_NAME_KEY = "PostName";
    public static final String TOPIC_ID_KEY = "TopicId";
    public static final String TOPIC_LINK_KEY = "TopicLink";
    public static final String TOPIC_OWNER_KEY = "TopicOwner";
    public static final String TOPIC_POST_COUNT_KEY = "NumberOfReplies";
    public static final String TOPIC_VOTE_RATE_KEY = "TopicVoteRate";
    private static final int NUMBER_CHARS = 430;
    private static final int NUMBER_OF_LINES = 4;
    public static final String SPACE_GROUP_ID = "SpaceGroupId";

    private ForumActivityBuilder() {
    }

    public static String decodeHTMLInput(String message) {
        message = CommonUtils.decodeSpecialCharToHTMLnumber((String)message);
        String[] tab = TransformHTML.getPlainText((String)message).replaceAll("(?m)^\\s*$[\n\r]{1,}", "").split("\\r?\\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tab.length; ++i) {
            sb.append(StringEscapeUtils.unescapeHtml((String)tab[i]));
            sb.append("<br/>");
        }
        return sb.toString();
    }

    public static String getFourFirstLines(String str) {
        return ForumActivityBuilder.getNumberFirstLines(str.replaceAll("&nbsp;", ""), 4);
    }

    public static String getNumberFirstLines(String content, int line) {
        String[] tab = TransformHTML.getPlainText((String)content).replaceAll("(?m)^\\s*$[\n\r]{1,}", "").split("\\r?\\n");
        int numberOfLine = Math.min(4, tab.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfLine; ++i) {
            sb.append(tab[i]);
            if (i >= numberOfLine - 1) continue;
            sb.append("BR_");
        }
        String str = StringEscapeUtils.unescapeHtml((String)TransformHTML.cleanHtmlCode((String)sb.toString(), null)).trim();
        return ForumActivityBuilder.trunc(str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("BR_", "<br/>"), 430, tab.length > 4);
    }

    public static final String trunc(String str, int head, boolean needTail) {
        StringBuffer buf = null;
        buf = new StringBuffer();
        if (str.length() <= head + 7 + str.length() / 10) {
            buf.append(str);
            if (needTail) {
                buf.append("...");
            }
            return buf.toString();
        }
        buf.append(str.substring(0, head)).append("...");
        return buf.toString();
    }

    public static ExoSocialActivity updateNumberOfReplies(Topic topic, ExoSocialActivity activity) {
        Map templateParams = activity.getTemplateParams();
        templateParams.put(TOPIC_POST_COUNT_KEY, "" + topic.getPostCount());
        return activity;
    }

    public static ExoSocialActivity updateNumberOfReplies(ExoSocialActivity activity, boolean isDelete) {
        Map templateParams = activity.getTemplateParams();
        int nbReplies = Integer.parseInt((String)templateParams.get(TOPIC_POST_COUNT_KEY));
        if (isDelete) {
            templateParams.put(TOPIC_POST_COUNT_KEY, "" + (nbReplies - 1));
        } else {
            templateParams.put(TOPIC_POST_COUNT_KEY, "" + (nbReplies + 1));
        }
        activity.setTemplateParams(templateParams);
        return activity;
    }

    public static ExoSocialActivity updateVoteRate(Topic topic, ExoSocialActivity activity) {
        Map templateParams = activity.getTemplateParams();
        templateParams.put(TOPIC_VOTE_RATE_KEY, "" + topic.getVoteRating());
        return activity;
    }
}

