/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.rendering;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.common.webui.BuildRendering;
import org.exoplatform.forum.rendering.MarkupRenderingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RenderHelper {
    protected static final Log LOG = ExoLogger.getLogger(RenderHelper.class);
    private MarkupRenderingService markupRenderingService;
    private static final BuildRendering.AbstractRenderDelegate<Answer> ANSWER_DELEGATE = new /* Unavailable Anonymous Inner Class!! */;
    private static final BuildRendering.AbstractRenderDelegate<Comment> COMMENT_DELEGATE = new /* Unavailable Anonymous Inner Class!! */;
    private static final BuildRendering.AbstractRenderDelegate<Question> QUESTION_DELEGATE = new /* Unavailable Anonymous Inner Class!! */;

    public String renderAnswer(Answer answer) {
        return this.delegateRendering(ANSWER_DELEGATE, (Object)answer);
    }

    public String renderComment(Comment comment) {
        return this.delegateRendering(COMMENT_DELEGATE, (Object)comment);
    }

    public String renderQuestion(Question question) {
        return this.delegateRendering(QUESTION_DELEGATE, (Object)question);
    }

    private <T> String delegateRendering(BuildRendering.AbstractRenderDelegate<T> delegate, T target) {
        try {
            return this.getMarkupRenderingService().delegateRendering(delegate, target);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to render " + target.getClass().getSimpleName()));
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return delegate.getMessage(target);
        }
    }

    public MarkupRenderingService getMarkupRenderingService() {
        if (this.markupRenderingService == null) {
            this.markupRenderingService = (MarkupRenderingService)CommonsUtils.getService(MarkupRenderingService.class);
        }
        return this.markupRenderingService;
    }

    public void setMarkupRenderingService(MarkupRenderingService service) {
        this.markupRenderingService = service;
    }
}

