/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.popup.BaseCategoryTreeInputForm;
import org.exoplatform.answer.webui.popup.UIFAQSettingForm;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIFAQSettingForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectTabActionListener.class})})
public class UIFAQSettingForm
extends BaseCategoryTreeInputForm
implements UIPopupComponent {
    public static final String EDIT_TEMPLATE_TAB = "EditTemplateTab";
    public static final String PREFERENCE_TAB = "PreferenceTab";
    public static final String FIELD_TEMPLATE_TEXTARE = "ContentTemplate";
    public static final String FIELD_USEAJAX_CHECKBOX = "UseAjax";
    private FAQSetting faqSetting_;
    private boolean useAjax = false;
    private int id_ = 0;
    protected String homeCategoryName = "";

    public UIFAQSettingForm() throws Exception {
        UIFormInputWithActions editTemplateTab = new UIFormInputWithActions(EDIT_TEMPLATE_TAB);
        UIFormInputWithActions preferenceTab = new UIFormInputWithActions(PREFERENCE_TAB);
        UIFormTextAreaInput textAreaInput = new UIFormTextAreaInput(FIELD_TEMPLATE_TEXTARE, FIELD_TEMPLATE_TEXTARE, null);
        editTemplateTab.addUIFormInput((UIFormInput)textAreaInput);
        UICheckBoxInput useAjaxCheckBox = new UICheckBoxInput(FIELD_USEAJAX_CHECKBOX, FIELD_USEAJAX_CHECKBOX, Boolean.valueOf(false));
        preferenceTab.addChild((UIComponent)useAjaxCheckBox);
        this.addUIFormInput((UIFormInputSet)editTemplateTab);
        this.addUIFormInput((UIFormInputSet)preferenceTab);
        this.homeCategoryName = this.getFAQService().getCategoryNameOf("categories");
    }

    protected boolean getIsSelected(int id) {
        return this.id_ == id;
    }

    public void defaulValue() throws Exception {
        this.categoriesChecked = FAQUtils.getCategoriesIdFAQPortlet();
        this.useAjax = FAQUtils.getUseAjaxFAQPortlet();
    }

    private void setTemplateEdit() throws Exception {
        byte[] data = this.getFAQService().getTemplate();
        String template = new String(data);
        if (FAQUtils.isFieldEmpty((String)template)) {
            // empty if block
        }
        UIFormInputWithActions withActions = (UIFormInputWithActions)this.getChildById(EDIT_TEMPLATE_TAB);
        withActions.getUIFormTextAreaInput(FIELD_TEMPLATE_TEXTARE).setValue((Object)template);
    }

    public void initSettingForm() throws Exception {
        UIFormInputWithActions withActions = (UIFormInputWithActions)this.getChildById(PREFERENCE_TAB);
        withActions.getUICheckBoxInput(FIELD_USEAJAX_CHECKBOX).setChecked(this.useAjax);
        this.categoryTree = FAQUtils.getFAQService().buildCategoryTree(null);
        this.categoryMap.clear();
        this.categoryStatus.clear();
        this.setTemplateEdit();
        this.faqSetting_ = new FAQSetting();
        String orderType = this.faqSetting_.getOrderType();
        if (orderType == null || orderType.equals("asc")) {
            this.faqSetting_.setOrderType("desc");
        } else {
            this.faqSetting_.setOrderType("asc");
        }
    }

    public void activate() {
    }

    public void deActivate() {
    }

    private void savePortletPreference() throws Exception {
        UIFormInputWithActions scopingTab = (UIFormInputWithActions)this.getChildById("CategoryScoping");
        HashSet<String> listCateIds = new HashSet<String>();
        List childrens = scopingTab.getChildren();
        for (UIComponent child : childrens) {
            if (!(child instanceof UICheckBoxInput) || !((UICheckBoxInput)child).isChecked()) continue;
            listCateIds.add(child.getId());
        }
        this.categoriesChecked = this.categoryMap.size() == listCateIds.size() ? Collections.emptyList() : new ArrayList(listCateIds);
        UIFormInputWithActions withActions = (UIFormInputWithActions)this.getChildById(PREFERENCE_TAB);
        UICheckBoxInput useAjaxCheckBox = withActions.getUICheckBoxInput(FIELD_USEAJAX_CHECKBOX);
        this.useAjax = useAjaxCheckBox.isChecked();
        FAQUtils.saveFAQPortletPreference((List)this.categoriesChecked, (boolean)this.useAjax);
    }

    static /* synthetic */ int access$000(UIFAQSettingForm x0) {
        return x0.id_;
    }

    static /* synthetic */ void access$100(UIFAQSettingForm x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ FAQService access$200(UIFAQSettingForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ void access$300(UIFAQSettingForm x0, String x1, boolean x2) {
        x0.info(x1, x2);
    }

    static /* synthetic */ void access$400(UIFAQSettingForm x0) throws Exception {
        x0.setTemplateEdit();
    }

    static /* synthetic */ void access$500(UIFAQSettingForm x0) throws Exception {
        x0.savePortletPreference();
    }

    static /* synthetic */ void access$600(UIFAQSettingForm x0, String x1, boolean x2) {
        x0.info(x1, x2);
    }

    static /* synthetic */ int access$002(UIFAQSettingForm x0, int x1) {
        x0.id_ = x1;
        return x0.id_;
    }
}

