/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.exoplatform.answer.rendering.RenderHelper;
import org.exoplatform.answer.rendering.RenderingException;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.UIAnswersContainer;
import org.exoplatform.answer.webui.UIAnswersPageIterator;
import org.exoplatform.answer.webui.UIAnswersPortlet;
import org.exoplatform.answer.webui.UIQuestions;
import org.exoplatform.answer.webui.popup.UIResponseForm;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.UIPopupAction;
import org.exoplatform.forum.common.webui.UIPopupContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@ComponentConfig(template="app:/templates/answer/webui/UIQuestions.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={ChangeStatusAnswerActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={SettingActionListener.class}), @EventConfig(listeners={QuestionManagamentActionListener.class}), @EventConfig(listeners={ViewQuestionActionListener.class}), @EventConfig(listeners={OpenQuestionActionListener.class}), @EventConfig(listeners={CloseQuestionActionListener.class}), @EventConfig(listeners={ViewUserProfileActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class}), @EventConfig(listeners={EditAnswerActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={MoveQuestionActionListener.class}), @EventConfig(listeners={SendQuestionActionListener.class}), @EventConfig(listeners={CommentQuestionActionListener.class}), @EventConfig(listeners={DeleteCommentActionListener.class}, confirm="UIQuestions.msg.confirm-delete-comment"), @EventConfig(listeners={DeleteAnswerActionListener.class}, confirm="UIQuestions.msg.confirm-delete-answer"), @EventConfig(listeners={UnVoteQuestionActionListener.class}, confirm="UIQuestions.msg.confirm-unvote-question"), @EventConfig(listeners={CommentToAnswerActionListener.class}), @EventConfig(listeners={VoteQuestionActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={SortAnswerActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={VoteAnswerActionListener.class}), @EventConfig(listeners={PrintAllQuestionActionListener.class}), @EventConfig(listeners={DiscussForumActionListener.class})})
public class UIQuestions
extends UIContainer {
    private static Log log = ExoLogger.getLogger(UIQuestions.class);
    protected static String SEARCH_INPUT = "SearchInput";
    protected static String COMMENT_ITER = "CommentIter";
    protected static String ANSWER_ITER = "AnswerIter";
    public static final String OBJECT_ITERATOR = "object_iter";
    public static final String OBJECT_BACK = "/back";
    public static final String OBJECT_LANGUAGE = "/language=";
    public static final String OBJECT_RELATION = "/relation=";
    public FAQSetting faqSetting_ = null;
    private Map<String, Question> questionMap_ = new LinkedHashMap();
    public JCRPageList pageList;
    private boolean canEditQuestion = false;
    public Boolean isSortAnswerUp = null;
    public String categoryId_ = "categories";
    public String viewingQuestionId_ = "";
    private String currentUser_ = "";
    private FAQService faqService_ = null;
    private Map<String, QuestionLanguage> languageMap = new HashMap();
    public boolean isChangeLanguage = false;
    public List<String> listLanguage = new ArrayList();
    public String backPath_ = null;
    public String language_ = FAQUtils.getDefaultLanguage();
    protected String discussId = "";
    private String[] firstTollbar_ = new String[]{"AddNewQuestion", "QuestionManagament"};
    private String[] menuCateManager = new String[]{"EditCategory", "AddCategory", "DeleteCategory", "Export", "Import"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] moderatorActionQues_ = new String[]{"CommentQuestion", "ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private Map<String, String> iconActionQuesion = new HashMap();
    private String[] moderatorActionQues2_ = new String[]{"ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] userActionQues_ = new String[]{"CommentQuestion", "ResponseQuestion", "SendQuestion"};
    private String[] userActionQues2_ = new String[]{"SendQuestion"};
    private String[] userActionQues3_ = new String[]{"ResponseQuestion", "SendQuestion"};
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    private boolean isViewRootCate = true;
    public boolean viewAuthorInfor = false;
    private RenderHelper renderHelper = new RenderHelper();
    public UIAnswersPageIterator pageIterator = null;
    public long pageSelect = 0L;

    public UIQuestions() throws Exception {
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.addChild(UIAnswersPageIterator.class, null, OBJECT_ITERATOR);
        if (this.faqService_ == null) {
            this.faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        }
        if (FAQUtils.isFieldEmpty((String)this.getId())) {
            this.setId("UIQuestions");
        }
        String[] icons = new String[]{"uiIconComment", "uiIconAnsAnswer", "uiIconEdit", "uiIconTrash", "uiIconMove", "uiIconAnsSentMail"};
        this.iconActionQuesion.clear();
        for (int i = 0; i < this.moderatorActionQues_.length; ++i) {
            this.iconActionQuesion.put(this.moderatorActionQues_[i], icons[i]);
        }
    }

    protected boolean isNotInSpace() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue("SPACE_URL", null) == null;
    }

    private boolean isCategoryHome() {
        return this.categoryId_ == null || this.categoryId_.equals("categories");
    }

    public boolean isViewRootCate() {
        return this.isViewRootCate;
    }

    public void setViewRootCate() {
        boolean b = ((UIAnswersContainer)this.getParent()).isRenderCategory(this.categoryId_);
        if (b != this.isViewRootCate) {
            this.isViewRootCate = b;
        }
        this.setListObject();
    }

    protected boolean isAddQuestion() {
        if (this.isViewRootCate && (this.currentUser_ != null || this.currentUser_ == null && this.faqSetting_.isEnableAnonymousSubmitQuestion())) {
            return !this.isCategoryHome() || this.faqSetting_.isPostQuestionInRootCategory();
        }
        return false;
    }

    protected String getCSSByFileType(String fileName, String fileType) {
        return CssClassUtils.getCSSClassByFileNameAndFileType((String)fileName, (String)fileType, null);
    }

    public String getRSSLink() {
        String catepath = this.categoryId_.substring(this.categoryId_.lastIndexOf("/") + 1);
        return CommonUtils.getRSSLink((String)"faq", (String)this.getPortalName(), (String)catepath);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getImageUrl(String imagePath) throws Exception {
        String url = "";
        try {
            url = CommonUtils.getImageUrl((String)imagePath);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get url of image.", (Throwable)e);
        }
        return url;
    }

    protected boolean isDiscussForum() throws Exception {
        return this.faqSetting_.getIsDiscussForum();
    }

    public void setListObject() {
        try {
            String objectId = null;
            if (this.pageList != null) {
                objectId = this.pageList.getObjectId();
            }
            if (this.isViewRootCate) {
                this.pageList = this.faqService_.getQuestionsByCatetory(this.categoryId_, this.faqSetting_);
                this.pageList.setPageSize(10L);
                if (objectId != null && objectId.trim().length() > 0) {
                    this.pageList.setObjectId(objectId);
                }
                this.pageIterator = (UIAnswersPageIterator)this.getChildById(OBJECT_ITERATOR);
                this.pageIterator.updatePageList(this.pageList);
            } else {
                this.pageList = null;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get list question in category.", (Throwable)e);
        }
    }

    protected Answer[] getPageListAnswer(String questionId) throws Exception {
        if (this.isSortAnswerUp == null) {
            return ((QuestionLanguage)this.languageMap.get(this.language_)).getAnswers();
        }
        Answer[] answers = ((QuestionLanguage)this.languageMap.get(this.language_)).getAnswers();
        if (this.isSortAnswerUp.booleanValue()) {
            Arrays.sort(answers, new FAQUtils.VoteComparator(true));
        } else {
            Arrays.sort(answers, new FAQUtils.VoteComparator(false));
        }
        return answers;
    }

    protected Comment[] getPageListComment(String questionId) throws Exception {
        return ((QuestionLanguage)this.languageMap.get(this.language_)).getComments();
    }

    protected String[] getActionTollbar() {
        return this.firstTollbar_;
    }

    protected String[] getMenuCateManager() {
        return this.menuCateManager;
    }

    public FAQSetting getFAQSetting() {
        if (this.faqSetting_ == null) {
            this.faqSetting_ = new FAQSetting();
            FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        }
        return this.faqSetting_;
    }

    protected String[] getActionCategoryWithUser() {
        if (this.currentUser_ != null) {
            return this.userActionsCate_;
        }
        if (this.faqSetting_.isEnableAutomaticRSS()) {
            return new String[]{this.userActionsCate_[0], "RSSFAQ"};
        }
        return new String[]{this.userActionsCate_[0]};
    }

    protected String[] getActionQuestion() {
        return this.canEditQuestion ? (this.faqSetting_.isEnanbleVotesAndComments() ? this.moderatorActionQues_ : this.moderatorActionQues2_) : (FAQUtils.isFieldEmpty((String)this.currentUser_) ? this.userActionQues2_ : (this.faqSetting_.isEnanbleVotesAndComments() ? this.userActionQues_ : this.userActionQues3_));
    }

    protected String getIconActionQuestion(String action) {
        return (String)this.iconActionQuesion.get(action);
    }

    public void updateCurrentQuestionList() throws Exception {
        this.questionMap_.clear();
        if (this.pageList != null) {
            this.pageSelect = this.pageIterator.getPageSelected();
            for (Question question : this.pageList.getPage(this.pageSelect, null)) {
                this.questionMap_.put(question.getId(), question);
            }
            this.pageSelect = this.pageList.getCurrentPage();
            this.pageIterator.setSelectPage(this.pageSelect);
        }
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
    }

    public void setFAQService(FAQService service) {
        this.faqService_ = service;
    }

    public void setLanguageView(String language) {
        this.language_ = language;
    }

    protected String getQuestionContent() {
        if (this.languageMap.containsKey(this.language_)) {
            return ((QuestionLanguage)this.languageMap.get(this.language_)).getQuestion();
        }
        return "";
    }

    protected Question getQuestionDetail() {
        Question question = new Question();
        if (this.languageMap.containsKey(this.language_)) {
            question.setDetail(((QuestionLanguage)this.languageMap.get(this.language_)).getDetail());
        }
        return question;
    }

    protected void setIsModerators() throws Exception {
        this.canEditQuestion = this.isModerators(this.categoryId_);
    }

    private boolean isModerators(String categoryId) throws Exception {
        return this.getFAQSetting().isAdmin() || this.faqService_.isCategoryModerator(categoryId, null);
    }

    public String getVoteScore(Question question) {
        double vote = question.getMarkVote();
        vote = vote < 0.0 ? 0.0 : vote;
        DecimalFormat df = new DecimalFormat("0");
        return df.format(vote);
    }

    protected boolean canVote(Question question) {
        if (question.getUsersVote() != null) {
            for (String user : question.getUsersVote()) {
                if (!user.contains(this.currentUser_ + "/")) continue;
                return false;
            }
        }
        return true;
    }

    public void setDefaultLanguage() {
        String language = FAQUtils.getDefaultLanguage();
        if (this.languageMap.containsKey(language) || FAQUtils.isFieldEmpty((String)this.language_)) {
            this.language_ = language;
        }
    }

    protected String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        result = residual > 500L ? size + 1L + " " + this.sizes_[i] : size + " " + this.sizes_[i];
        return result;
    }

    protected Question[] getListQuestion() {
        try {
            this.updateCurrentQuestionList();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to update current question list.", (Throwable)e);
        }
        return this.questionMap_.values().toArray(new Question[0]);
    }

    protected boolean getCanEditQuestion() {
        return this.canEditQuestion;
    }

    protected String getQuestionView() {
        return this.viewingQuestionId_;
    }

    protected Map<String, String> getQuestionLanguages() {
        return FAQUtils.getQuestionLanguages(this.languageMap.keySet());
    }

    protected String getAvatarUrl(String userId) {
        return FAQUtils.getUserAvatar((String)userId);
    }

    public String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) {
        this.viewAuthorInfor = this.faqService_.isViewAuthorInfo(categoryId);
        this.categoryId_ = categoryId;
        this.setViewRootCate();
    }

    public void viewQuestion(Question question) throws Exception {
        if (!this.questionMap_.containsKey(question.getLanguage())) {
            List languages = this.faqService_.getQuestionLanguages(question.getPath());
            this.languageMap.clear();
            for (QuestionLanguage lang : languages) {
                this.languageMap.put(lang.getLanguage(), lang);
            }
            if (!this.questionMap_.containsKey(question.getId())) {
                this.questionMap_.put(question.getLanguage(), question);
            }
            this.viewingQuestionId_ = question.getPath();
        }
    }

    public void updateCurrentLanguage() {
        if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
            try {
                this.languageMap.put(this.language_, this.faqService_.getQuestionLanguageByLanguage(this.viewingQuestionId_, this.language_));
            }
            catch (Exception e) {
                log.debug((Object)"Failed to update current language ", (Throwable)e);
            }
        } else {
            this.languageMap.clear();
        }
    }

    public void updateQuestionLanguageByLanguage(String questionPath, String language) throws Exception {
        try {
            this.languageMap.put(language, this.faqService_.getQuestionLanguageByLanguage(questionPath, language));
        }
        catch (Exception e) {
            log.debug((Object)"Failed to update map language by viewing question", (Throwable)e);
        }
    }

    public void updateLanguageMap() throws Exception {
        try {
            if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
                List languages = this.faqService_.getQuestionLanguages(this.viewingQuestionId_);
                this.languageMap.clear();
                for (QuestionLanguage lang : languages) {
                    this.languageMap.put(lang.getLanguage(), lang);
                }
            }
        }
        catch (Exception e) {
            this.viewingQuestionId_ = "";
            log.debug((Object)"Failed to update map language by viewing question", (Throwable)e);
        }
    }

    protected Map<String, String> getQuestionRelation(List<String> questionIdLst) {
        LinkedHashMap<String, String> mapReturn = new LinkedHashMap();
        try {
            mapReturn = this.faqService_.getRelationQuestion(questionIdLst);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get question relation", (Throwable)e);
        }
        return mapReturn;
    }

    protected String getBackPath() {
        return this.backPath_;
    }

    public String render(Object obj) throws RenderingException {
        if (obj instanceof Question) {
            return this.renderHelper.renderQuestion((Question)obj);
        }
        if (obj instanceof Answer) {
            return this.renderHelper.renderAnswer((Answer)obj);
        }
        if (obj instanceof Comment) {
            return this.renderHelper.renderComment((Comment)obj);
        }
        return "";
    }

    protected String calculateTimeMessageOfLastActivity(long time) {
        Calendar calendar = CommonUtils.getGreenwichMeanTime();
        calendar.setTimeInMillis(time);
        return TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)"EEE, MMM dd, yyyy", (int)TimeConvertUtils.MONTH);
    }

    public boolean checkQuestionToView(Question question, WebuiRequestContext context) throws Exception {
        if (question != null && question.isActivated() && question.isApproved() || this.isModerators(question.getCategoryPath())) {
            return true;
        }
        context.getUIApplication().addMessage(new ApplicationMessage("UIQuestions.msg.question-pending", null, 1));
        context.addUIComponentToUpdateByAjax(this.getAncestorOfType(UIAnswersContainer.class));
        return false;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public FAQService getFAQService() {
        return this.faqService_;
    }

    public String getLanguage() {
        return this.language_;
    }

    public void processResponseQuestionAction(WebuiRequestContext context, String questionId) throws Exception {
        boolean isAnswerApproved = false;
        try {
            Question question = this.faqService_.getQuestionById(questionId);
            isAnswerApproved = !this.faqService_.isModerateAnswer(questionId);
            UIAnswersPortlet portlet = (UIAnswersPortlet)this.getAncestorOfType(UIAnswersPortlet.class);
            UIPopupAction popupAction = (UIPopupAction)portlet.getChild(UIPopupAction.class);
            UIPopupContainer popupContainer = (UIPopupContainer)popupAction.createUIComponent(UIPopupContainer.class, null, null);
            UIResponseForm responseForm = (UIResponseForm)popupContainer.addChild(UIResponseForm.class, null, null);
            responseForm.setModertator(this.canEditQuestion);
            if (questionId.equals(this.viewingQuestionId_)) {
                responseForm.setQuestionId(question, this.language_, isAnswerApproved);
            } else {
                responseForm.setQuestionId(question, "", isAnswerApproved);
            }
            responseForm.setFAQSetting(this.faqSetting_);
            popupContainer.setId("FAQResponseQuestion");
            popupAction.activate((UIComponent)popupContainer, 900, 500);
            context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        catch (Exception e) {
            this.updateCurrentQuestionList();
            this.showMessageDeletedQuestion(context);
        }
    }

    private boolean checkExistingQuestion(WebuiRequestContext context, String questionId) throws Exception {
        if (!this.getFAQService().isExisting(questionId)) {
            this.showMessageDeletedQuestion(context);
            return false;
        }
        return true;
    }

    public void showMessageDeletedQuestion(WebuiRequestContext context) throws Exception {
        UIAnswersPortlet portlet = (UIAnswersPortlet)this.getAncestorOfType(UIAnswersPortlet.class);
        context.getUIApplication().addMessage(new ApplicationMessage("UIQuestions.msg.question-id-deleted", null, 1));
        context.addUIComponentToUpdateByAjax((UIComponent)portlet);
    }

    static /* synthetic */ FAQService access$000(UIQuestions x0) {
        return x0.faqService_;
    }

    static /* synthetic */ boolean access$100(UIQuestions x0) {
        return x0.canEditQuestion;
    }

    static /* synthetic */ Log access$200() {
        return log;
    }

    static /* synthetic */ Map access$300(UIQuestions x0) {
        return x0.questionMap_;
    }

    static /* synthetic */ boolean access$400(UIQuestions x0, WebuiRequestContext x1, String x2) throws Exception {
        return x0.checkExistingQuestion(x1, x2);
    }

    static /* synthetic */ Map access$500(UIQuestions x0) {
        return x0.languageMap;
    }
}

