/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.dao;

import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface FavoriteApplicationDAO
extends JpaRepository<FavoriteApplicationEntity, Long> {
    @Query(value="SELECT favoriteApp FROM FavoriteApplicationEntity favoriteApp\nWHERE favoriteApp.userName = ?1\nORDER BY favoriteApp.order NULLS LAST\n")
    public List<FavoriteApplicationEntity> getFavoriteAppsByUser(String var1);

    @Query(value="SELECT distinct(favoriteApp) FROM FavoriteApplicationEntity favoriteApp\nWHERE favoriteApp.application.id = ?1\nAND favoriteApp.userName = ?2\n")
    public FavoriteApplicationEntity getFavoriteAppByUserNameAndAppId(Long var1, String var2);

    @Query(value="SELECT count(*) FROM FavoriteApplicationEntity favoriteApp\nWHERE favoriteApp.userName = ?1\n")
    public long countFavoritesForUser(String var1);

    @Transactional
    @Modifying(clearAutomatically=true, flushAutomatically=true)
    @Query(value="DELETE FROM FavoriteApplicationEntity favoriteApp\nWHERE favoriteApp.application.id = ?1\n")
    public void removeAllFavoritesOfApplication(Long var1);
}

