/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.util.Base64;
import org.exoplatform.appcenter.dto.Application;
import org.exoplatform.appcenter.dto.ApplicationImage;
import org.exoplatform.appcenter.dto.ApplicationList;
import org.exoplatform.appcenter.dto.ApplicationOrder;
import org.exoplatform.appcenter.dto.GeneralSettings;
import org.exoplatform.appcenter.dto.UserApplication;
import org.exoplatform.appcenter.plugin.ApplicationPlugin;
import org.exoplatform.appcenter.service.ApplicationAlreadyExistsException;
import org.exoplatform.appcenter.service.ApplicationNotFoundException;
import org.exoplatform.appcenter.storage.ApplicationCenterStorage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.picocontainer.Startable;

public class ApplicationCenterService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(ApplicationCenterService.class);
    public static final String DEFAULT_ADMINISTRATORS_GROUP = "/platform/administrators";
    public static final String DEFAULT_ADMINISTRATORS_PERMISSION = "*:/platform/administrators";
    public static final String ANY_PERMISSION = "any";
    public static final String DEFAULT_USERS_GROUP = "/platform/users";
    public static final String DEFAULT_USERS_PERMISSION = "*:/platform/users";
    public static final String MAX_FAVORITE_APPS = "maxFavoriteApps";
    public static final String DEFAULT_APP_IMAGE_ID = "defaultAppImageId";
    public static final String DEFAULT_APP_IMAGE_NAME = "defaultAppImageName";
    public static final String DEFAULT_APP_IMAGE_BODY = "defaultAppImageBody";
    public static final int DEFAULT_LIMIT = 10;
    private static final Context APP_CENTER_CONTEXT = Context.GLOBAL.id("APP_CENTER");
    private static final Scope APP_CENTER_SCOPE = Scope.APPLICATION.id("APP_CENTER");
    private PortalContainer container;
    private ConfigurationManager configurationManager;
    private SettingService settingService;
    private Authenticator authenticator;
    private IdentityRegistry identityRegistry;
    private ApplicationCenterStorage appCenterStorage;
    private String defaultAdministratorPermission = null;
    private long maxFavoriteApps = -1L;
    private long defaultMaxFavoriteApps = 0L;
    private Map<String, ApplicationPlugin> defaultApplications = new LinkedHashMap<String, ApplicationPlugin>();
    public static String LOG_SERVICE_NAME = "application-center";
    public static String LOG_OPEN_FAVORITE_DRAWER = "open-favorite-drawer";
    public static String LOG_CLICK_ALL_APPLICATIONS = "click-all-applications";
    public static final String LOG_OPEN_APPLICATION = "open-application";
    public static final String LOG_REORGANIZE_FAVORITES = "reorganize-favorites";
    public static final String LOG_ADD_FAVORITE = "add-favorite";
    public static final String LOG_REMOVE_FAVORITE = "remove-favorite";

    public ApplicationCenterService(ConfigurationManager configurationManager, ApplicationCenterStorage appCenterStorage, SettingService settingService, IdentityRegistry identityRegistry, Authenticator authenticator, PortalContainer container, InitParams params) {
        this.container = container;
        this.configurationManager = configurationManager;
        this.settingService = settingService;
        this.authenticator = authenticator;
        this.identityRegistry = identityRegistry;
        this.appCenterStorage = appCenterStorage;
        if (params != null && params.containsKey((Object)"default.administrators.expression")) {
            this.defaultAdministratorPermission = params.getValueParam("default.administrators.expression").getValue();
        }
        if (params != null && params.containsKey((Object)"default.favorites")) {
            this.defaultMaxFavoriteApps = Long.parseLong(params.getValueParam("default.favorites").getValue());
        }
        if (StringUtils.isBlank((String)this.defaultAdministratorPermission)) {
            this.defaultAdministratorPermission = DEFAULT_ADMINISTRATORS_PERMISSION;
        }
    }

    public void start() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            List<Application> systemApplications = this.appCenterStorage.getSystemApplications();
            systemApplications.forEach(application -> {
                if (!this.isDefaultSystemApplication((Application)application)) {
                    try {
                        LOG.info("Delete application '{}' that was previously injected as system application and that doesn't exist in configuration anymore", new Object[]{application.getTitle()});
                        this.appCenterStorage.deleteApplication(application.getId());
                    }
                    catch (Exception e) {
                        LOG.warn("An unknown error occurs while deleting not found system application '{}' in store", new Object[]{application.getTitle(), e});
                    }
                }
            });
            this.defaultApplications.values().forEach(applicationPlugin -> {
                String imagePath;
                Application application = applicationPlugin.getApplication();
                String pluginName = applicationPlugin.getName();
                if (application == null) {
                    LOG.warn("An application plugin '{}' holds an empty application", new Object[]{pluginName});
                    return;
                }
                String title = application.getTitle();
                if (StringUtils.isBlank((String)title)) {
                    LOG.warn("Plugin '{}' has an application with empty title, it will not be injected", new Object[]{pluginName});
                    return;
                }
                String url = application.getUrl();
                if (StringUtils.isBlank((String)url)) {
                    LOG.warn("Plugin '{}' has an application with empty url, it will not be injected", new Object[]{pluginName});
                    return;
                }
                Application storedApplication = null;
                try {
                    storedApplication = this.appCenterStorage.getApplicationByTitle(title);
                }
                catch (FileStorageException e) {
                    LOG.warn("An unknown error occurs while retrieving not found application '{}' in store", new Object[]{application.getTitle(), e});
                }
                if (storedApplication != null && !applicationPlugin.isOverride()) {
                    LOG.info("Ignore updating system application '{}', override flag is turned off", new Object[]{application.getTitle()});
                    return;
                }
                List<String> permissions = application.getPermissions();
                if (permissions == null || permissions.isEmpty()) {
                    application.setPermissions(DEFAULT_USERS_PERMISSION);
                }
                if (StringUtils.isNotBlank((String)(imagePath = applicationPlugin.getImagePath()))) {
                    try {
                        InputStream inputStream = this.configurationManager.getInputStream(imagePath);
                        String fileBody = new String(Base64.encode((byte[])IOUtils.toByteArray((InputStream)inputStream)));
                        application.setImageFileBody(fileBody);
                    }
                    catch (Exception e) {
                        LOG.warn("Error reading image from file {}. Application will be injected without image", new Object[]{imagePath, e});
                    }
                }
                if (StringUtils.isBlank((String)application.getImageFileName())) {
                    application.setImageFileName(application.getTitle() + ".png");
                }
                if (storedApplication == null) {
                    try {
                        LOG.info("Create system application '{}'", new Object[]{application.getTitle()});
                        application.setSystem(true);
                        application.setImageFileId(null);
                        this.createApplication(application);
                    }
                    catch (Exception e) {
                        LOG.error("Error creating application {}", new Object[]{application, e});
                    }
                } else {
                    try {
                        LOG.info("Update system application '{}'", new Object[]{application.getTitle()});
                        application.setSystem(true);
                        application.setId(storedApplication.getId());
                        application.setImageFileId(storedApplication.getImageFileId());
                        this.appCenterStorage.updateApplication(application);
                    }
                    catch (Exception e) {
                        LOG.error("Error updating application {}", new Object[]{application, e});
                    }
                }
            });
        }
        catch (FileStorageException e) {
            LOG.warn((Object)"An unknown error occurs while retrieving system applications images", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public Application createApplication(Application application) throws Exception {
        if (application == null) {
            throw new IllegalArgumentException("application is mandatory");
        }
        Application existingApplication = this.appCenterStorage.getApplicationByTitle(application.getTitle());
        if (existingApplication != null) {
            throw new ApplicationAlreadyExistsException("An application with same title already exists");
        }
        if (application.getPermissions() == null || application.getPermissions().isEmpty()) {
            application.setPermissions(DEFAULT_USERS_PERMISSION);
        }
        return this.appCenterStorage.createApplication(application);
    }

    public Application findApplication(long applicationId) throws Exception {
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " wasn't found");
        }
        return application;
    }

    public Application updateApplication(Application application, String username) throws Exception {
        if (application == null) {
            throw new IllegalArgumentException("application is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long applicationId = application.getId();
        if (applicationId == null) {
            throw new ApplicationNotFoundException("Application with null id wasn't found");
        }
        Application storedApplication = this.appCenterStorage.getApplicationById(applicationId);
        if (storedApplication == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " wasn't found");
        }
        if (!this.isAdmin(username)) {
            throw new IllegalAccessException("User " + username + " is not allowed to modify application : " + storedApplication.getTitle());
        }
        if (application.getPermissions() == null || application.getPermissions().isEmpty()) {
            application.setPermissions(DEFAULT_USERS_PERMISSION);
        }
        return this.appCenterStorage.updateApplication(application);
    }

    private boolean isAdmin(String username) {
        Identity identity = this.identityRegistry.getIdentity(username);
        if (identity == null) {
            try {
                identity = this.authenticator.createIdentity(username);
            }
            catch (Exception e) {
                LOG.warn("Error getting memberships of user {}", new Object[]{username, e});
                return false;
            }
            if (identity == null) {
                return false;
            }
        }
        MembershipEntry membership = null;
        String[] permissionExpressionParts = DEFAULT_ADMINISTRATORS_PERMISSION.split(":");
        membership = new MembershipEntry(permissionExpressionParts[1], permissionExpressionParts[0]);
        return identity.isMemberOf(membership);
    }

    public void deleteApplication(Long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException, FileStorageException {
        if (applicationId == null || applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Application storedApplication = this.appCenterStorage.getApplicationById(applicationId);
        if (storedApplication == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " not found");
        }
        if (storedApplication.isSystem()) {
            throw new IllegalAccessException("Application with id " + applicationId + " is a system application, thus it can't be deleted");
        }
        if (!this.isAdmin(username)) {
            throw new IllegalAccessException("User " + username + " is not allowed to modify application : " + storedApplication.getTitle());
        }
        this.appCenterStorage.deleteApplication(applicationId);
    }

    public void addFavoriteApplication(long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException, FileStorageException {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        if (applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " wasn't found in store");
        }
        if (!this.hasPermission(username, application)) {
            throw new IllegalAccessException("User " + username + " doesn't have enough permissions to delete application " + application.getTitle());
        }
        this.appCenterStorage.addApplicationToUserFavorite(applicationId, username);
    }

    public void deleteFavoriteApplication(Long applicationId, String username) {
        if (applicationId == null || applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        this.appCenterStorage.deleteApplicationFavorite(applicationId, username);
    }

    public void setMaxFavoriteApps(long maxFavoriteApplications) {
        if (maxFavoriteApplications >= 0L) {
            this.settingService.set(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, MAX_FAVORITE_APPS, SettingValue.create((Long)maxFavoriteApplications));
            this.maxFavoriteApps = maxFavoriteApplications;
        } else {
            this.settingService.remove(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, MAX_FAVORITE_APPS);
            this.maxFavoriteApps = -1L;
        }
    }

    public long getMaxFavoriteApps() {
        if (this.maxFavoriteApps < 0L) {
            SettingValue maxFavoriteAppsValue = this.settingService.get(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, MAX_FAVORITE_APPS);
            this.maxFavoriteApps = maxFavoriteAppsValue != null && maxFavoriteAppsValue.getValue() != null ? Long.parseLong(maxFavoriteAppsValue.getValue().toString()) : this.defaultMaxFavoriteApps;
        }
        return this.maxFavoriteApps;
    }

    public ApplicationImage setDefaultAppImage(ApplicationImage defaultAppImage) throws Exception {
        if (defaultAppImage == null || StringUtils.isBlank((String)defaultAppImage.getFileName()) && StringUtils.isBlank((String)defaultAppImage.getFileBody())) {
            this.settingService.remove(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, DEFAULT_APP_IMAGE_ID);
        } else {
            ApplicationImage applicationImage = this.appCenterStorage.saveAppImageFileItem(defaultAppImage);
            if (applicationImage != null && applicationImage.getId() != null && applicationImage.getId() > 0L) {
                this.settingService.set(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, DEFAULT_APP_IMAGE_ID, SettingValue.create((String)String.valueOf(applicationImage.getId())));
                return applicationImage;
            }
        }
        return null;
    }

    public GeneralSettings getAppGeneralSettings() throws Exception {
        GeneralSettings generalsettings = new GeneralSettings();
        generalsettings.setMaxFavoriteApps(this.getMaxFavoriteApps());
        Long defaultAppImageId = this.getDefaultImageId();
        if (defaultAppImageId != null) {
            ApplicationImage defaultImage = this.appCenterStorage.getAppImageFile(defaultAppImageId);
            generalsettings.setDefaultApplicationImage(defaultImage);
        }
        return generalsettings;
    }

    public ApplicationList getApplicationsList(int offset, int limit, String keyword) throws FileStorageException {
        ApplicationList applicationList = new ApplicationList();
        List<Application> applications = this.appCenterStorage.getApplications(keyword);
        if (limit <= 0) {
            limit = applications.size();
        }
        applications = applications.stream().skip(offset).limit(limit).collect(Collectors.toList());
        applicationList.setApplications(applications);
        applicationList.setSize(applications.size());
        applicationList.setOffset(offset);
        applicationList.setLimit(limit);
        return applicationList;
    }

    public ApplicationList getAuthorizedApplicationsList(int offset, int limit, String keyword, String username) throws FileStorageException {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        ApplicationList resultApplicationsList = new ApplicationList();
        List<Application> userApplicationsList = this.getApplications(offset, limit, keyword, username).stream().collect(Collectors.toList());
        userApplicationsList = userApplicationsList.stream().map(app -> {
            UserApplication applicationFavorite = new UserApplication((Application)app);
            applicationFavorite.setFavorite(this.appCenterStorage.isFavoriteApplication(applicationFavorite.getId(), username));
            return applicationFavorite;
        }).collect(Collectors.toList());
        resultApplicationsList.setApplications(userApplicationsList);
        long countFavorites = this.appCenterStorage.countFavorites(username);
        resultApplicationsList.setCanAddFavorite(countFavorites < this.getMaxFavoriteApps());
        resultApplicationsList.setOffset(offset);
        resultApplicationsList.setLimit(limit);
        resultApplicationsList.setSize(userApplicationsList.size());
        return resultApplicationsList;
    }

    public ApplicationList getMandatoryAndFavoriteApplicationsList(String username) {
        List<UserApplication> mandatoryAndFavoriteApplications = this.appCenterStorage.getMandatoryApplications();
        mandatoryAndFavoriteApplications.addAll(this.appCenterStorage.getFavoriteApplicationsByUser(username));
        List<Application> applications = mandatoryAndFavoriteApplications.stream().filter(app -> this.hasPermission(username, (Application)app)).collect(Collectors.toList());
        ApplicationList applicationList = new ApplicationList();
        applicationList.setApplications(applications);
        long countFavorites = this.appCenterStorage.countFavorites(username);
        applicationList.setCanAddFavorite(countFavorites < this.getMaxFavoriteApps());
        applicationList.setLimit(mandatoryAndFavoriteApplications.size());
        applicationList.setSize(mandatoryAndFavoriteApplications.size());
        applicationList.setOffset(0L);
        return applicationList;
    }

    public void updateFavoriteApplicationOrder(ApplicationOrder applicationOrder, String userName) throws ApplicationNotFoundException, FileStorageException {
        if (StringUtils.isBlank((String)userName)) {
            throw new IllegalArgumentException("userName is mandatory");
        }
        if (applicationOrder.getId() <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        Application application = this.appCenterStorage.getApplicationById(applicationOrder.getId());
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationOrder.getId().toString() + " wasn't found in store");
        }
        this.appCenterStorage.updateFavoriteApplicationOrder(applicationOrder.getId(), userName, applicationOrder.getOrder());
    }

    public Long getApplicationImageLastUpdated(long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException, FileStorageException {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " wasn't found");
        }
        if (!this.hasPermission(username, application)) {
            throw new IllegalAccessException("User " + username + " isn't allowed to access application with id " + applicationId);
        }
        if (application.getImageFileId() != null && application.getImageFileId() > 0L) {
            return this.appCenterStorage.getApplicationImageLastUpdated(application.getImageFileId());
        }
        Long defaultImageId = this.getDefaultImageId();
        if (defaultImageId != null && defaultImageId > 0L) {
            return this.appCenterStorage.getApplicationImageLastUpdated(defaultImageId);
        }
        return null;
    }

    public InputStream getApplicationImageInputStream(long applicationId, String username) throws ApplicationNotFoundException, IllegalAccessException, FileStorageException, IOException {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Application application = this.appCenterStorage.getApplicationById(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " wasn't found");
        }
        if (!this.hasPermission(username, application)) {
            throw new IllegalAccessException("User " + username + " isn't allowed to access application with id " + applicationId);
        }
        if (application.getImageFileId() != null && application.getImageFileId() > 0L) {
            return this.appCenterStorage.getApplicationImageInputStream(application.getImageFileId());
        }
        Long defaultImageId = this.getDefaultImageId();
        if (defaultImageId != null && defaultImageId > 0L) {
            return this.appCenterStorage.getApplicationImageInputStream(defaultImageId);
        }
        return null;
    }

    public void addApplicationPlugin(ApplicationPlugin applicationPlugin) {
        if (applicationPlugin == null) {
            throw new IllegalArgumentException("'applicationPlugin' is mandatory");
        }
        if (StringUtils.isBlank((String)applicationPlugin.getName())) {
            throw new IllegalStateException("'applicationPlugin' name is mandatory");
        }
        this.defaultApplications.put(applicationPlugin.getName(), applicationPlugin);
    }

    public void removeApplicationPlugin(String pluginName) {
        if (StringUtils.isBlank((String)pluginName)) {
            throw new IllegalArgumentException("'pluginName' is mandatory");
        }
        this.defaultApplications.remove(pluginName);
    }

    public boolean isDefaultSystemApplication(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("'application' is mandatory");
        }
        return this.defaultApplications.values().stream().anyMatch(app -> StringUtils.equals((String)app.getApplication().getTitle(), (String)application.getTitle()) && StringUtils.equals((String)app.getApplication().getUrl(), (String)application.getUrl()));
    }

    private boolean hasPermission(String username, Application application) {
        return this.hasPermission(username, application.getPermissions());
    }

    private boolean hasPermission(String username, List<String> storedPermissions) {
        if (storedPermissions == null) {
            return true;
        }
        for (String storedPermission : storedPermissions) {
            if (!this.hasPermission(username, storedPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPermission(String username, String permissionExpression) {
        if (StringUtils.isBlank((String)permissionExpression)) {
            return true;
        }
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        Identity identity = this.identityRegistry.getIdentity(username);
        if (identity == null) {
            try {
                identity = this.authenticator.createIdentity(username);
            }
            catch (Exception e) {
                LOG.warn("Error getting memberships of user {}", new Object[]{username, e});
                return false;
            }
            if (identity == null) {
                return false;
            }
        }
        MembershipEntry membership = null;
        if (permissionExpression.contains(":")) {
            String[] permissionExpressionParts = permissionExpression.split(":");
            membership = new MembershipEntry(permissionExpressionParts[1], permissionExpressionParts[0]);
        } else if (permissionExpression.contains("/")) {
            membership = new MembershipEntry(permissionExpression, "*");
        } else {
            return StringUtils.equals((String)username, (String)permissionExpression);
        }
        return identity.isMemberOf(membership);
    }

    private Long getDefaultImageId() {
        SettingValue defaultAppImageIdSetting = this.settingService.get(APP_CENTER_CONTEXT, APP_CENTER_SCOPE, DEFAULT_APP_IMAGE_ID);
        Long defaultAppImageId = null;
        if (defaultAppImageIdSetting != null && defaultAppImageIdSetting.getValue() != null) {
            defaultAppImageId = Long.parseLong(defaultAppImageIdSetting.getValue().toString());
        }
        return defaultAppImageId;
    }

    private List<Application> getApplications(int offset, int limit, String keyword, String username) throws FileStorageException {
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Application> userApplicationsList = new ArrayList();
        List<Application> applications = this.appCenterStorage.getApplications(keyword);
        applications = applications.stream().filter(app -> this.hasPermission(username, (Application)app)).filter(application -> application.isActive()).collect(Collectors.toList());
        if (limit <= 0) {
            limit = applications.size();
        }
        userApplicationsList = applications.stream().skip(offset).limit(limit).collect(Collectors.toList());
        return userApplicationsList;
    }
}

