/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.storage;

import java.util.List;
import org.exoplatform.appcenter.dao.ApplicationDAO;
import org.exoplatform.appcenter.dao.FavoriteApplicationDAO;
import org.exoplatform.appcenter.dto.Application;
import org.exoplatform.appcenter.dto.ApplicationImage;
import org.exoplatform.appcenter.dto.UserApplication;
import org.exoplatform.appcenter.service.ApplicationNotFoundException;
import org.exoplatform.appcenter.storage.ApplicationCenterStorage;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.commons.file.services.impl.NameSpaceServiceImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ApplicationCenterStorageTest {
    private PortalContainer container;

    @BeforeClass
    public static void startDB() {
        RootContainer rootContainer = RootContainer.getInstance();
        InitialContextInitializer initializer = (InitialContextInitializer)rootContainer.getComponentInstanceOfType(InitialContextInitializer.class);
        initializer.recall();
    }

    @Before
    public void setup() {
        this.container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)this.container);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        NameSpaceService fileNameSpaceService = (NameSpaceService)ExoContainerContext.getService(NameSpaceService.class);
        Assert.assertNotNull((Object)fileNameSpaceService);
        ((NameSpaceServiceImpl)fileNameSpaceService).start();
    }

    @After
    public void teardown() {
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        favoriteApplicationDAO.deleteAll();
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        applicationDAO.deleteAll();
        RequestLifeCycle.end();
        this.container.stop();
        this.container = null;
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testCreateApplication() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.createApplication(null);
            Assert.fail((String)"Shouldn't allow to add null application");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        Assert.assertNotNull((Object)storedApplication);
        Assert.assertNotNull((Object)storedApplication.getId());
        Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assert.assertEquals((Object)application.getImageFileId(), (Object)storedApplication.getImageFileId());
        Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    public void testUpdateApplication() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        Application application = new Application(null, "title", "url", "url", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        application.setId(storedApplication.getId());
        application.setActive(!storedApplication.isActive());
        application.setMandatory(!storedApplication.isMandatory());
        application.setDescription("description2");
        application.setUrl("url2");
        application.setUrl("title2");
        application.setImageFileId(Long.valueOf(6L));
        application.setPermissions(new String[]{"permissions3", "permissions4"});
        storedApplication = applicationCenterStorage.updateApplication(application);
        Assert.assertNotNull((Object)storedApplication);
        Assert.assertNotNull((Object)storedApplication.getId());
        Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assert.assertEquals((Object)application.getImageFileId(), (Object)storedApplication.getImageFileId());
        Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    public void testDeleteApplication() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.deleteApplication(0L);
            Assert.fail((String)"Shouldn't allow to delete not existing application");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            applicationCenterStorage.deleteApplication(5000L);
            Assert.fail((String)"Shouldn't allow to delete application with not positive id");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        applicationCenterStorage.deleteApplication(storedApplication.getId().longValue());
        Assert.assertNull((Object)applicationCenterStorage.getApplicationById(storedApplication.getId().longValue()));
    }

    @Test
    public void testGetApplication() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.getApplicationById(0L);
            Assert.fail((String)"Shouldn't allow to get application with not positive id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)applicationCenterStorage.getApplicationById(50000L));
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        storedApplication = applicationCenterStorage.getApplicationById(storedApplication.getId().longValue());
        Assert.assertNotNull((Object)storedApplication);
        Assert.assertNotNull((Object)storedApplication.getId());
        Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assert.assertEquals((Object)application.getImageFileId(), (Object)storedApplication.getImageFileId());
        Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    public void testGetApplicationByTitleOrURL() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.getApplicationByTitle(null);
            Assert.fail((String)"Shouldn't allow to get application by null values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)applicationCenterStorage.getApplicationByTitle("title"));
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        applicationCenterStorage.createApplication(application);
        Application storedApplication = applicationCenterStorage.getApplicationByTitle(application.getTitle());
        Assert.assertNotNull((Object)storedApplication);
        Assert.assertNotNull((Object)storedApplication.getId());
        Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assert.assertEquals((Object)application.getImageFileId(), (Object)storedApplication.getImageFileId());
        Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    public void testAddApplicationToUserFavorite() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.addApplicationToUserFavorite(0L, "testuser");
            Assert.fail((String)"Shouldn't allow to add application as favorite with not positive id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            applicationCenterStorage.addApplicationToUserFavorite(50000L, "testuser");
            Assert.fail((String)"Shouldn't allow to add not existing application as favorite");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), "testuser");
    }

    @Test
    public void testUpdateApplicationFavoriteOrder() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), "testuser");
        Long appID = ((UserApplication)applicationCenterStorage.getFavoriteApplicationsByUser("testuser").get(0)).getId();
        applicationCenterStorage.updateFavoriteApplicationOrder(appID.longValue(), "testuser", new Long(1L));
        Assert.assertEquals((Object)new Long(1L), (Object)((UserApplication)applicationCenterStorage.getFavoriteApplicationsByUser("testuser").get(0)).getOrder());
    }

    @Test
    public void testDeleteApplicationFavorite() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.deleteApplicationFavorite(Long.valueOf(0L), "testuser");
            Assert.fail((String)"Shouldn't allow to delete application as favorite with not positive id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        applicationCenterStorage.deleteApplicationFavorite(Long.valueOf(50000L), "testuser");
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), "testuser");
        applicationCenterStorage.deleteApplicationFavorite(storedApplication.getId(), "testuser");
    }

    @Test
    public void testGetFavoriteApplicationsByUser() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.getFavoriteApplicationsByUser(null);
            Assert.fail((String)"Shouldn't allow to get favorite of null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List favoriteApplications = applicationCenterStorage.getFavoriteApplicationsByUser("testuser");
        Assert.assertNotNull((Object)favoriteApplications);
        Assert.assertEquals((long)0L, (long)favoriteApplications.size());
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), "testuser");
        Assert.assertEquals((long)1L, (long)applicationCenterStorage.getFavoriteApplicationsByUser("testuser").size());
    }

    @Test
    public void testGetMandatoryApplicationsByUser() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.getFavoriteApplicationsByUser(null);
            Assert.fail((String)"Shouldn't allow to get favorite of null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List mandatoryApplications = applicationCenterStorage.getMandatoryApplications();
        Assert.assertNotNull((Object)mandatoryApplications);
        Assert.assertEquals((long)0L, (long)mandatoryApplications.size());
        Application application1 = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, true, true, false, new String[]{"permissions1", "permissions2"});
        Application application2 = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, false, true, true, false, new String[]{"permissions1", "permissions2"});
        applicationCenterStorage.createApplication(application1);
        applicationCenterStorage.createApplication(application2);
        Assert.assertEquals((long)1L, (long)applicationCenterStorage.getMandatoryApplications().size());
    }

    @Test
    public void testGetApplications() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        List applications = applicationCenterStorage.getApplications(null);
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)0L, (long)applications.size());
        applications = applicationCenterStorage.getApplications("title");
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)0L, (long)applications.size());
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        applicationCenterStorage.createApplication(application);
        applications = applicationCenterStorage.getApplications(null);
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)1L, (long)applications.size());
        applications = applicationCenterStorage.getApplications("title");
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)1L, (long)applications.size());
        applications = applicationCenterStorage.getApplications("url");
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)1L, (long)applications.size());
    }

    @Test
    public void testCountApplications() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        Assert.assertEquals((long)0L, (long)applicationCenterStorage.countApplications());
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        applicationCenterStorage.createApplication(application);
        Assert.assertEquals((long)1L, (long)applicationCenterStorage.countApplications());
    }

    @Test
    public void testIsFavoriteApplication() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.isFavoriteApplication(null, null);
            Assert.fail((String)"Shouldn't allow to get favorite of null user or applicationId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            applicationCenterStorage.isFavoriteApplication(null, "testuser");
            Assert.fail((String)"Shouldn't allow to get favorite of null applicationId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            applicationCenterStorage.isFavoriteApplication(Long.valueOf(0L), "testuser");
            Assert.fail((String)"Shouldn't allow to get favorite of non positive applicationId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            applicationCenterStorage.isFavoriteApplication(Long.valueOf(1L), null);
            Assert.fail((String)"Shouldn't allow to get favorite of null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)applicationCenterStorage.isFavoriteApplication(Long.valueOf(1L), "testuser"));
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), "testuser");
        Assert.assertTrue((boolean)applicationCenterStorage.isFavoriteApplication(storedApplication.getId(), "testuser"));
    }

    @Test
    public void testCountFavorites() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        try {
            applicationCenterStorage.countFavorites(null);
            Assert.fail((String)"Shouldn't allow to get favorite of null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)applicationCenterStorage.countFavorites("testuser"));
        Application application = new Application(null, "title", "url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = applicationCenterStorage.createApplication(application);
        applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), "testuser");
        Assert.assertEquals((long)1L, (long)applicationCenterStorage.countFavorites("testuser"));
    }

    @Test
    public void testCreateAppImageFileItem() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        Assert.assertNull((Object)applicationCenterStorage.createAppImageFileItem(null, null));
        Assert.assertNull((Object)applicationCenterStorage.createAppImageFileItem("name", null));
        Assert.assertNull((Object)applicationCenterStorage.createAppImageFileItem(null, "fileContent"));
        ApplicationImage applicationImage = applicationCenterStorage.createAppImageFileItem("name", "fileContent");
        Assert.assertNotNull((Object)applicationImage);
        Assert.assertNotNull((Object)applicationImage.getFileName());
        Assert.assertNotNull((Object)applicationImage.getFileBody());
    }

    @Test
    public void testGetAppImageFile() throws Exception {
        ApplicationCenterStorage applicationCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        Assert.assertNotNull((Object)applicationCenterStorage);
        ApplicationImage applicationImage = applicationCenterStorage.createAppImageFileItem("name", "fileContent");
        Assert.assertNotNull((Object)applicationImage);
        applicationImage = applicationCenterStorage.getAppImageFile(applicationImage.getId());
        Assert.assertNotNull((Object)applicationImage);
        Assert.assertNotNull((Object)applicationImage.getFileName());
        Assert.assertNotNull((Object)applicationImage.getFileBody());
    }
}

