/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.service;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.exoplatform.appcenter.dao.ApplicationDAO;
import org.exoplatform.appcenter.dao.FavoriteApplicationDAO;
import org.exoplatform.appcenter.dto.Application;
import org.exoplatform.appcenter.dto.ApplicationImage;
import org.exoplatform.appcenter.dto.ApplicationList;
import org.exoplatform.appcenter.dto.ApplicationOrder;
import org.exoplatform.appcenter.dto.GeneralSettings;
import org.exoplatform.appcenter.plugin.ApplicationPlugin;
import org.exoplatform.appcenter.service.ApplicationAlreadyExistsException;
import org.exoplatform.appcenter.service.ApplicationCenterService;
import org.exoplatform.appcenter.service.ApplicationNotFoundException;
import org.exoplatform.appcenter.storage.ApplicationCenterStorage;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.picocontainer.Startable;

public class ApplicationCenterServiceTest {
    private static final String ADMIN_USERNAME = "admin";
    private static final String SIMPLE_USERNAME = "simple";
    private ConversationState adminState;
    private ConversationState simpleState;
    private ApplicationCenterService applicationCenterService;
    private ApplicationCenterStorage appCenterStorage;

    @BeforeClass
    public static void startDB() {
        RootContainer rootContainer = RootContainer.getInstance();
        InitialContextInitializer initializer = (InitialContextInitializer)rootContainer.getComponentInstanceOfType(InitialContextInitializer.class);
        initializer.recall();
    }

    @Before
    public void setup() throws Exception {
        User simpleUser;
        PortalContainer container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)container);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        this.applicationCenterService = (ApplicationCenterService)ExoContainerContext.getService(ApplicationCenterService.class);
        this.appCenterStorage = (ApplicationCenterStorage)ExoContainerContext.getService(ApplicationCenterStorage.class);
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        MembershipHandler membershipHandler = organizationService.getMembershipHandler();
        User adminUser = userHandler.findUserByName(ADMIN_USERNAME);
        if (adminUser == null) {
            adminUser = userHandler.createUserInstance(ADMIN_USERNAME);
            userHandler.createUser(adminUser, true);
            MembershipImpl membership = new MembershipImpl("member:admin:/platform/administrators");
            membershipHandler.createMembership((Membership)membership, true);
        }
        if ((simpleUser = userHandler.findUserByName(SIMPLE_USERNAME)) == null) {
            simpleUser = userHandler.createUserInstance(SIMPLE_USERNAME);
            userHandler.createUser(simpleUser, true);
        }
        Startable fileNameSpaceService = (Startable)ExoContainerContext.getService(NameSpaceService.class);
        Assert.assertNotNull((Object)fileNameSpaceService);
        fileNameSpaceService.start();
        ArrayList<MembershipEntry> adminMemberships = new ArrayList<MembershipEntry>();
        adminMemberships.add(new MembershipEntry("/platform/administrators", "*"));
        adminMemberships.add(new MembershipEntry("/platform/users", "*"));
        ArrayList<MembershipEntry> simpleMemberships = new ArrayList<MembershipEntry>();
        simpleMemberships.add(new MembershipEntry("/platform/users", "*"));
        Identity adminIdentity = new Identity(ADMIN_USERNAME, adminMemberships);
        Identity simpleIdentity = new Identity(SIMPLE_USERNAME, simpleMemberships);
        this.adminState = new ConversationState(adminIdentity);
        this.simpleState = new ConversationState(simpleIdentity);
    }

    @After
    public void teardown() {
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        favoriteApplicationDAO.deleteAll();
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        applicationDAO.deleteAll();
        ConversationState.setCurrent(null);
        RequestLifeCycle.end();
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testCreateApplication() throws Exception {
        try {
            this.applicationCenterService.createApplication(null);
            Assert.fail((String)"Shouldn't allow to add null application");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"permissions1", "permissions2"});
        Application storedApplication = this.applicationCenterService.createApplication(application);
        Assert.assertNotNull((Object)storedApplication);
        Assert.assertNotNull((Object)storedApplication.getId());
        Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assert.assertEquals((Object)application.getImageFileId(), (Object)storedApplication.getImageFileId());
        Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
        try {
            this.applicationCenterService.createApplication(storedApplication);
            Assert.fail((String)"Shouldn't allow to create the application again");
        }
        catch (ApplicationAlreadyExistsException applicationAlreadyExistsException) {
            // empty catch block
        }
        application.setUrl("");
        application.setTitle("applicationWithEmptyUrl");
        Assert.assertThrows(MalformedURLException.class, () -> this.applicationCenterService.createApplication(application));
        application.setUrl("./url");
        application.setHelpPageURL("javascript:alert('XSS')");
        application.setTitle("applicationWithMalFormedHelpPageUrl");
        Assert.assertThrows(MalformedURLException.class, () -> this.applicationCenterService.createApplication(application));
        application.setUrl("/portal/url");
        application.setHelpPageURL("");
        application.setTitle("applicationWithValidUrlAndEmptyHelpPageUrl");
        storedApplication = this.applicationCenterService.createApplication(application);
        Assert.assertNotNull((Object)storedApplication);
        application.setUrl("https://applictaion/url");
        application.setHelpPageURL("https://help/page/url");
        application.setTitle("applicationWithValidUrlAndHelpPageUrl");
        storedApplication = this.applicationCenterService.createApplication(application);
        Assert.assertNotNull((Object)storedApplication);
    }

    @Test
    public void testUpdateApplication() throws Exception {
        try {
            this.applicationCenterService.updateApplication(null, null);
            Assert.fail((String)"Shouldn't allow to add null arguments");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.applicationCenterService.updateApplication(null, "testuser");
            Assert.fail((String)"Shouldn't allow to add null application");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        try {
            this.applicationCenterService.updateApplication(application, null);
            Assert.fail((String)"Shouldn't allow to add null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.adminState);
        try {
            this.applicationCenterService.updateApplication(application, ADMIN_USERNAME);
            Assert.fail((String)"Shouldn't allow to update non existing application");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        try {
            application.setId(Long.valueOf(50000L));
            this.applicationCenterService.updateApplication(application, ADMIN_USERNAME);
            Assert.fail((String)"Shouldn't allow to update non existing application");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
        }
        finally {
            application.setId(null);
        }
        Application storedApplication = this.applicationCenterService.createApplication(application);
        application.setId(storedApplication.getId());
        application.setTitle("title2");
        storedApplication = this.applicationCenterService.updateApplication(application, ADMIN_USERNAME);
        Assert.assertNotNull((Object)storedApplication);
        Assert.assertNotNull((Object)storedApplication.getId());
        Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assert.assertEquals((Object)application.getImageFileId(), (Object)storedApplication.getImageFileId());
        Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            storedApplication = this.applicationCenterService.updateApplication(application, SIMPLE_USERNAME);
            Assert.fail((String)"Simple user shouldn't be able to update non authorized application");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.adminState);
        application.setPermissions(new String[]{"*:/platform/users"});
        storedApplication = this.applicationCenterService.updateApplication(application, ADMIN_USERNAME);
        Assert.assertEquals((Object)"*:/platform/users", storedApplication.getPermissions().get(0));
        application.setUrl("./url2");
        storedApplication = this.applicationCenterService.updateApplication(application, ADMIN_USERNAME);
        Assert.assertEquals((Object)"./url2", (Object)storedApplication.getUrl());
    }

    @Test
    public void testDeleteApplication() throws Exception {
        try {
            this.applicationCenterService.deleteApplication(null, null);
            Assert.fail((String)"Shouldn't allow to add null arguments");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.applicationCenterService.deleteApplication(null, "testuser");
            Assert.fail((String)"Shouldn't allow to add null application");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.applicationCenterService.deleteApplication(Long.valueOf(50000L), null);
            Assert.fail((String)"Shouldn't allow to add null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.adminState);
        try {
            this.applicationCenterService.deleteApplication(Long.valueOf(50000L), ADMIN_USERNAME);
            Assert.fail((String)"Shouldn't allow to update non existing application");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        Application storedApplication = this.applicationCenterService.createApplication(application);
        this.applicationCenterService.deleteApplication(storedApplication.getId(), ADMIN_USERNAME);
        application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        storedApplication = this.applicationCenterService.createApplication(application);
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.deleteApplication(storedApplication.getId(), SIMPLE_USERNAME);
            Assert.fail((String)"Simple user shouldn't be able to delete non authorized application");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.adminState);
        application.setId(storedApplication.getId());
        application.setPermissions(new String[]{"*:/platform/users"});
        storedApplication = this.applicationCenterService.updateApplication(application, ADMIN_USERNAME);
        this.applicationCenterService.deleteApplication(storedApplication.getId(), ADMIN_USERNAME);
    }

    @Test
    public void testMaxFavoriteApps() {
        long originalMaxFavoriteApps = this.applicationCenterService.getMaxFavoriteApps();
        this.applicationCenterService.setMaxFavoriteApps(originalMaxFavoriteApps + 1L);
        Assert.assertEquals((long)(originalMaxFavoriteApps + 1L), (long)this.applicationCenterService.getMaxFavoriteApps());
        this.applicationCenterService.setMaxFavoriteApps(0L);
        Assert.assertEquals((long)0L, (long)this.applicationCenterService.getMaxFavoriteApps());
    }

    @Test
    public void testSetDefaultAppImage() throws Exception {
        ApplicationImage applicationImage = this.applicationCenterService.setDefaultAppImage(null);
        Assert.assertNull((Object)applicationImage);
        applicationImage = new ApplicationImage(null, null, null);
        applicationImage = this.applicationCenterService.setDefaultAppImage(applicationImage);
        Assert.assertNull((Object)applicationImage);
        applicationImage = new ApplicationImage(null, "name", "content");
        applicationImage = this.applicationCenterService.setDefaultAppImage(applicationImage);
        Assert.assertNotNull((Object)applicationImage);
        Assert.assertNotNull((Object)applicationImage.getId());
        ApplicationImage storedApplicationImage = this.applicationCenterService.setDefaultAppImage(applicationImage);
        Assert.assertNotNull((Object)storedApplicationImage);
        Assert.assertEquals((Object)applicationImage.getId(), (Object)storedApplicationImage.getId());
    }

    @Test
    public void testGetAppGeneralSettings() throws Exception {
        this.applicationCenterService.setDefaultAppImage(null);
        this.applicationCenterService.setMaxFavoriteApps(0L);
        GeneralSettings generalSettings = this.applicationCenterService.getAppGeneralSettings();
        Assert.assertNotNull((Object)generalSettings);
        Assert.assertEquals((long)0L, (long)generalSettings.getMaxFavoriteApps());
        Assert.assertNull((Object)generalSettings.getDefaultApplicationImage());
        this.applicationCenterService.setDefaultAppImage(new ApplicationImage(null, null, null));
        generalSettings = this.applicationCenterService.getAppGeneralSettings();
        Assert.assertEquals((long)0L, (long)generalSettings.getMaxFavoriteApps());
        Assert.assertNull((Object)generalSettings.getDefaultApplicationImage());
        this.applicationCenterService.setDefaultAppImage(new ApplicationImage(null, "name", "content"));
        generalSettings = this.applicationCenterService.getAppGeneralSettings();
        Assert.assertEquals((long)0L, (long)generalSettings.getMaxFavoriteApps());
        Assert.assertNotNull((Object)generalSettings.getDefaultApplicationImage());
        Assert.assertEquals((Object)"name", (Object)generalSettings.getDefaultApplicationImage().getFileName());
        Assert.assertFalse((boolean)generalSettings.getDefaultApplicationImage().getFileBody().isEmpty());
        Assert.assertNotNull((Object)generalSettings.getDefaultApplicationImage().getId());
    }

    @Test
    public void testAddFavoriteApplication() throws Exception {
        ConversationState.setCurrent((ConversationState)this.adminState);
        try {
            this.applicationCenterService.addFavoriteApplication(0L, null);
            Assert.fail((String)"Shouldn't allow to add null arguments");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.addFavoriteApplication(0L, SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to add zero as applicationId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.applicationCenterService.addFavoriteApplication(5000L, SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to add an application as favorite while it doesn't exist");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        Application storedApplication = this.applicationCenterService.createApplication(application);
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.addFavoriteApplication(storedApplication.getId().longValue(), SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to add an application as favorite while user doesn't have access to it");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.adminState);
        this.applicationCenterService.addFavoriteApplication(storedApplication.getId().longValue(), ADMIN_USERNAME);
        storedApplication.setPermissions(new String[]{"*:/platform/users"});
        storedApplication = this.applicationCenterService.updateApplication(storedApplication, ADMIN_USERNAME);
        ConversationState.setCurrent((ConversationState)this.simpleState);
        this.applicationCenterService.addFavoriteApplication(storedApplication.getId().longValue(), SIMPLE_USERNAME);
    }

    @Test
    public void testDeleteFavoriteApplication() throws Exception {
        try {
            this.applicationCenterService.deleteFavoriteApplication(null, null);
            Assert.fail((String)"Shouldn't allow to add null arguments");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.deleteFavoriteApplication(Long.valueOf(0L), SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to add zero as applicationId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.applicationCenterService.deleteFavoriteApplication(Long.valueOf(5000L), SIMPLE_USERNAME);
        Application application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        Application storedApplication = this.applicationCenterService.createApplication(application);
        this.applicationCenterService.deleteFavoriteApplication(storedApplication.getId(), SIMPLE_USERNAME);
        ConversationState.setCurrent((ConversationState)this.adminState);
        this.applicationCenterService.deleteFavoriteApplication(storedApplication.getId(), ADMIN_USERNAME);
        this.applicationCenterService.addFavoriteApplication(storedApplication.getId().longValue(), ADMIN_USERNAME);
        this.applicationCenterService.deleteFavoriteApplication(storedApplication.getId(), ADMIN_USERNAME);
        storedApplication.setPermissions(new String[]{"*:/platform/users"});
        storedApplication = this.applicationCenterService.updateApplication(storedApplication, ADMIN_USERNAME);
        ConversationState.setCurrent((ConversationState)this.simpleState);
        this.applicationCenterService.addFavoriteApplication(storedApplication.getId().longValue(), SIMPLE_USERNAME);
        this.applicationCenterService.deleteFavoriteApplication(storedApplication.getId(), SIMPLE_USERNAME);
    }

    @Test
    public void testGetApplicationsList() throws Exception {
        ApplicationList applicationsList = this.applicationCenterService.getApplicationsList(0, 0, null);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)0L, (long)applicationsList.getSize());
        Assert.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assert.assertEquals((long)0L, (long)applicationsList.getLimit());
        Application application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        this.applicationCenterService.createApplication(application);
        Application application2 = new Application(null, "title2", "./url2", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        this.applicationCenterService.createApplication(application2);
        applicationsList = this.applicationCenterService.getApplicationsList(0, 0, null);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)2L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)2L, (long)applicationsList.getSize());
        applicationsList = this.applicationCenterService.getApplicationsList(1, 0, null);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)1L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)1L, (long)applicationsList.getSize());
        applicationsList = this.applicationCenterService.getApplicationsList(2, 0, null);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)0L, (long)applicationsList.getSize());
        applicationsList = this.applicationCenterService.getApplicationsList(3, 0, null);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)0L, (long)applicationsList.getSize());
        applicationsList = this.applicationCenterService.getApplicationsList(0, 10, null);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)2L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)2L, (long)applicationsList.getSize());
    }

    @Test
    public void testGetMandatoryAndFavoriteApplicationsList() throws Exception {
        Application application1 = new Application(null, "title1", "./url1", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description1", false, true, true, true, false, new String[]{"/platform/administrators"});
        Application application2 = new Application(null, "title2", "./url2", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, false, true, true, false, new String[]{"/platform/administrators"});
        Application application3 = new Application(null, "title3", "./url3", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description3", false, true, false, false, false, new String[]{"/platform/administrators"});
        Application application4 = new Application(null, "title4", "./url4", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description4", false, true, false, false, false, new String[]{"/platform/administrators"});
        Application application5 = new Application(null, "title5", "./url5", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description5", false, true, false, false, false, new String[]{"*:/platform/users"});
        this.applicationCenterService.createApplication(application1);
        this.applicationCenterService.createApplication(application2);
        Application storedApp3 = this.applicationCenterService.createApplication(application3);
        Application storedApp4 = this.applicationCenterService.createApplication(application4);
        Application storedApp5 = this.applicationCenterService.createApplication(application5);
        this.applicationCenterService.addFavoriteApplication(storedApp3.getId().longValue(), ADMIN_USERNAME);
        this.applicationCenterService.addFavoriteApplication(storedApp4.getId().longValue(), ADMIN_USERNAME);
        this.applicationCenterService.addFavoriteApplication(storedApp5.getId().longValue(), SIMPLE_USERNAME);
        ApplicationList MandatoryAndFavoriteApplications = this.applicationCenterService.getMandatoryAndFavoriteApplicationsList(ADMIN_USERNAME);
        Assert.assertEquals((long)3L, (long)MandatoryAndFavoriteApplications.getApplications().size());
        Assert.assertEquals((long)3L, (long)MandatoryAndFavoriteApplications.getSize());
    }

    @Test
    public void testUpdateFavoriteApplicationOrder() throws Exception {
        Application application1 = new Application(null, "title3", "./url3", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description3", false, true, false, false, false, new String[]{"/platform/administrators"});
        Application application2 = new Application(null, "title5", "./url5", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description5", false, true, false, false, false, new String[]{"*:/platform/users"});
        try {
            this.applicationCenterService.getMandatoryAndFavoriteApplicationsList("");
            Assert.fail((String)"Shouldn't retrieve applications with null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Application storedApp1 = this.applicationCenterService.createApplication(application1);
        Application storedApp2 = this.applicationCenterService.createApplication(application2);
        this.applicationCenterService.addFavoriteApplication(storedApp1.getId().longValue(), ADMIN_USERNAME);
        this.applicationCenterService.addFavoriteApplication(storedApp2.getId().longValue(), SIMPLE_USERNAME);
        this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(storedApp1.getId(), new Long(1L)), ADMIN_USERNAME);
        this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(storedApp2.getId(), new Long(2L)), SIMPLE_USERNAME);
        try {
            this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(storedApp1.getId(), new Long(1L)), "");
            Assert.fail((String)"Shouldn't retrieve applications with null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(Long.valueOf(0L), new Long(1L)), "");
            Assert.fail((String)"Application id can not be negative or equal to zero.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)new Long(1L), (Object)((Application)this.applicationCenterService.getMandatoryAndFavoriteApplicationsList(ADMIN_USERNAME).getApplications().get(0)).getOrder());
        Assert.assertEquals((Object)new Long(1L), (Object)((Application)this.applicationCenterService.getMandatoryAndFavoriteApplicationsList(ADMIN_USERNAME).getApplications().get(0)).getOrder());
    }

    @Test
    public void testGetAuthorizedApplicationsList() throws Exception {
        try {
            this.applicationCenterService.getAuthorizedApplicationsList(0, 0, null, null);
            Assert.fail((String)"Shouldn't retrieve applications with null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.simpleState);
        ApplicationList applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(0, 0, null, SIMPLE_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)0L, (long)applicationsList.getSize());
        Application application = new Application(null, "title", "./url", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        ConversationState.setCurrent((ConversationState)this.adminState);
        this.applicationCenterService.createApplication(application);
        Application application2 = new Application(null, "title2", "./url2", "", Long.valueOf(0L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"*:/platform/users"});
        this.applicationCenterService.createApplication(application2);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(0, 0, null, ADMIN_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)2L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)2L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.simpleState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(0, 0, null, SIMPLE_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)1L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)1L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.adminState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(1, 0, null, ADMIN_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)1L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)2L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.simpleState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(1, 0, null, SIMPLE_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)1L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.adminState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(2, 0, null, ADMIN_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)2L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.simpleState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(2, 0, null, SIMPLE_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)1L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.adminState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(3, 0, null, ADMIN_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)2L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.simpleState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(3, 0, null, SIMPLE_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)1L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.adminState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(0, 10, null, ADMIN_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)2L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)2L, (long)applicationsList.getSize());
        ConversationState.setCurrent((ConversationState)this.simpleState);
        applicationsList = this.applicationCenterService.getAuthorizedApplicationsList(0, 10, null, SIMPLE_USERNAME);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)1L, (long)applicationsList.getApplications().size());
        Assert.assertEquals((long)1L, (long)applicationsList.getSize());
    }

    @Test
    public void testGetLastUpdated() throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        try {
            this.applicationCenterService.getApplicationImageLastUpdated(50000L, null);
            Assert.fail((String)"Shouldn't allow to use null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.getApplicationImageLastUpdated(50000L, SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to get not found application");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(5L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        application.setImageFileName("name");
        application.setImageFileBody("content");
        Application storedApplication = this.applicationCenterService.createApplication(application);
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.getApplicationImageLastUpdated(storedApplication.getId().longValue(), SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to get illustration of non authorized application");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.adminState);
        Long lastUpdated = this.applicationCenterService.getApplicationImageLastUpdated(storedApplication.getId().longValue(), ADMIN_USERNAME);
        Assert.assertNotNull((Object)lastUpdated);
        Assert.assertTrue((lastUpdated >= currentTimeMillis ? 1 : 0) != 0);
    }

    @Test
    public void testGetImageStream() throws Exception {
        try {
            this.applicationCenterService.getApplicationImageInputStream(50000L, null);
            Assert.fail((String)"Shouldn't allow to use null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.getApplicationImageInputStream(50000L, SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to get not found application");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(5L), Long.valueOf(0L), null, null, "description", false, true, false, false, false, new String[]{"/platform/administrators"});
        application.setImageFileName("name");
        application.setImageFileBody("content");
        Application storedApplication = this.applicationCenterService.createApplication(application);
        ConversationState.setCurrent((ConversationState)this.simpleState);
        try {
            this.applicationCenterService.getApplicationImageInputStream(storedApplication.getId().longValue(), SIMPLE_USERNAME);
            Assert.fail((String)"Shouldn't allow to get illustration of non authorized application");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ConversationState.setCurrent((ConversationState)this.adminState);
        InputStream inputStream = this.applicationCenterService.getApplicationImageInputStream(storedApplication.getId().longValue(), ADMIN_USERNAME);
        Assert.assertNotNull((Object)inputStream);
        Assert.assertTrue((inputStream.available() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddApplicationPlugin() throws FileStorageException {
        ApplicationList applicationsList;
        try {
            this.applicationCenterService.addApplicationPlugin(null);
            Assert.fail((String)"Shouldn't be able to add null plugin");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ApplicationPlugin(null);
            Assert.fail((String)"Shouldn't be able to add null params in plugin");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        InitParams params = new InitParams();
        try {
            new ApplicationPlugin(params);
            Assert.fail((String)"Shouldn't be able to add null application in parameter of plugin");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(5L), Long.valueOf(0L), null, null, "description", false, true, false, false, true, new String[]{"/platform/administrators"});
        ObjectParameter applicationParam = new ObjectParameter();
        applicationParam.setName("application");
        applicationParam.setObject((Object)application);
        params.addParameter((Parameter)applicationParam);
        ApplicationPlugin applicationPlugin = new ApplicationPlugin(params);
        Assert.assertNotNull((Object)applicationPlugin.getApplication());
        Assert.assertNull((Object)applicationPlugin.getImagePath());
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            Assert.fail((String)"Shouldn't be able to add plugin with null name");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String pluginName = "testapp";
        applicationPlugin.setName(pluginName);
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            this.applicationCenterService.start();
            ApplicationList applicationsList2 = this.applicationCenterService.getApplicationsList(0, 0, null);
            Assert.assertNotNull((Object)applicationsList2);
            Assert.assertNotNull((Object)applicationsList2.getApplications());
            Assert.assertEquals((long)1L, (long)applicationsList2.getApplications().size());
            Application storedApplication = (Application)applicationsList2.getApplications().get(0);
            Assert.assertNotNull((Object)storedApplication);
            Assert.assertNotNull((Object)storedApplication.getId());
            Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
            Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
            Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
            Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
            Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
            Assert.assertTrue((boolean)storedApplication.isSystem());
            Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
            Assert.assertNull((Object)application.getImageFileId());
        }
        catch (FileStorageException e) {
            Assert.fail((String)"Should not throw exception for a missing file");
        }
        finally {
            this.applicationCenterService.removeApplicationPlugin(pluginName);
        }
        ValueParam imagePathValueParam = new ValueParam();
        imagePathValueParam.setName("imagePath");
        imagePathValueParam.setValue("jar:/test.png");
        params.addParameter((Parameter)imagePathValueParam);
        applicationPlugin = new ApplicationPlugin(params);
        applicationPlugin.setName(pluginName);
        Assert.assertNotNull((Object)applicationPlugin.getApplication());
        Assert.assertNotNull((Object)applicationPlugin.getImagePath());
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            try {
                Application newApplication = this.appCenterStorage.getApplicationByTitle("title");
                newApplication.setChangedManually(true);
                this.appCenterStorage.updateApplication(newApplication);
            }
            catch (Exception newApplication) {
                // empty catch block
            }
            this.applicationCenterService.start();
            ApplicationList applicationsList3 = this.applicationCenterService.getApplicationsList(0, 0, null);
            Assert.assertNotNull((Object)applicationsList3);
            Assert.assertNotNull((Object)applicationsList3.getApplications());
            Assert.assertEquals((long)1L, (long)applicationsList3.getApplications().size());
            Application storedApplication = (Application)applicationsList3.getApplications().get(0);
            Assert.assertNotNull((Object)storedApplication);
            Assert.assertNotNull((Object)storedApplication.getId());
            Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
            Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
            Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
            Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
            Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
            Assert.assertTrue((boolean)storedApplication.isSystem());
            Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
            Assert.assertNull((Object)application.getImageFileId());
        }
        catch (FileStorageException e) {
            e.printStackTrace();
        }
        finally {
            this.applicationCenterService.removeApplicationPlugin(pluginName);
        }
        ValueParam overrideValueParam = new ValueParam();
        overrideValueParam.setName("override");
        overrideValueParam.setValue("true");
        params.addParameter((Parameter)overrideValueParam);
        applicationPlugin = new ApplicationPlugin(params);
        applicationPlugin.setName(pluginName);
        Assert.assertNotNull((Object)applicationPlugin.getApplication());
        Assert.assertNotNull((Object)applicationPlugin.getImagePath());
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            this.applicationCenterService.start();
            applicationsList = this.applicationCenterService.getApplicationsList(0, 0, null);
            Assert.assertNotNull((Object)applicationsList);
            Assert.assertNotNull((Object)applicationsList.getApplications());
            Assert.assertEquals((long)1L, (long)applicationsList.getApplications().size());
            Application storedApplication = (Application)applicationsList.getApplications().get(0);
            Assert.assertNotNull((Object)storedApplication);
            Assert.assertNotNull((Object)storedApplication.getId());
            Assert.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
            Assert.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
            Assert.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
            Assert.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
            Assert.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
            Assert.assertTrue((boolean)storedApplication.isSystem());
            Assert.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
            Assert.assertNotNull((Object)application.getImageFileId());
        }
        finally {
            this.applicationCenterService.removeApplicationPlugin(pluginName);
        }
        this.applicationCenterService.start();
        applicationsList = this.applicationCenterService.getApplicationsList(0, 0, null);
        Assert.assertNotNull((Object)applicationsList);
        Assert.assertNotNull((Object)applicationsList.getApplications());
        Assert.assertEquals((long)0L, (long)applicationsList.getApplications().size());
    }

    @Test
    public void testEnableDisableApplication() {
        InitParams applicationConf = new InitParams();
        ObjectParameter applicationParam = new ObjectParameter();
        applicationParam.setName("application");
        applicationParam.setObject((Object)new Application(null, "title", "./url", "", Long.valueOf(5L), Long.valueOf(0L), null, null, "description", false, true, false, false, true, new String[]{"/platform/administrators"}));
        applicationConf.addParameter((Parameter)applicationParam);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("override");
        valueParam.setValue("false");
        applicationConf.addParameter((Parameter)valueParam);
        valueParam.setName("enabled");
        valueParam.setValue("false");
        applicationConf.addParameter((Parameter)valueParam);
        valueParam.setName("imagePath");
        valueParam.setValue("/path/to/image.png");
        applicationConf.addParameter((Parameter)valueParam);
        valueParam.setName("override-mode");
        valueParam.setValue("merge");
        applicationConf.addParameter((Parameter)valueParam);
        ApplicationPlugin applicationPlugin = new ApplicationPlugin(applicationConf);
        applicationPlugin.setName("disabledApplication");
        this.applicationCenterService.addApplicationPlugin(applicationPlugin);
        this.applicationCenterService.start();
        ApplicationList applicationList = new ApplicationList();
        try {
            applicationList = this.applicationCenterService.getApplicationsList(0, 10, null);
        }
        catch (FileStorageException fileStorageException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)applicationList.getSize());
        this.applicationCenterService.stop();
        valueParam = applicationConf.getValueParam("enabled");
        valueParam.setValue("true");
        applicationConf.addParameter((Parameter)valueParam);
        applicationPlugin = new ApplicationPlugin(applicationConf);
        applicationPlugin.setName("enabledApplication");
        this.applicationCenterService.addApplicationPlugin(applicationPlugin);
        this.applicationCenterService.start();
        try {
            applicationList = this.applicationCenterService.getApplicationsList(0, 10, null);
        }
        catch (FileStorageException fileStorageException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)applicationList.getSize());
        this.applicationCenterService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateApplicationBySystem() {
        try {
            this.applicationCenterService.addApplicationPlugin(null);
            Assert.fail((String)"Shouldn't be able to add null plugin");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ApplicationPlugin(null);
            Assert.fail((String)"Shouldn't be able to add null params in plugin");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        InitParams params = new InitParams();
        try {
            new ApplicationPlugin(params);
            Assert.fail((String)"Shouldn't be able to add null application in parameter of plugin");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Application application = new Application(null, "title", "./url", "", Long.valueOf(5L), Long.valueOf(0L), null, null, "description", false, true, false, false, true, new String[]{"/platform/administrators"});
        ObjectParameter applicationParam = new ObjectParameter();
        applicationParam.setName("application");
        applicationParam.setObject((Object)application);
        params.addParameter((Parameter)applicationParam);
        ApplicationPlugin applicationPlugin = new ApplicationPlugin(params);
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            Assert.fail((String)"Shouldn't be able to add plugin with null name");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String pluginName = "testapp";
        applicationPlugin.setName(pluginName);
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            this.applicationCenterService.start();
            ApplicationList applicationsList = this.applicationCenterService.getApplicationsList(0, 0, null);
            Assert.assertNotNull((Object)applicationsList);
            Assert.assertNotNull((Object)applicationsList.getApplications());
            Assert.assertEquals((long)1L, (long)applicationsList.getApplications().size());
        }
        catch (FileStorageException e) {
            e.printStackTrace();
        }
        finally {
            this.applicationCenterService.removeApplicationPlugin(pluginName);
        }
        ValueParam imagePathValueParam = new ValueParam();
        imagePathValueParam.setName("imagePath");
        imagePathValueParam.setValue("jar:/test.png");
        params.addParameter((Parameter)imagePathValueParam);
        ValueParam overrideValueParam = new ValueParam();
        overrideValueParam.setName("override");
        overrideValueParam.setValue("false");
        params.addParameter((Parameter)overrideValueParam);
        ValueParam overrideModeValueParam = new ValueParam();
        overrideModeValueParam.setName("override-mode");
        overrideModeValueParam.setValue("write");
        params.addParameter((Parameter)overrideModeValueParam);
        applicationPlugin = new ApplicationPlugin(params);
        applicationPlugin.setName(pluginName);
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            try {
                Application newApplication = this.appCenterStorage.getApplicationByTitle("title");
                newApplication.setChangedManually(true);
                this.appCenterStorage.updateApplication(newApplication);
            }
            catch (Exception newApplication) {
                // empty catch block
            }
            this.applicationCenterService.start();
            ApplicationList applicationsList = this.applicationCenterService.getApplicationsList(0, 0, null);
            Assert.assertEquals((Object)false, (Object)((Application)applicationsList.getApplications().get(0)).isChangedManually());
        }
        catch (FileStorageException e) {
            e.printStackTrace();
        }
        finally {
            this.applicationCenterService.removeApplicationPlugin(pluginName);
        }
        ValueParam imagePathValueParam1 = new ValueParam();
        imagePathValueParam1.setName("imagePath");
        imagePathValueParam1.setValue("jar:/test.png");
        params.addParameter((Parameter)imagePathValueParam1);
        ValueParam overrideValueParam1 = new ValueParam();
        overrideValueParam1.setName("override");
        overrideValueParam1.setValue("false");
        params.addParameter((Parameter)overrideValueParam1);
        ValueParam overrideModeValueParam1 = new ValueParam();
        overrideModeValueParam1.setName("override-mode");
        overrideModeValueParam1.setValue("merge");
        params.addParameter((Parameter)overrideModeValueParam1);
        applicationPlugin = new ApplicationPlugin(params);
        applicationPlugin.setName(pluginName);
        try {
            this.applicationCenterService.addApplicationPlugin(applicationPlugin);
            try {
                Application newApplication = this.appCenterStorage.getApplicationByTitle("title");
                newApplication.setChangedManually(true);
                this.appCenterStorage.updateApplication(newApplication);
            }
            catch (Exception newApplication) {
                // empty catch block
            }
            this.applicationCenterService.start();
            ApplicationList applicationsList = this.applicationCenterService.getApplicationsList(0, 0, null);
            Assert.assertEquals((Object)true, (Object)((Application)applicationsList.getApplications().get(0)).isChangedManually());
        }
        catch (FileStorageException e) {
            Assert.fail((String)"Avatar file not found for the application");
        }
        finally {
            this.applicationCenterService.removeApplicationPlugin(pluginName);
        }
    }
}

