/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class Usage {
    @Nullable
    private final Detail character;
    @Nullable
    private final Detail document;
    @Nullable
    private final Detail teamDocument;

    @Nullable
    public Detail getCharacter() {
        return this.character;
    }

    @Nullable
    public Detail getDocument() {
        return this.document;
    }

    @Nullable
    public Detail getTeamDocument() {
        return this.teamDocument;
    }

    public Usage(@Nullable Detail character, @Nullable Detail document, @Nullable Detail teamDocument) {
        this.character = character;
        this.document = document;
        this.teamDocument = teamDocument;
    }

    public boolean anyLimitReached() {
        return this.getCharacter() != null && this.getCharacter().limitReached() || this.getDocument() != null && this.getDocument().limitReached() || this.getTeamDocument() != null && this.getTeamDocument().limitReached();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Usage this billing period:");
        BiConsumer<String, Detail> addLabelledDetail = (label, detail) -> {
            if (detail != null) {
                sb.append("\n").append((String)label).append(": ").append(detail);
            }
        };
        addLabelledDetail.accept("Characters", this.getCharacter());
        addLabelledDetail.accept("Documents", this.getDocument());
        addLabelledDetail.accept("Team documents", this.getTeamDocument());
        return sb.toString();
    }

    public static class Detail {
        private final long count;
        private final long limit;

        public Detail(long count, long limit) {
            this.count = count;
            this.limit = limit;
        }

        public long getCount() {
            return this.count;
        }

        public long getLimit() {
            return this.limit;
        }

        public boolean limitReached() {
            return this.getCount() >= this.getLimit();
        }

        public String toString() {
            return this.getCount() + " of " + this.getLimit();
        }
    }
}

