/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.impl.connectors;

import com.deepl.api.DeepLException;
import com.deepl.api.SentenceSplittingMode;
import com.deepl.api.TextTranslationOptions;
import com.deepl.api.Translator;
import java.util.Locale;
import org.exoplatform.automatic.translation.api.AutomaticTranslationComponentPlugin;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DeepLTranslateConnector
extends AutomaticTranslationComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(DeepLTranslateConnector.class);
    private static final String DEEPL_TRANSLATE_SERVICE = "deepl-translate";
    private Translator translator;
    private final TextTranslationOptions textTranslationOptions = new TextTranslationOptions();

    public DeepLTranslateConnector(SettingService settingService) {
        super(settingService);
        this.textTranslationOptions.setTagHandling("html");
        this.textTranslationOptions.setSentenceSplittingMode(SentenceSplittingMode.All);
    }

    public String translate(String message, Locale targetLocale) {
        long startTime = System.currentTimeMillis();
        try {
            return this.getDeeplTranslator().translateText(message, null, this.getLocaleLanguage(targetLocale), this.textTranslationOptions).getText();
        }
        catch (DeepLException e) {
            LOG.error("remote_service={} operation={} parameters=\"message length:{},targetLocale:{}\" status=ko duration_ms={} error_msg=\"{}\"", new Object[]{DEEPL_TRANSLATE_SERVICE, "translate", message.length(), targetLocale.getLanguage(), System.currentTimeMillis() - startTime, e.getMessage()});
        }
        catch (InterruptedException e) {
            LOG.error((Object)"DeepL API translation thread has been interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private String getLocaleLanguage(Locale locale) {
        if (locale.getLanguage().equalsIgnoreCase("en")) {
            return "en-US";
        }
        if (locale.getLanguage().equalsIgnoreCase("pt")) {
            return "pt-PT";
        }
        return locale.getLanguage();
    }

    private Translator getDeeplTranslator() {
        if (this.translator == null) {
            this.translator = new Translator(this.getApiKey());
        }
        return this.translator;
    }
}

