/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import com.deepl.api.AppInfo;
import com.deepl.api.AuthorizationException;
import com.deepl.api.DeepLException;
import com.deepl.api.DocumentHandle;
import com.deepl.api.DocumentNotReadyException;
import com.deepl.api.DocumentStatus;
import com.deepl.api.DocumentTranslationException;
import com.deepl.api.DocumentTranslationOptions;
import com.deepl.api.Formality;
import com.deepl.api.GlossaryEntries;
import com.deepl.api.GlossaryInfo;
import com.deepl.api.GlossaryLanguagePair;
import com.deepl.api.GlossaryNotFoundException;
import com.deepl.api.HttpClientWrapper;
import com.deepl.api.Language;
import com.deepl.api.LanguageCode;
import com.deepl.api.LanguageType;
import com.deepl.api.NotFoundException;
import com.deepl.api.QuotaExceededException;
import com.deepl.api.TextResult;
import com.deepl.api.TextTranslationOptions;
import com.deepl.api.TooManyRequestsException;
import com.deepl.api.TranslatorOptions;
import com.deepl.api.Usage;
import com.deepl.api.http.HttpResponse;
import com.deepl.api.http.HttpResponseStream;
import com.deepl.api.parsing.Parser;
import com.deepl.api.utils.KeyValuePair;
import com.deepl.api.utils.StreamUtil;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class Translator {
    private static final String DEEPL_SERVER_URL_FREE = "https://api-free.deepl.com";
    private static final String DEEPL_SERVER_URL_PRO = "https://api.deepl.com";
    private final Parser jsonParser = new Parser();
    private final HttpClientWrapper httpClientWrapper;

    public Translator(String authKey, TranslatorOptions options) throws IllegalArgumentException {
        if (authKey == null || authKey.length() == 0) {
            throw new IllegalArgumentException("authKey must be a non-empty string");
        }
        String serverUrl = options.getServerUrl() != null ? options.getServerUrl() : (Translator.isFreeAccountAuthKey(authKey) ? DEEPL_SERVER_URL_FREE : DEEPL_SERVER_URL_PRO);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (options.getHeaders() != null) {
            headers.putAll(options.getHeaders());
        }
        headers.putIfAbsent("Authorization", "DeepL-Auth-Key " + authKey);
        headers.putIfAbsent("User-Agent", this.constructUserAgentString(options.getSendPlatformInfo(), options.getAppInfo()));
        this.httpClientWrapper = new HttpClientWrapper(serverUrl, headers, options.getTimeout(), options.getProxy(), options.getMaxRetries());
    }

    public Translator(String authKey) throws IllegalArgumentException {
        this(authKey, new TranslatorOptions());
    }

    private String constructUserAgentString(boolean sendPlatformInfo, AppInfo appInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("deepl-java/1.3.0");
        if (sendPlatformInfo) {
            sb.append(" (");
            Properties props = System.getProperties();
            sb.append(props.get("os.name") + "-" + props.get("os.version") + "-" + props.get("os.arch"));
            sb.append(") java/");
            sb.append(props.get("java.version"));
        }
        if (appInfo != null) {
            sb.append(" " + appInfo.getAppName() + "/" + appInfo.getAppVersion());
        }
        return sb.toString();
    }

    public static boolean isFreeAccountAuthKey(String authKey) {
        return authKey != null && authKey.endsWith(":fx");
    }

    public TextResult translateText(String text, @Nullable String sourceLang, String targetLang, @Nullable TextTranslationOptions options) throws InterruptedException, DeepLException {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(text);
        return this.translateText(texts, sourceLang, targetLang, options).get(0);
    }

    public TextResult translateText(String text, @Nullable String sourceLang, String targetLang) throws DeepLException, InterruptedException {
        return this.translateText(text, sourceLang, targetLang, null);
    }

    public TextResult translateText(String text, @Nullable Language sourceLang, Language targetLang) throws DeepLException, InterruptedException {
        return this.translateText(text, sourceLang != null ? sourceLang.getCode() : null, targetLang.getCode(), null);
    }

    public TextResult translateText(String text, @Nullable Language sourceLang, Language targetLang, @Nullable TextTranslationOptions options) throws DeepLException, InterruptedException {
        return this.translateText(text, sourceLang != null ? sourceLang.getCode() : null, targetLang.getCode(), options);
    }

    public List<TextResult> translateText(List<String> texts, @Nullable String sourceLang, String targetLang, @Nullable TextTranslationOptions options) throws DeepLException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = Translator.createHttpParams(texts, sourceLang, targetLang, options);
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff("/v2/translate", params);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseTextResult(response.getBody());
    }

    public List<TextResult> translateText(List<String> texts, @Nullable Language sourceLang, Language targetLang) throws DeepLException, InterruptedException {
        return this.translateText(texts, sourceLang != null ? sourceLang.getCode() : null, targetLang.getCode(), null);
    }

    public List<TextResult> translateText(List<String> texts, @Nullable Language sourceLang, Language targetLang, @Nullable TextTranslationOptions options) throws DeepLException, InterruptedException {
        return this.translateText(texts, sourceLang != null ? sourceLang.getCode() : null, targetLang.getCode(), options);
    }

    public List<TextResult> translateText(List<String> texts, @Nullable String sourceLang, String targetLang) throws DeepLException, InterruptedException {
        return this.translateText(texts, sourceLang, targetLang, null);
    }

    public Usage getUsage() throws DeepLException, InterruptedException {
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff("/v2/usage");
        this.checkResponse(response, false, false);
        return this.jsonParser.parseUsage(response.getBody());
    }

    public List<Language> getSourceLanguages() throws DeepLException, InterruptedException {
        return this.getLanguages(LanguageType.Source);
    }

    public List<Language> getTargetLanguages() throws DeepLException, InterruptedException {
        return this.getLanguages(LanguageType.Target);
    }

    public List<Language> getLanguages(LanguageType languageType) throws DeepLException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = new ArrayList<KeyValuePair<String, String>>();
        if (languageType == LanguageType.Target) {
            params.add(new KeyValuePair<String, String>("type", "target"));
        }
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff("/v2/languages", params);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseLanguages(response.getBody());
    }

    public List<GlossaryLanguagePair> getGlossaryLanguages() throws DeepLException, InterruptedException {
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff("/v2/glossary-language-pairs");
        this.checkResponse(response, false, false);
        return this.jsonParser.parseGlossaryLanguageList(response.getBody());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public DocumentStatus translateDocument(File inputFile, File outputFile, @Nullable String sourceLang, String targetLang, @Nullable DocumentTranslationOptions options) throws DocumentTranslationException, IOException {
        try {
            if (outputFile.exists()) {
                throw new IOException("File already exists at output path");
            }
            try (FileInputStream inputStream = new FileInputStream(inputFile);){
                DocumentStatus documentStatus;
                try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                    documentStatus = this.translateDocument(inputStream, inputFile.getName(), outputStream, sourceLang, targetLang, options);
                }
                return documentStatus;
            }
        }
        catch (Exception exception) {
            outputFile.delete();
            throw exception;
        }
    }

    public DocumentStatus translateDocument(File inputFile, File outputFile, @Nullable String sourceLang, String targetLang) throws DocumentTranslationException, IOException {
        return this.translateDocument(inputFile, outputFile, sourceLang, targetLang, null);
    }

    public DocumentStatus translateDocument(InputStream inputStream, String fileName, OutputStream outputStream, @Nullable String sourceLang, String targetLang, @Nullable DocumentTranslationOptions options) throws DocumentTranslationException {
        DocumentHandle handle = null;
        try {
            handle = this.translateDocumentUpload(inputStream, fileName, sourceLang, targetLang, options);
            DocumentStatus status = this.translateDocumentWaitUntilDone(handle);
            this.translateDocumentDownload(handle, outputStream);
            return status;
        }
        catch (Exception exception) {
            throw new DocumentTranslationException("Error occurred during document translation: " + exception.getMessage(), exception, handle);
        }
    }

    public DocumentStatus translateDocument(InputStream inputFile, String fileName, OutputStream outputFile, @Nullable String sourceLang, String targetLang) throws DocumentTranslationException {
        return this.translateDocument(inputFile, fileName, outputFile, sourceLang, targetLang, null);
    }

    public DocumentHandle translateDocumentUpload(File inputFile, @Nullable String sourceLang, String targetLang, @Nullable DocumentTranslationOptions options) throws DeepLException, IOException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = Translator.createHttpParams(sourceLang, targetLang, options);
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            HttpResponse response = this.httpClientWrapper.uploadWithBackoff("/v2/document/", params, inputFile.getName(), inputStream);
            this.checkResponse(response, false, false);
            DocumentHandle documentHandle = this.jsonParser.parseDocumentHandle(response.getBody());
            return documentHandle;
        }
    }

    public DocumentHandle translateDocumentUpload(File inputFile, @Nullable String sourceLang, String targetLang) throws DeepLException, IOException, InterruptedException {
        return this.translateDocumentUpload(inputFile, sourceLang, targetLang, null);
    }

    public DocumentHandle translateDocumentUpload(InputStream inputStream, String fileName, @Nullable String sourceLang, String targetLang, @Nullable DocumentTranslationOptions options) throws DeepLException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = Translator.createHttpParams(sourceLang, targetLang, options);
        HttpResponse response = this.httpClientWrapper.uploadWithBackoff("/v2/document/", params, fileName, inputStream);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseDocumentHandle(response.getBody());
    }

    public DocumentHandle translateDocumentUpload(InputStream inputStream, String fileName, @Nullable String sourceLang, String targetLang) throws DeepLException, InterruptedException {
        return this.translateDocumentUpload(inputStream, fileName, sourceLang, targetLang, null);
    }

    public DocumentStatus translateDocumentStatus(DocumentHandle handle) throws DeepLException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = new ArrayList<KeyValuePair<String, String>>();
        params.add(new KeyValuePair<String, String>("document_key", handle.getDocumentKey()));
        String relativeUrl = String.format("/v2/document/%s", handle.getDocumentId());
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff(relativeUrl, params);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseDocumentStatus(response.getBody());
    }

    public DocumentStatus translateDocumentWaitUntilDone(DocumentHandle handle) throws InterruptedException, DeepLException {
        DocumentStatus status = this.translateDocumentStatus(handle);
        while (status.ok() && !status.done()) {
            Thread.sleep(this.calculateDocumentWaitTimeMillis(status.getSecondsRemaining()));
            status = this.translateDocumentStatus(handle);
        }
        if (!status.ok()) {
            String message = status.getErrorMessage() != null ? status.getErrorMessage() : "Unknown error";
            throw new DeepLException(message);
        }
        return status;
    }

    public void translateDocumentDownload(DocumentHandle handle, File outputFile) throws DeepLException, IOException, InterruptedException {
        try {
            if (outputFile.exists()) {
                throw new IOException("File already exists at output path");
            }
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                this.translateDocumentDownload(handle, outputStream);
            }
        }
        catch (Exception exception) {
            outputFile.delete();
            throw exception;
        }
    }

    public void translateDocumentDownload(DocumentHandle handle, OutputStream outputStream) throws DeepLException, IOException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = new ArrayList<KeyValuePair<String, String>>();
        params.add(new KeyValuePair<String, String>("document_key", handle.getDocumentKey()));
        String relativeUrl = String.format("/v2/document/%s/result", handle.getDocumentId());
        try (HttpResponseStream response = this.httpClientWrapper.downloadWithBackoff(relativeUrl, params);){
            this.checkResponse(response);
            assert (response.getBody() != null);
            StreamUtil.transferTo(response.getBody(), outputStream);
        }
    }

    public GlossaryInfo createGlossary(String name, String sourceLang, String targetLang, GlossaryEntries entries) throws DeepLException, InterruptedException {
        return this.createGlossaryInternal(name, sourceLang, targetLang, "tsv", entries.toTsv());
    }

    public GlossaryInfo createGlossaryFromCsv(String name, String sourceLang, String targetLang, File csvFile) throws DeepLException, InterruptedException, IOException {
        try (FileInputStream stream = new FileInputStream(csvFile);){
            String csvContent = StreamUtil.readStream(stream);
            GlossaryInfo glossaryInfo = this.createGlossaryFromCsv(name, sourceLang, targetLang, csvContent);
            return glossaryInfo;
        }
    }

    public GlossaryInfo createGlossaryFromCsv(String name, String sourceLang, String targetLang, String csvContent) throws DeepLException, InterruptedException {
        return this.createGlossaryInternal(name, sourceLang, targetLang, "csv", csvContent);
    }

    public GlossaryInfo getGlossary(String glossaryId) throws DeepLException, InterruptedException {
        String relativeUrl = String.format("/v2/glossaries/%s", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff(relativeUrl);
        this.checkResponse(response, false, true);
        return this.jsonParser.parseGlossaryInfo(response.getBody());
    }

    public List<GlossaryInfo> listGlossaries() throws DeepLException, InterruptedException {
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff("/v2/glossaries");
        this.checkResponse(response, false, false);
        return this.jsonParser.parseGlossaryInfoList(response.getBody());
    }

    public GlossaryEntries getGlossaryEntries(GlossaryInfo glossary) throws DeepLException, InterruptedException {
        return this.getGlossaryEntries(glossary.getGlossaryId());
    }

    public GlossaryEntries getGlossaryEntries(String glossaryId) throws DeepLException, InterruptedException {
        String relativeUrl = String.format("/v2/glossaries/%s/entries", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff(relativeUrl);
        this.checkResponse(response, false, true);
        return GlossaryEntries.fromTsv(response.getBody());
    }

    public void deleteGlossary(GlossaryInfo glossary) throws DeepLException, InterruptedException {
        this.deleteGlossary(glossary.getGlossaryId());
    }

    public void deleteGlossary(String glossaryId) throws DeepLException, InterruptedException {
        String relativeUrl = String.format("/v2/glossaries/%s", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendDeleteRequestWithBackoff(relativeUrl);
        this.checkResponse(response, false, true);
    }

    private static ArrayList<KeyValuePair<String, String>> createHttpParams(List<String> texts, @Nullable String sourceLang, String targetLang, @Nullable TextTranslationOptions options) {
        ArrayList<KeyValuePair<String, String>> params = Translator.createHttpParamsCommon(sourceLang, targetLang, options != null ? options.getFormality() : null, options != null ? options.getGlossaryId() : null);
        texts.forEach(text -> {
            if (text.isEmpty()) {
                throw new IllegalArgumentException("text must not be empty");
            }
            params.add(new KeyValuePair<String, String>("text", (String)text));
        });
        if (options != null) {
            if (options.getSentenceSplittingMode() != null) {
                switch (options.getSentenceSplittingMode()) {
                    case Off: {
                        params.add(new KeyValuePair<String, String>("split_sentences", "0"));
                        break;
                    }
                    case NoNewlines: {
                        params.add(new KeyValuePair<String, String>("split_sentences", "nonewlines"));
                        break;
                    }
                    case All: {
                        params.add(new KeyValuePair<String, String>("split_sentences", "1"));
                        break;
                    }
                }
            }
            if (options.isPreserveFormatting()) {
                params.add(new KeyValuePair<String, String>("preserve_formatting", "1"));
            }
            if (options.getTagHandling() != null) {
                params.add(new KeyValuePair<String, String>("tag_handling", options.getTagHandling()));
            }
            if (!options.isOutlineDetection()) {
                params.add(new KeyValuePair<String, String>("outline_detection", "0"));
            }
            if (options.getSplittingTags() != null) {
                params.add(new KeyValuePair<String, String>("splitting_tags", Translator.joinTags(options.getSplittingTags())));
            }
            if (options.getNonSplittingTags() != null) {
                params.add(new KeyValuePair<String, String>("non_splitting_tags", Translator.joinTags(options.getNonSplittingTags())));
            }
            if (options.getIgnoreTags() != null) {
                params.add(new KeyValuePair<String, String>("ignore_tags", Translator.joinTags(options.getIgnoreTags())));
            }
        }
        return params;
    }

    private static ArrayList<KeyValuePair<String, String>> createHttpParams(String sourceLang, String targetLang, DocumentTranslationOptions options) {
        return Translator.createHttpParamsCommon(sourceLang, targetLang, options != null ? options.getFormality() : null, options != null ? options.getGlossaryId() : null);
    }

    private static ArrayList<KeyValuePair<String, String>> createHttpParamsCommon(@Nullable String sourceLang, String targetLang, @Nullable Formality formality, @Nullable String glossaryId) {
        targetLang = LanguageCode.standardize(targetLang);
        sourceLang = sourceLang == null ? null : LanguageCode.standardize(sourceLang);
        Translator.checkValidLanguages(sourceLang, targetLang);
        ArrayList<KeyValuePair<String, String>> params = new ArrayList<KeyValuePair<String, String>>();
        if (sourceLang != null) {
            params.add(new KeyValuePair<String, String>("source_lang", sourceLang));
        }
        params.add(new KeyValuePair<String, String>("target_lang", targetLang));
        if (formality != null) {
            switch (formality) {
                case More: {
                    params.add(new KeyValuePair<String, String>("formality", "more"));
                    break;
                }
                case Less: {
                    params.add(new KeyValuePair<String, String>("formality", "less"));
                    break;
                }
                case PreferMore: {
                    params.add(new KeyValuePair<String, String>("formality", "prefer_more"));
                    break;
                }
                case PreferLess: {
                    params.add(new KeyValuePair<String, String>("formality", "prefer_less"));
                    break;
                }
                default: {
                    params.add(new KeyValuePair<String, String>("formality", "default"));
                }
            }
        }
        if (glossaryId != null) {
            if (sourceLang == null) {
                throw new IllegalArgumentException("sourceLang is required if using a glossary");
            }
            params.add(new KeyValuePair<String, String>("glossary_id", glossaryId));
        }
        return params;
    }

    private static String joinTags(Iterable<String> tags) {
        return String.join((CharSequence)",", tags);
    }

    private static void checkValidLanguages(@Nullable String sourceLang, String targetLang) throws IllegalArgumentException {
        if (sourceLang != null && sourceLang.isEmpty()) {
            throw new IllegalArgumentException("sourceLang must be null or non-empty");
        }
        if (targetLang.isEmpty()) {
            throw new IllegalArgumentException("targetLang must not be empty");
        }
        switch (targetLang) {
            case "en": {
                throw new IllegalArgumentException("targetLang=\"en\" is not allowed, please use \"en-GB\" or \"en-US\" instead");
            }
            case "pt": {
                throw new IllegalArgumentException("targetLang=\"pt\" is not allowed, please use \"pt-PT\" or \"pt-BR\" instead");
            }
        }
    }

    private GlossaryInfo createGlossaryInternal(String name, String sourceLang, String targetLang, String entriesFormat, String entries) throws DeepLException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = new ArrayList<KeyValuePair<String, String>>();
        params.add(new KeyValuePair<String, String>("name", name));
        params.add(new KeyValuePair<String, String>("source_lang", sourceLang));
        params.add(new KeyValuePair<String, String>("target_lang", targetLang));
        params.add(new KeyValuePair<String, String>("entries_format", entriesFormat));
        params.add(new KeyValuePair<String, String>("entries", entries));
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff("/v2/glossaries", params);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseGlossaryInfo(response.getBody());
    }

    private void checkResponse(HttpResponseStream response) throws DeepLException {
        if (response.getCode() >= 200 && response.getCode() < 400) {
            return;
        }
        if (response.getBody() == null) {
            throw new DeepLException("response stream is empty");
        }
        this.checkResponse(response.toStringResponse(), true, false);
    }

    private void checkResponse(HttpResponse response, boolean inDocumentDownload, boolean usingGlossary) throws DeepLException {
        if (response.getCode() >= 200 && response.getCode() < 300) {
            return;
        }
        String messageSuffix = "";
        String body = response.getBody();
        if (body != null && !body.isEmpty()) {
            try {
                messageSuffix = ", error message: " + this.jsonParser.parseErrorMessage(body);
            }
            catch (JsonSyntaxException ignored) {
                messageSuffix = ", response: " + body;
            }
        }
        switch (response.getCode()) {
            case 400: {
                throw new DeepLException("Bad request" + messageSuffix);
            }
            case 403: {
                throw new AuthorizationException("Authorization failure, check auth_key" + messageSuffix);
            }
            case 404: {
                if (usingGlossary) {
                    throw new GlossaryNotFoundException("Glossary not found" + messageSuffix);
                }
                throw new NotFoundException("Not found, check serverUrl" + messageSuffix);
            }
            case 429: {
                throw new TooManyRequestsException("Too many requests, DeepL servers are currently experiencing high load" + messageSuffix);
            }
            case 456: {
                throw new QuotaExceededException("Quota for this billing period has been exceeded" + messageSuffix);
            }
            case 503: {
                if (inDocumentDownload) {
                    throw new DocumentNotReadyException("Document not ready" + messageSuffix);
                }
                throw new DeepLException("Service unavailable" + messageSuffix);
            }
        }
        throw new DeepLException("Unknown error" + messageSuffix);
    }

    private int calculateDocumentWaitTimeMillis(Long secondsRemaining) {
        return 5000;
    }
}

