/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.impl;

import java.util.Locale;
import org.exoplatform.automatic.translation.api.AutomaticTranslationComponentPlugin;
import org.exoplatform.automatic.translation.api.dto.AutomaticTranslationConfiguration;
import org.exoplatform.automatic.translation.api.dto.AutomaticTranslationFeaturesOptions;
import org.exoplatform.automatic.translation.api.dto.Connector;
import org.exoplatform.automatic.translation.impl.AutomaticTranslationServiceImpl;
import org.exoplatform.automatic.translation.impl.connectors.GoogleTranslateConnector;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AutomaticTranslationServiceTest {
    private static final String AUTOMATIC_TRANSLATION_API_KEY = "automaticTranslationApiKey";
    private static final String AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR = "automaticTranslationActiveConnector";
    private static final String AUTOMATIC_TRANSLATION_FEATURES_OPTIONS = "automaticTranslationFeaturesOptions";
    private static final String FEATURE_NAME = "automatic-translation";
    @Mock
    SettingService settingService;
    @Mock
    ExoFeatureService exoFeatureService;
    @Mock
    ListenerService listenerService;

    @Before
    public void setUp() {
        this.settingService = (SettingService)Mockito.mock(SettingService.class);
        this.exoFeatureService = (ExoFeatureService)Mockito.mock(ExoFeatureService.class);
        this.listenerService = (ListenerService)Mockito.mock(ListenerService.class);
    }

    @Test
    public void testAddConnector() {
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        GoogleTranslateConnector translationConnector = new GoogleTranslateConnector(this.settingService);
        translationConnector.setName("google");
        translationConnector.setDescription("google");
        translationService.addConnector((AutomaticTranslationComponentPlugin)translationConnector);
        Assert.assertEquals((long)1L, (long)translationService.getConnectors().size());
        Assert.assertEquals((Object)"google", (Object)((AutomaticTranslationComponentPlugin)translationService.getConnectors().get("google")).getName());
    }

    @Test
    public void testGetActiveConnectorWhenNotConfigured() {
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR)).thenReturn(null);
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        Assert.assertNull((Object)translationService.getActiveConnector());
    }

    @Test
    public void testGetActiveConnectorWhenConfigured() {
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        SettingValue setting = new SettingValue((Object)"google");
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR)).thenReturn((Object)setting);
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        GoogleTranslateConnector translationConnector = new GoogleTranslateConnector(this.settingService);
        translationConnector.setName("google");
        translationConnector.setDescription("google");
        translationService.addConnector((AutomaticTranslationComponentPlugin)translationConnector);
        Assert.assertEquals((Object)"google", (Object)translationService.getActiveConnector());
    }

    @Test
    public void testCallTranslateForActiveConnector() {
        SettingValue setting = new SettingValue((Object)"google");
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR)).thenReturn((Object)setting);
        AutomaticTranslationComponentPlugin translationConnector = (AutomaticTranslationComponentPlugin)Mockito.mock(GoogleTranslateConnector.class);
        Mockito.when((Object)translationConnector.getName()).thenReturn((Object)"google");
        String message = "message to translate";
        Mockito.when((Object)translationConnector.translate(message, Locale.FRANCE)).thenReturn((Object)"message translated");
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        translationService.addConnector(translationConnector);
        Assert.assertEquals((Object)"message translated", (Object)translationService.translate(message, Locale.FRANCE, "test", 1L));
    }

    @Test
    public void testSetActiveConnector() {
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        String connectorName = "google";
        GoogleTranslateConnector translationConnector = new GoogleTranslateConnector(this.settingService);
        translationConnector.setName("google");
        translationConnector.setDescription("google");
        translationService.addConnector((AutomaticTranslationComponentPlugin)translationConnector);
        try {
            translationService.setActiveConnector(connectorName);
            ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)Context.GLOBAL), (Scope)ArgumentMatchers.eq((Object)Scope.GLOBAL), (String)ArgumentMatchers.eq((Object)AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR), (SettingValue)ArgumentMatchers.argThat(argument -> argument.getValue().equals(connectorName)));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetActiveConnectorWithFeatureNotActive() {
        SettingValue setting = new SettingValue((Object)"google");
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR)).thenReturn((Object)setting);
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        Assert.assertFalse((boolean)translationService.isFeatureActive());
    }

    @Test
    public void testSetNonExistingActiveConnector() {
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        String connectorName = "google";
        try {
            translationService.setActiveConnector(connectorName);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetActiveConnectorWhenFeatureNotActive() {
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        String connectorName = "google";
        GoogleTranslateConnector translationConnector = new GoogleTranslateConnector(this.settingService);
        translationConnector.setName("google");
        translationConnector.setDescription("google");
        translationService.addConnector((AutomaticTranslationComponentPlugin)translationConnector);
        try {
            translationService.setActiveConnector(connectorName);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUnSetConnector() {
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        String connectorName = "";
        try {
            translationService.setActiveConnector(connectorName);
            connectorName = null;
            translationService.setActiveConnector(connectorName);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testSetApiKeyWhenConnectorNotExists() {
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        String connectorName = "google";
        try {
            translationService.setApiKey(connectorName, "123456");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetApiKeyWhenConnectorExists() {
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        String connectorName = "google";
        GoogleTranslateConnector translationConnector = new GoogleTranslateConnector(this.settingService);
        translationConnector.setName("google");
        translationConnector.setDescription("google");
        translationService.addConnector((AutomaticTranslationComponentPlugin)translationConnector);
        try {
            translationService.setApiKey(connectorName, "123456");
            ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)Context.GLOBAL), (Scope)ArgumentMatchers.eq((Object)Scope.GLOBAL), (String)ArgumentMatchers.eq((Object)("automaticTranslationApiKey-" + connectorName)), (SettingValue)ArgumentMatchers.argThat(argument -> argument.getValue().equals("123456")));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetConfiguration() {
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        SettingValue settingConnector = new SettingValue((Object)"systran");
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR)).thenReturn((Object)settingConnector);
        SettingValue settingKey = new SettingValue((Object)"123456");
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "automaticTranslationApiKey-systran")).thenReturn((Object)settingKey);
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        GoogleTranslateConnector translationConnector = new GoogleTranslateConnector(this.settingService);
        translationConnector.setName("google");
        translationConnector.setDescription("google");
        translationService.addConnector((AutomaticTranslationComponentPlugin)translationConnector);
        GoogleTranslateConnector translationConnector2 = new GoogleTranslateConnector(this.settingService);
        translationConnector2.setName("systran");
        translationConnector2.setDescription("systran");
        translationService.addConnector((AutomaticTranslationComponentPlugin)translationConnector2);
        AutomaticTranslationConfiguration configuration = translationService.getConfiguration();
        Assert.assertEquals((long)2L, (long)configuration.getConnectors().size());
        Assert.assertEquals((Object)"google", (Object)((Connector)configuration.getConnectors().get(0)).getName());
        Assert.assertEquals((Object)"systran", (Object)((Connector)configuration.getConnectors().get(1)).getName());
        Assert.assertEquals((Object)"123456", (Object)configuration.getActiveApiKey());
        Assert.assertEquals((Object)"systran", (Object)configuration.getActiveConnector());
        Assert.assertEquals(null, (Object)((Connector)configuration.getConnectors().get(0)).getApiKey());
        Assert.assertEquals((Object)"123456", (Object)((Connector)configuration.getConnectors().get(1)).getApiKey());
    }

    @Test
    public void testGoogleConnectorTranslate() {
        Mockito.when((Object)this.exoFeatureService.isActiveFeature(FEATURE_NAME)).thenReturn((Object)true);
        SettingValue settingConnector = new SettingValue((Object)"systran");
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_ACTIVE_CONNECTOR)).thenReturn((Object)settingConnector);
        SettingValue settingKey = new SettingValue((Object)"123456");
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "automaticTranslationApiKey-systran")).thenReturn((Object)settingKey);
        GoogleTranslateConnector googleTranslateConnector = new GoogleTranslateConnector(this.settingService);
        String result = googleTranslateConnector.translate("message to translate", Locale.ENGLISH);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetFeatureOptions() {
        AutomaticTranslationServiceImpl translationService = new AutomaticTranslationServiceImpl(this.settingService, this.exoFeatureService, this.listenerService);
        AutomaticTranslationFeaturesOptions automaticTranslationFeaturesOptions = translationService.getFeaturesOptions();
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getNewsTranslateView());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getNotesTranslateEdition());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getNotesTranslateView());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getStreamTranslateShort());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getStreamTranslateComment());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getNewsTranslateEdition());
        automaticTranslationFeaturesOptions.setNewsTranslateView(Boolean.valueOf(false));
        automaticTranslationFeaturesOptions.setNotesTranslateView(Boolean.valueOf(false));
        translationService.setFeaturesOptions(automaticTranslationFeaturesOptions);
        SettingValue settingKey = new SettingValue((Object)"{\"streamTranslateShort\":true,\"streamTranslateComment\":true,\"newsTranslateView\":false,\"notesTranslateView\":false,\"notesTranslateEdition\":true}");
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, AUTOMATIC_TRANSLATION_FEATURES_OPTIONS)).thenReturn((Object)settingKey);
        automaticTranslationFeaturesOptions = translationService.getFeaturesOptions();
        Assert.assertFalse((boolean)automaticTranslationFeaturesOptions.getNewsTranslateView());
        Assert.assertFalse((boolean)automaticTranslationFeaturesOptions.getNotesTranslateView());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getStreamTranslateShort());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getStreamTranslateComment());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getNotesTranslateEdition());
        Assert.assertTrue((boolean)automaticTranslationFeaturesOptions.getNewsTranslateEdition());
    }
}

