/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.portlet.bonita.task;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import juzu.Action;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.impl.request.Request;
import juzu.template.Template;
import org.exoplatform.addons.bonita.service.BonitaService;
import org.exoplatform.extension.portlet.bonita.task.BonitaTaskApplication_;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BonitaTaskApplication {
    @Inject
    @Path(value="task.gtmpl")
    Template index;
    @Inject
    @Path(value="taskWithService.gtmpl")
    Template indexNotSSO;
    @Inject
    @Path(value="configuration.gtmpl")
    Template configuration;
    private BonitaService bonitaService;
    private static final Log LOG = ExoLogger.getLogger(BonitaTaskApplication.class);

    @Inject
    public void BonitaTaskApplication(BonitaService bonitaService) {
        this.bonitaService = bonitaService;
    }

    @View
    public Response index(String message) {
        if (message == null) {
            message = "";
        }
        String username = Request.getCurrent().getSecurityContext().getUserPrincipal().getName();
        if (this.bonitaService.isUseSSO()) {
            return this.index.with().set("bonitaUrl", (Object)this.bonitaService.getBonitaServerUrl()).ok();
        }
        if (!this.bonitaService.isConfigured(username)) {
            String bonitaUrl = System.getProperty("bonita.server.url");
            if (bonitaUrl == null) {
                bonitaUrl = "";
            }
            return this.configuration.with().set("message", (Object)message).set("bonitaUrl", (Object)bonitaUrl).ok();
        }
        return this.indexNotSSO.with().set("bonitaUrl", (Object)this.bonitaService.getUserAttributeFromProfile("bonita.server.url", username)).ok();
    }

    @Action
    public Response.View saveSettings(String bonitaServerName, String bonitaUsername, String bonitaPassword) {
        String username = Request.getCurrent().getSecurityContext().getUserPrincipal().getName();
        String url = bonitaServerName.endsWith("/") ? bonitaServerName : bonitaServerName + "/";
        url = url + "bonita/loginservice?username=" + bonitaUsername + "&password=" + bonitaPassword + "&redirect=false";
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                this.bonitaService.setConfigured(username, bonitaServerName, bonitaUsername, bonitaPassword);
                return BonitaTaskApplication_.index((String)"Connexion OK");
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)(url + "is malFormed"));
            e.printStackTrace();
        }
        catch (IOException e) {
            LOG.error((Object)("IOException on " + url));
            e.printStackTrace();
        }
        return BonitaTaskApplication_.index((String)"Connexion Error");
    }
}

