/*
 * Copyright (C) 2003-2014 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.brandadvocacy.model;

import org.exoplatform.web.url.MimeType;

/**
 * Created by The eXo Platform SAS
 * Author : eXoPlatform
 *          exo@exoplatform.com
 * Sep 11, 2014  
 */
public enum Size {
  
  Extra_Small(1),
  Small(2),
  Medium(3),
  Large(4),
  Extra_Large(5),
  Extra_Extra_Large(6);
  

  private final int size;

  Size(int size) {
      this.size = size;
  }

  public int getValue() {
      return this.size;
  }

  public String getLabel() {
      switch (this.size) {
        case 6:
          return "Size XXL";
        case 5:
          return "Size XL";
        case 4:
          return "Size L";
        case 3:
            return "Size M";
        case 2:
            return "Size S";
        case 1:
            return "Size XS";
        default:
            return "Customization";
      }
  }

  public static Size getSize(int size) {
      for (Size type : Size.values()) {
          if (type.getValue() == size) {
              return type;
          }
      }

      return Medium;
  }
}

